<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelInfoCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of hotel codes and descriptions.
 * @subpackage Structs
 */
class HotelInfoCodes extends AbstractStructBase
{
    /**
     * The HotelInfoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\HotelInfoCode[]
     */
    public $HotelInfoCode;
    /**
     * Constructor method for HotelInfoCodes
     * @uses HotelInfoCodes::setHotelInfoCode()
     * @param \StructType\HotelInfoCode[] $hotelInfoCode
     */
    public function __construct(array $hotelInfoCode = array())
    {
        $this
            ->setHotelInfoCode($hotelInfoCode);
    }
    /**
     * Get HotelInfoCode value
     * @return \StructType\HotelInfoCode[]|null
     */
    public function getHotelInfoCode()
    {
        return $this->HotelInfoCode;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelInfoCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelInfoCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelInfoCodeForArrayConstraintsFromSetHotelInfoCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelInfoCodesHotelInfoCodeItem) {
            // validation for constraint: itemType
            if (!$hotelInfoCodesHotelInfoCodeItem instanceof \StructType\HotelInfoCode) {
                $invalidValues[] = is_object($hotelInfoCodesHotelInfoCodeItem) ? get_class($hotelInfoCodesHotelInfoCodeItem) : sprintf('%s(%s)', gettype($hotelInfoCodesHotelInfoCodeItem), var_export($hotelInfoCodesHotelInfoCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelInfoCode property can only contain items of type \StructType\HotelInfoCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelInfoCode value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelInfoCode[] $hotelInfoCode
     * @return \StructType\HotelInfoCodes
     */
    public function setHotelInfoCode(array $hotelInfoCode = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelInfoCodeArrayErrorMessage = self::validateHotelInfoCodeForArrayConstraintsFromSetHotelInfoCode($hotelInfoCode))) {
            throw new \InvalidArgumentException($hotelInfoCodeArrayErrorMessage, __LINE__);
        }
        $this->HotelInfoCode = $hotelInfoCode;
        return $this;
    }
    /**
     * Add item to HotelInfoCode value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelInfoCode $item
     * @return \StructType\HotelInfoCodes
     */
    public function addToHotelInfoCode(\StructType\HotelInfoCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelInfoCode) {
            throw new \InvalidArgumentException(sprintf('The HotelInfoCode property can only contain items of type \StructType\HotelInfoCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelInfoCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelInfoCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
