<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelDescriptiveContent StructType
 * Meta information extracted from the WSDL
 * - documentation: The hotel reference identifies a specific hotel by using the chain code, the brand code, and the hotel code. The codes used are agreed upon by trading partners. | A hotel descriptive content message that was not successfully
 * processed.
 * @subpackage Structs
 */
class HotelDescriptiveContent extends HotelDescriptiveContentType
{
    /**
     * The WarningRPH
     * Meta information extracted from the WSDL
     * - documentation: Refers to one or more warning elements giving details of one or more processing problems. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual
     * passengers or clients to particular itinerary items). | List of Reference Place Holders.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string[]
     */
    public $WarningRPH;
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * @var string
     */
    public $HotelCityCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * @var string
     */
    public $BrandName;
    /**
     * The AreaID
     * @var string
     */
    public $AreaID;
    /**
     * The TTIcode
     * @var int
     */
    public $TTIcode;
    /**
     * Constructor method for HotelDescriptiveContent
     * @uses HotelDescriptiveContent::setWarningRPH()
     * @uses HotelDescriptiveContent::setChainCode()
     * @uses HotelDescriptiveContent::setBrandCode()
     * @uses HotelDescriptiveContent::setHotelCode()
     * @uses HotelDescriptiveContent::setHotelCityCode()
     * @uses HotelDescriptiveContent::setHotelName()
     * @uses HotelDescriptiveContent::setHotelCodeContext()
     * @uses HotelDescriptiveContent::setChainName()
     * @uses HotelDescriptiveContent::setBrandName()
     * @uses HotelDescriptiveContent::setAreaID()
     * @uses HotelDescriptiveContent::setTTIcode()
     * @param string[] $warningRPH
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $areaID
     * @param int $tTIcode
     */
    public function __construct(array $warningRPH = array(), $chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $areaID = null, $tTIcode = null)
    {
        $this
            ->setWarningRPH($warningRPH)
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setAreaID($areaID)
            ->setTTIcode($tTIcode);
    }
    /**
     * Get WarningRPH value
     * @return string[]|null
     */
    public function getWarningRPH()
    {
        return $this->WarningRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setWarningRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarningRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningRPHForArrayConstraintsFromSetWarningRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelDescriptiveContentWarningRPHItem) {
            // validation for constraint: itemType
            if (!is_string($hotelDescriptiveContentWarningRPHItem)) {
                $invalidValues[] = is_object($hotelDescriptiveContentWarningRPHItem) ? get_class($hotelDescriptiveContentWarningRPHItem) : sprintf('%s(%s)', gettype($hotelDescriptiveContentWarningRPHItem), var_export($hotelDescriptiveContentWarningRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WarningRPH property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WarningRPH value
     * @param string[] $warningRPH
     * @return \StructType\HotelDescriptiveContent
     */
    public function setWarningRPH(array $warningRPH = array())
    {
        // validation for constraint: list
        if ('' !== ($warningRPHArrayErrorMessage = self::validateWarningRPHForArrayConstraintsFromSetWarningRPH($warningRPH))) {
            throw new \InvalidArgumentException($warningRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($warningRPH) && !preg_match('/[0-9]{1,8}/', $warningRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($warningRPH, true)), __LINE__);
        }
        $this->WarningRPH = is_array($warningRPH) ? implode(' ', $warningRPH) : null;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\HotelDescriptiveContent
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \StructType\HotelDescriptiveContent
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandCode, true), gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\HotelDescriptiveContent
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \StructType\HotelDescriptiveContent
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCityCode, true), gettype($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \StructType\HotelDescriptiveContent
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelName, true), gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \StructType\HotelDescriptiveContent
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeContext, true), gettype($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \StructType\HotelDescriptiveContent
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainName, true), gettype($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \StructType\HotelDescriptiveContent
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\HotelDescriptiveContent
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get TTIcode value
     * @return int|null
     */
    public function getTTIcode()
    {
        return $this->TTIcode;
    }
    /**
     * Set TTIcode value
     * @param int $tTIcode
     * @return \StructType\HotelDescriptiveContent
     */
    public function setTTIcode($tTIcode = null)
    {
        // validation for constraint: int
        if (!is_null($tTIcode) && !(is_int($tTIcode) || ctype_digit($tTIcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tTIcode, true), gettype($tTIcode)), __LINE__);
        }
        $this->TTIcode = $tTIcode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelDescriptiveContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
