<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelAmenity StructType
 * Meta information extracted from the WSDL
 * - documentation: Hotel level amenities for searches. | Hotel-level amenities (pool, etc) for searching.
 * @subpackage Structs
 */
class HotelAmenity extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: An amenity available to guests that applies to the property as a whole (hotel level) versus an individual guest or meeting room type. Refer to OpenTravel Code List Hotel Amenity Code (HAC). | Refer to OpenTravel Code List Hotel
     * Amenity Code (HAC).
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The ComplimentaryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, there is no charge for the amenity. When false, there is a fee associated with the amenity.
     * - use: optional
     * @var bool
     */
    public $ComplimentaryInd;
    /**
     * The EquivalenceGroup
     * Meta information extracted from the WSDL
     * - base: xs:positiveInteger
     * - maxInclusive: 3
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $EquivalenceGroup;
    /**
     * Constructor method for HotelAmenity
     * @uses HotelAmenity::setCode()
     * @uses HotelAmenity::setComplimentaryInd()
     * @uses HotelAmenity::setEquivalenceGroup()
     * @param string $code
     * @param bool $complimentaryInd
     * @param int $equivalenceGroup
     */
    public function __construct($code = null, $complimentaryInd = null, $equivalenceGroup = null)
    {
        $this
            ->setCode($code)
            ->setComplimentaryInd($complimentaryInd)
            ->setEquivalenceGroup($equivalenceGroup);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\HotelAmenity
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get ComplimentaryInd value
     * @return bool|null
     */
    public function getComplimentaryInd()
    {
        return $this->ComplimentaryInd;
    }
    /**
     * Set ComplimentaryInd value
     * @param bool $complimentaryInd
     * @return \StructType\HotelAmenity
     */
    public function setComplimentaryInd($complimentaryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($complimentaryInd) && !is_bool($complimentaryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($complimentaryInd, true), gettype($complimentaryInd)), __LINE__);
        }
        $this->ComplimentaryInd = $complimentaryInd;
        return $this;
    }
    /**
     * Get EquivalenceGroup value
     * @return int|null
     */
    public function getEquivalenceGroup()
    {
        return $this->EquivalenceGroup;
    }
    /**
     * Set EquivalenceGroup value
     * @param int $equivalenceGroup
     * @return \StructType\HotelAmenity
     */
    public function setEquivalenceGroup($equivalenceGroup = null)
    {
        // validation for constraint: int
        if (!is_null($equivalenceGroup) && !(is_int($equivalenceGroup) || ctype_digit($equivalenceGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($equivalenceGroup, true), gettype($equivalenceGroup)), __LINE__);
        }
        // validation for constraint: maxInclusive(3)
        if (!is_null($equivalenceGroup) && $equivalenceGroup > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 3', var_export($equivalenceGroup, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($equivalenceGroup) && $equivalenceGroup < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($equivalenceGroup, true)), __LINE__);
        }
        $this->EquivalenceGroup = $equivalenceGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HotelAmenity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
