<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestRoomType StructType
 * Meta information extracted from the WSDL
 * - documentation: GuestRoomType is used to contain all the information on a guest room.
 * @subpackage Structs
 */
class GuestRoomType extends AbstractStructBase
{
    /**
     * The Quantities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Quantities
     */
    public $Quantities;
    /**
     * The Occupancy
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Occupancy[]
     */
    public $Occupancy;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Room
     */
    public $Room;
    /**
     * The Amenities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amenities
     */
    public $Amenities;
    /**
     * The RoomLevelFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomLevelFees
     */
    public $RoomLevelFees;
    /**
     * The AdditionalGuestAmount
     * Meta information extracted from the WSDL
     * - documentation: Additional guest amounts which are attached to room, not rate.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AdditionalGuestAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the Room.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * Constructor method for GuestRoomType
     * @uses GuestRoomType::setQuantities()
     * @uses GuestRoomType::setOccupancy()
     * @uses GuestRoomType::setRoom()
     * @uses GuestRoomType::setAmenities()
     * @uses GuestRoomType::setRoomLevelFees()
     * @uses GuestRoomType::setAdditionalGuestAmount()
     * @uses GuestRoomType::setDescription()
     * @param \StructType\Quantities $quantities
     * @param \StructType\Occupancy[] $occupancy
     * @param \StructType\Room $room
     * @param \StructType\Amenities $amenities
     * @param \StructType\RoomLevelFees $roomLevelFees
     * @param mixed[] $additionalGuestAmount
     * @param mixed $description
     */
    public function __construct(\StructType\Quantities $quantities = null, array $occupancy = array(), \StructType\Room $room = null, \StructType\Amenities $amenities = null, \StructType\RoomLevelFees $roomLevelFees = null, array $additionalGuestAmount = array(), $description = null)
    {
        $this
            ->setQuantities($quantities)
            ->setOccupancy($occupancy)
            ->setRoom($room)
            ->setAmenities($amenities)
            ->setRoomLevelFees($roomLevelFees)
            ->setAdditionalGuestAmount($additionalGuestAmount)
            ->setDescription($description);
    }
    /**
     * Get Quantities value
     * @return \StructType\Quantities|null
     */
    public function getQuantities()
    {
        return $this->Quantities;
    }
    /**
     * Set Quantities value
     * @param \StructType\Quantities $quantities
     * @return \StructType\GuestRoomType
     */
    public function setQuantities(\StructType\Quantities $quantities = null)
    {
        $this->Quantities = $quantities;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return \StructType\Occupancy[]|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * This method is responsible for validating the values passed to the setOccupancy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOccupancy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOccupancyForArrayConstraintsFromSetOccupancy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRoomTypeOccupancyItem) {
            // validation for constraint: itemType
            if (!$guestRoomTypeOccupancyItem instanceof \StructType\Occupancy) {
                $invalidValues[] = is_object($guestRoomTypeOccupancyItem) ? get_class($guestRoomTypeOccupancyItem) : sprintf('%s(%s)', gettype($guestRoomTypeOccupancyItem), var_export($guestRoomTypeOccupancyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy[] $occupancy
     * @return \StructType\GuestRoomType
     */
    public function setOccupancy(array $occupancy = array())
    {
        // validation for constraint: array
        if ('' !== ($occupancyArrayErrorMessage = self::validateOccupancyForArrayConstraintsFromSetOccupancy($occupancy))) {
            throw new \InvalidArgumentException($occupancyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($occupancy) && count($occupancy) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Add item to Occupancy value
     * @throws \InvalidArgumentException
     * @param \StructType\Occupancy $item
     * @return \StructType\GuestRoomType
     */
    public function addToOccupancy(\StructType\Occupancy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Occupancy) {
            throw new \InvalidArgumentException(sprintf('The Occupancy property can only contain items of type \StructType\Occupancy, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Occupancy) && count($this->Occupancy) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Occupancy)), __LINE__);
        }
        $this->Occupancy[] = $item;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * Set Room value
     * @param \StructType\Room $room
     * @return \StructType\GuestRoomType
     */
    public function setRoom(\StructType\Room $room = null)
    {
        $this->Room = $room;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \StructType\Amenities|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \StructType\Amenities $amenities
     * @return \StructType\GuestRoomType
     */
    public function setAmenities(\StructType\Amenities $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get RoomLevelFees value
     * @return \StructType\RoomLevelFees|null
     */
    public function getRoomLevelFees()
    {
        return $this->RoomLevelFees;
    }
    /**
     * Set RoomLevelFees value
     * @param \StructType\RoomLevelFees $roomLevelFees
     * @return \StructType\GuestRoomType
     */
    public function setRoomLevelFees(\StructType\RoomLevelFees $roomLevelFees = null)
    {
        $this->RoomLevelFees = $roomLevelFees;
        return $this;
    }
    /**
     * Get AdditionalGuestAmount value
     * @return mixed[]|null
     */
    public function getAdditionalGuestAmount()
    {
        return $this->AdditionalGuestAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalGuestAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalGuestAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalGuestAmountForArrayConstraintsFromSetAdditionalGuestAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRoomTypeAdditionalGuestAmountItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($guestRoomTypeAdditionalGuestAmountItem) ? get_class($guestRoomTypeAdditionalGuestAmountItem) : sprintf('%s(%s)', gettype($guestRoomTypeAdditionalGuestAmountItem), var_export($guestRoomTypeAdditionalGuestAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalGuestAmount property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalGuestAmount value
     * @throws \InvalidArgumentException
     * @param mixed[] $additionalGuestAmount
     * @return \StructType\GuestRoomType
     */
    public function setAdditionalGuestAmount(array $additionalGuestAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalGuestAmountArrayErrorMessage = self::validateAdditionalGuestAmountForArrayConstraintsFromSetAdditionalGuestAmount($additionalGuestAmount))) {
            throw new \InvalidArgumentException($additionalGuestAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($additionalGuestAmount) && count($additionalGuestAmount) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($additionalGuestAmount)), __LINE__);
        }
        $this->AdditionalGuestAmount = $additionalGuestAmount;
        return $this;
    }
    /**
     * Add item to AdditionalGuestAmount value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\GuestRoomType
     */
    public function addToAdditionalGuestAmount($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AdditionalGuestAmount property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->AdditionalGuestAmount) && count($this->AdditionalGuestAmount) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->AdditionalGuestAmount)), __LINE__);
        }
        $this->AdditionalGuestAmount[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\GuestRoomType
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestRoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
