<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestRoom StructType
 * Meta information extracted from the WSDL
 * - documentation: This may be used to uniquely identify a guest room. | The hotel specific room type code that does not reference the OpenTravel Code Table as there are numerous hotel room types that are chain specific. | The accommodation occupied by
 * a guest.
 * @subpackage Structs
 */
class GuestRoom extends AbstractStructBase
{
    /**
     * The TypeRoom
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\TypeRoom[]
     */
    public $TypeRoom;
    /**
     * The Amenities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amenities
     */
    public $Amenities;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - documentation: Collection of features offered by a hotel.
     * - minOccurs: 0
     * @var mixed
     */
    public $Features;
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - documentation: Multimedia information about the guest room.
     * - minOccurs: 0
     * @var mixed
     */
    public $MultimediaDescriptions;
    /**
     * The DescriptiveText
     * Meta information extracted from the WSDL
     * - documentation: Descriptive text that describes the guest room.
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The RoomTypeName
     * Meta information extracted from the WSDL
     * - documentation: The room type name.
     * - use: optional
     * @var string
     */
    public $RoomTypeName;
    /**
     * The Composite
     * Meta information extracted from the WSDL
     * - documentation: Indicates that the room type contains multiple rooms sold as a single unit.
     * - use: optional
     * @var bool
     */
    public $Composite;
    /**
     * The Quality
     * Meta information extracted from the WSDL
     * - documentation: Indicates the quality of the room within a hotel such as an "S1K" as a superior room with one king bed.
     * - use: optional
     * @var string
     */
    public $Quality;
    /**
     * The MaxOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of guests allowed in a room type.
     * - use: optional
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The MinOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Minimum number of guests allowed in a room type.
     * - use: optional
     * @var int
     */
    public $MinOccupancy;
    /**
     * The MaxAdultOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of adults allowed in a room type.
     * - use: optional
     * @var int
     */
    public $MaxAdultOccupancy;
    /**
     * The NonsmokingQuantity
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used to designate the number of non-smoking rooms by room type.
     * - use: optional
     * @var int
     */
    public $NonsmokingQuantity;
    /**
     * The MaxChildOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of children allowed in a room type.
     * - use: optional
     * @var int
     */
    public $MaxChildOccupancy;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Used to define the display order.
     * - use: optional
     * @var int
     */
    public $Sort;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Identifies the language in which the guest room information is being sent.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * Constructor method for GuestRoom
     * @uses GuestRoom::setTypeRoom()
     * @uses GuestRoom::setAmenities()
     * @uses GuestRoom::setFeatures()
     * @uses GuestRoom::setMultimediaDescriptions()
     * @uses GuestRoom::setDescriptiveText()
     * @uses GuestRoom::setRoomTypeName()
     * @uses GuestRoom::setComposite()
     * @uses GuestRoom::setQuality()
     * @uses GuestRoom::setMaxOccupancy()
     * @uses GuestRoom::setMinOccupancy()
     * @uses GuestRoom::setMaxAdultOccupancy()
     * @uses GuestRoom::setNonsmokingQuantity()
     * @uses GuestRoom::setMaxChildOccupancy()
     * @uses GuestRoom::setSort()
     * @uses GuestRoom::setLanguage()
     * @param \StructType\TypeRoom[] $typeRoom
     * @param \StructType\Amenities $amenities
     * @param mixed $features
     * @param mixed $multimediaDescriptions
     * @param string $descriptiveText
     * @param string $roomTypeName
     * @param bool $composite
     * @param string $quality
     * @param int $maxOccupancy
     * @param int $minOccupancy
     * @param int $maxAdultOccupancy
     * @param int $nonsmokingQuantity
     * @param int $maxChildOccupancy
     * @param int $sort
     * @param string $language
     */
    public function __construct(array $typeRoom = array(), \StructType\Amenities $amenities = null, $features = null, $multimediaDescriptions = null, $descriptiveText = null, $roomTypeName = null, $composite = null, $quality = null, $maxOccupancy = null, $minOccupancy = null, $maxAdultOccupancy = null, $nonsmokingQuantity = null, $maxChildOccupancy = null, $sort = null, $language = null)
    {
        $this
            ->setTypeRoom($typeRoom)
            ->setAmenities($amenities)
            ->setFeatures($features)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setDescriptiveText($descriptiveText)
            ->setRoomTypeName($roomTypeName)
            ->setComposite($composite)
            ->setQuality($quality)
            ->setMaxOccupancy($maxOccupancy)
            ->setMinOccupancy($minOccupancy)
            ->setMaxAdultOccupancy($maxAdultOccupancy)
            ->setNonsmokingQuantity($nonsmokingQuantity)
            ->setMaxChildOccupancy($maxChildOccupancy)
            ->setSort($sort)
            ->setLanguage($language);
    }
    /**
     * Get TypeRoom value
     * @return \StructType\TypeRoom[]|null
     */
    public function getTypeRoom()
    {
        return $this->TypeRoom;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeRoomForArrayConstraintsFromSetTypeRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRoomTypeRoomItem) {
            // validation for constraint: itemType
            if (!$guestRoomTypeRoomItem instanceof \StructType\TypeRoom) {
                $invalidValues[] = is_object($guestRoomTypeRoomItem) ? get_class($guestRoomTypeRoomItem) : sprintf('%s(%s)', gettype($guestRoomTypeRoomItem), var_export($guestRoomTypeRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TypeRoom property can only contain items of type \StructType\TypeRoom, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\TypeRoom[] $typeRoom
     * @return \StructType\GuestRoom
     */
    public function setTypeRoom(array $typeRoom = array())
    {
        // validation for constraint: array
        if ('' !== ($typeRoomArrayErrorMessage = self::validateTypeRoomForArrayConstraintsFromSetTypeRoom($typeRoom))) {
            throw new \InvalidArgumentException($typeRoomArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($typeRoom) && count($typeRoom) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($typeRoom)), __LINE__);
        }
        $this->TypeRoom = $typeRoom;
        return $this;
    }
    /**
     * Add item to TypeRoom value
     * @throws \InvalidArgumentException
     * @param \StructType\TypeRoom $item
     * @return \StructType\GuestRoom
     */
    public function addToTypeRoom(\StructType\TypeRoom $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TypeRoom) {
            throw new \InvalidArgumentException(sprintf('The TypeRoom property can only contain items of type \StructType\TypeRoom, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TypeRoom) && count($this->TypeRoom) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TypeRoom)), __LINE__);
        }
        $this->TypeRoom[] = $item;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \StructType\Amenities|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \StructType\Amenities $amenities
     * @return \StructType\GuestRoom
     */
    public function setAmenities(\StructType\Amenities $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get Features value
     * @return mixed|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param mixed $features
     * @return \StructType\GuestRoom
     */
    public function setFeatures($features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return mixed|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param mixed $multimediaDescriptions
     * @return \StructType\GuestRoom
     */
    public function setMultimediaDescriptions($multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \StructType\GuestRoom
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get RoomTypeName value
     * @return string|null
     */
    public function getRoomTypeName()
    {
        return $this->RoomTypeName;
    }
    /**
     * Set RoomTypeName value
     * @param string $roomTypeName
     * @return \StructType\GuestRoom
     */
    public function setRoomTypeName($roomTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeName) && !is_string($roomTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeName, true), gettype($roomTypeName)), __LINE__);
        }
        $this->RoomTypeName = $roomTypeName;
        return $this;
    }
    /**
     * Get Composite value
     * @return bool|null
     */
    public function getComposite()
    {
        return $this->Composite;
    }
    /**
     * Set Composite value
     * @param bool $composite
     * @return \StructType\GuestRoom
     */
    public function setComposite($composite = null)
    {
        // validation for constraint: boolean
        if (!is_null($composite) && !is_bool($composite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($composite, true), gettype($composite)), __LINE__);
        }
        $this->Composite = $composite;
        return $this;
    }
    /**
     * Get Quality value
     * @return string|null
     */
    public function getQuality()
    {
        return $this->Quality;
    }
    /**
     * Set Quality value
     * @param string $quality
     * @return \StructType\GuestRoom
     */
    public function setQuality($quality = null)
    {
        // validation for constraint: string
        if (!is_null($quality) && !is_string($quality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quality, true), gettype($quality)), __LINE__);
        }
        $this->Quality = $quality;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\GuestRoom
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get MinOccupancy value
     * @return int|null
     */
    public function getMinOccupancy()
    {
        return $this->MinOccupancy;
    }
    /**
     * Set MinOccupancy value
     * @param int $minOccupancy
     * @return \StructType\GuestRoom
     */
    public function setMinOccupancy($minOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minOccupancy) && !(is_int($minOccupancy) || ctype_digit($minOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minOccupancy, true), gettype($minOccupancy)), __LINE__);
        }
        $this->MinOccupancy = $minOccupancy;
        return $this;
    }
    /**
     * Get MaxAdultOccupancy value
     * @return int|null
     */
    public function getMaxAdultOccupancy()
    {
        return $this->MaxAdultOccupancy;
    }
    /**
     * Set MaxAdultOccupancy value
     * @param int $maxAdultOccupancy
     * @return \StructType\GuestRoom
     */
    public function setMaxAdultOccupancy($maxAdultOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdultOccupancy) && !(is_int($maxAdultOccupancy) || ctype_digit($maxAdultOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdultOccupancy, true), gettype($maxAdultOccupancy)), __LINE__);
        }
        $this->MaxAdultOccupancy = $maxAdultOccupancy;
        return $this;
    }
    /**
     * Get NonsmokingQuantity value
     * @return int|null
     */
    public function getNonsmokingQuantity()
    {
        return $this->NonsmokingQuantity;
    }
    /**
     * Set NonsmokingQuantity value
     * @param int $nonsmokingQuantity
     * @return \StructType\GuestRoom
     */
    public function setNonsmokingQuantity($nonsmokingQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($nonsmokingQuantity) && !(is_int($nonsmokingQuantity) || ctype_digit($nonsmokingQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nonsmokingQuantity, true), gettype($nonsmokingQuantity)), __LINE__);
        }
        $this->NonsmokingQuantity = $nonsmokingQuantity;
        return $this;
    }
    /**
     * Get MaxChildOccupancy value
     * @return int|null
     */
    public function getMaxChildOccupancy()
    {
        return $this->MaxChildOccupancy;
    }
    /**
     * Set MaxChildOccupancy value
     * @param int $maxChildOccupancy
     * @return \StructType\GuestRoom
     */
    public function setMaxChildOccupancy($maxChildOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxChildOccupancy) && !(is_int($maxChildOccupancy) || ctype_digit($maxChildOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxChildOccupancy, true), gettype($maxChildOccupancy)), __LINE__);
        }
        $this->MaxChildOccupancy = $maxChildOccupancy;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\GuestRoom
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\GuestRoom
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestRoom
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
