<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestRPHs StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of Guest RPH items.
 * @subpackage Structs
 */
class GuestRPHs extends AbstractStructBase
{
    /**
     * The GuestRPH
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\GuestRPH[]
     */
    public $GuestRPH;
    /**
     * Constructor method for GuestRPHs
     * @uses GuestRPHs::setGuestRPH()
     * @param \StructType\GuestRPH[] $guestRPH
     */
    public function __construct(array $guestRPH = array())
    {
        $this
            ->setGuestRPH($guestRPH);
    }
    /**
     * Get GuestRPH value
     * @return \StructType\GuestRPH[]|null
     */
    public function getGuestRPH()
    {
        return $this->GuestRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestRPHForArrayConstraintsFromSetGuestRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestRPHsGuestRPHItem) {
            // validation for constraint: itemType
            if (!$guestRPHsGuestRPHItem instanceof \StructType\GuestRPH) {
                $invalidValues[] = is_object($guestRPHsGuestRPHItem) ? get_class($guestRPHsGuestRPHItem) : sprintf('%s(%s)', gettype($guestRPHsGuestRPHItem), var_export($guestRPHsGuestRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestRPH property can only contain items of type \StructType\GuestRPH, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRPH[] $guestRPH
     * @return \StructType\GuestRPHs
     */
    public function setGuestRPH(array $guestRPH = array())
    {
        // validation for constraint: array
        if ('' !== ($guestRPHArrayErrorMessage = self::validateGuestRPHForArrayConstraintsFromSetGuestRPH($guestRPH))) {
            throw new \InvalidArgumentException($guestRPHArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($guestRPH) && count($guestRPH) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($guestRPH)), __LINE__);
        }
        $this->GuestRPH = $guestRPH;
        return $this;
    }
    /**
     * Add item to GuestRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRPH $item
     * @return \StructType\GuestRPHs
     */
    public function addToGuestRPH(\StructType\GuestRPH $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestRPH) {
            throw new \InvalidArgumentException(sprintf('The GuestRPH property can only contain items of type \StructType\GuestRPH, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->GuestRPH) && count($this->GuestRPH) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->GuestRPH)), __LINE__);
        }
        $this->GuestRPH[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestRPHs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
