<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestPrices StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the guest level price information.
 * @subpackage Structs
 */
class GuestPrices extends AbstractStructBase
{
    /**
     * The GuestPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * @var \StructType\GuestPrice[]
     */
    public $GuestPrice;
    /**
     * Constructor method for GuestPrices
     * @uses GuestPrices::setGuestPrice()
     * @param \StructType\GuestPrice[] $guestPrice
     */
    public function __construct(array $guestPrice = array())
    {
        $this
            ->setGuestPrice($guestPrice);
    }
    /**
     * Get GuestPrice value
     * @return \StructType\GuestPrice[]|null
     */
    public function getGuestPrice()
    {
        return $this->GuestPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestPriceForArrayConstraintsFromSetGuestPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestPricesGuestPriceItem) {
            // validation for constraint: itemType
            if (!$guestPricesGuestPriceItem instanceof \StructType\GuestPrice) {
                $invalidValues[] = is_object($guestPricesGuestPriceItem) ? get_class($guestPricesGuestPriceItem) : sprintf('%s(%s)', gettype($guestPricesGuestPriceItem), var_export($guestPricesGuestPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestPrice property can only contain items of type \StructType\GuestPrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestPrice[] $guestPrice
     * @return \StructType\GuestPrices
     */
    public function setGuestPrice(array $guestPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($guestPriceArrayErrorMessage = self::validateGuestPriceForArrayConstraintsFromSetGuestPrice($guestPrice))) {
            throw new \InvalidArgumentException($guestPriceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($guestPrice) && count($guestPrice) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($guestPrice)), __LINE__);
        }
        $this->GuestPrice = $guestPrice;
        return $this;
    }
    /**
     * Add item to GuestPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestPrice $item
     * @return \StructType\GuestPrices
     */
    public function addToGuestPrice(\StructType\GuestPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestPrice) {
            throw new \InvalidArgumentException(sprintf('The GuestPrice property can only contain items of type \StructType\GuestPrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->GuestPrice) && count($this->GuestPrice) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->GuestPrice)), __LINE__);
        }
        $this->GuestPrice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestPrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
