<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestCounts StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Guest Counts associated with the room rate.
 * @subpackage Structs
 */
class GuestCounts extends AbstractStructBase
{
    /**
     * The GuestCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\GuestCount[]
     */
    public $GuestCount;
    /**
     * Constructor method for GuestCounts
     * @uses GuestCounts::setGuestCount()
     * @param \StructType\GuestCount[] $guestCount
     */
    public function __construct(array $guestCount = array())
    {
        $this
            ->setGuestCount($guestCount);
    }
    /**
     * Get GuestCount value
     * @return \StructType\GuestCount[]|null
     */
    public function getGuestCount()
    {
        return $this->GuestCount;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestCount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestCount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestCountForArrayConstraintsFromSetGuestCount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guestCountsGuestCountItem) {
            // validation for constraint: itemType
            if (!$guestCountsGuestCountItem instanceof \StructType\GuestCount) {
                $invalidValues[] = is_object($guestCountsGuestCountItem) ? get_class($guestCountsGuestCountItem) : sprintf('%s(%s)', gettype($guestCountsGuestCountItem), var_export($guestCountsGuestCountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestCount property can only contain items of type \StructType\GuestCount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestCount value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestCount[] $guestCount
     * @return \StructType\GuestCounts
     */
    public function setGuestCount(array $guestCount = array())
    {
        // validation for constraint: array
        if ('' !== ($guestCountArrayErrorMessage = self::validateGuestCountForArrayConstraintsFromSetGuestCount($guestCount))) {
            throw new \InvalidArgumentException($guestCountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($guestCount) && count($guestCount) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($guestCount)), __LINE__);
        }
        $this->GuestCount = $guestCount;
        return $this;
    }
    /**
     * Add item to GuestCount value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestCount $item
     * @return \StructType\GuestCounts
     */
    public function addToGuestCount(\StructType\GuestCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestCount) {
            throw new \InvalidArgumentException(sprintf('The GuestCount property can only contain items of type \StructType\GuestCount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->GuestCount) && count($this->GuestCount) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->GuestCount)), __LINE__);
        }
        $this->GuestCount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GuestCounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
