<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GolfReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The golf facility ID. | To retrieve a golf reservation record when the booking reference is not known.
 * @subpackage Structs
 */
class GolfReadRequest extends AbstractStructBase
{
    /**
     * The Membership
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Membership[]
     */
    public $Membership;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: To request reservation record by the golfer's name.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The PlayDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date for which the tee time round is reserved. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $PlayDateTime;
    /**
     * The PackageID
     * Meta information extracted from the WSDL
     * - documentation: An identification of a package of which this tee time round is a part of. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $PackageID;
    /**
     * The RoundID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier applied to this tee time round.
     * - use: optional
     * @var int
     */
    public $RoundID;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for GolfReadRequest
     * @uses GolfReadRequest::setMembership()
     * @uses GolfReadRequest::setName()
     * @uses GolfReadRequest::setPlayDateTime()
     * @uses GolfReadRequest::setPackageID()
     * @uses GolfReadRequest::setRoundID()
     * @uses GolfReadRequest::setID()
     * @param \StructType\Membership[] $membership
     * @param \StructType\PersonNameType $name
     * @param string $playDateTime
     * @param string $packageID
     * @param int $roundID
     * @param string $iD
     */
    public function __construct(array $membership = array(), \StructType\PersonNameType $name = null, $playDateTime = null, $packageID = null, $roundID = null, $iD = null)
    {
        $this
            ->setMembership($membership)
            ->setName($name)
            ->setPlayDateTime($playDateTime)
            ->setPackageID($packageID)
            ->setRoundID($roundID)
            ->setID($iD);
    }
    /**
     * Get Membership value
     * @return \StructType\Membership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * This method is responsible for validating the values passed to the setMembership method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMembership method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMembershipForArrayConstraintsFromSetMembership(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $golfReadRequestMembershipItem) {
            // validation for constraint: itemType
            if (!$golfReadRequestMembershipItem instanceof \StructType\Membership) {
                $invalidValues[] = is_object($golfReadRequestMembershipItem) ? get_class($golfReadRequestMembershipItem) : sprintf('%s(%s)', gettype($golfReadRequestMembershipItem), var_export($golfReadRequestMembershipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Membership property can only contain items of type \StructType\Membership, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership[] $membership
     * @return \StructType\GolfReadRequest
     */
    public function setMembership(array $membership = array())
    {
        // validation for constraint: array
        if ('' !== ($membershipArrayErrorMessage = self::validateMembershipForArrayConstraintsFromSetMembership($membership))) {
            throw new \InvalidArgumentException($membershipArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($membership) && count($membership) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($membership)), __LINE__);
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \StructType\Membership $item
     * @return \StructType\GolfReadRequest
     */
    public function addToMembership(\StructType\Membership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Membership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of type \StructType\Membership, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Membership) && count($this->Membership) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Membership)), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\GolfReadRequest
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PlayDateTime value
     * @return string|null
     */
    public function getPlayDateTime()
    {
        return $this->PlayDateTime;
    }
    /**
     * This method is responsible for validating the value passed to the setPlayDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlayDateTime method
     * This is a set of validation rules based on the union types associated to the property being set by the setPlayDateTime method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlayDateTimeForUnionConstraintsFromSetPlayDateTime($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set PlayDateTime value
     * @param string $playDateTime
     * @return \StructType\GolfReadRequest
     */
    public function setPlayDateTime($playDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($playDateTime) && !is_string($playDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($playDateTime, true), gettype($playDateTime)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($playDateTimeUnionErrorMessage = self::validatePlayDateTimeForUnionConstraintsFromSetPlayDateTime($playDateTime))) {
            throw new \InvalidArgumentException($playDateTimeUnionErrorMessage, __LINE__);
        }
        $this->PlayDateTime = $playDateTime;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \StructType\GolfReadRequest
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageID, true), gettype($packageID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($packageID) && mb_strlen($packageID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($packageID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($packageID) && mb_strlen($packageID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get RoundID value
     * @return int|null
     */
    public function getRoundID()
    {
        return $this->RoundID;
    }
    /**
     * Set RoundID value
     * @param int $roundID
     * @return \StructType\GolfReadRequest
     */
    public function setRoundID($roundID = null)
    {
        // validation for constraint: int
        if (!is_null($roundID) && !(is_int($roundID) || ctype_digit($roundID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roundID, true), gettype($roundID)), __LINE__);
        }
        $this->RoundID = $roundID;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\GolfReadRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GolfReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
