<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Geocode StructType
 * Meta information extracted from the WSDL
 * - documentation: Geocodes.
 * @subpackage Structs
 */
class Geocode extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - documentation: Latitude. | Example: 28.0847797393799
     * - base: xs:string
     * - choice: Latitude | Longitude | UniversalAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [a-zA-Z0-9]{1,64}
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - documentation: Longitude. | Example: -82.6114349365234
     * - base: xs:string
     * - choice: Latitude | Longitude | UniversalAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [a-zA-Z0-9]{1,64}
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Longitude;
    /**
     * The UniversalAddress
     * Meta information extracted from the WSDL
     * - choice: Latitude | Longitude | UniversalAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\UniversalAddress
     */
    public $UniversalAddress;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for Geocode
     * @uses Geocode::setLatitude()
     * @uses Geocode::setLongitude()
     * @uses Geocode::setUniversalAddress()
     * @uses Geocode::setOntologyExtension()
     * @uses Geocode::setOntologyRefID()
     * @param string $latitude
     * @param string $longitude
     * @param \StructType\UniversalAddress $universalAddress
     * @param mixed $ontologyExtension
     * @param string $ontologyRefID
     */
    public function __construct($latitude = null, $longitude = null, \StructType\UniversalAddress $universalAddress = null, $ontologyExtension = null, $ontologyRefID = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setUniversalAddress($universalAddress)
            ->setOntologyExtension($ontologyExtension)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get Latitude value
     * @return string|null
     */
    public function getLatitude()
    {
        return isset($this->Latitude) ? $this->Latitude : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLatitude method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLatitude method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLatitudeForChoiceConstraintsFromSetLatitude($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Longitude',
            'UniversalAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Latitude can\'t be set as the property %s is already set. Only one property must be set among these properties: Latitude, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Latitude value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $latitude
     * @return \StructType\Geocode
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        // validation for constraint: choice(Latitude, Longitude, UniversalAddress)
        if ('' !== ($latitudeChoiceErrorMessage = self::validateLatitudeForChoiceConstraintsFromSetLatitude($latitude))) {
            throw new \InvalidArgumentException($latitudeChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($latitude) && !preg_match('/[a-zA-Z0-9]{1,64}/', $latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($latitude, true)), __LINE__);
        }
        if (is_null($latitude) || (is_array($latitude) && empty($latitude))) {
            unset($this->Latitude);
        } else {
            $this->Latitude = $latitude;
        }
        return $this;
    }
    /**
     * Get Longitude value
     * @return string|null
     */
    public function getLongitude()
    {
        return isset($this->Longitude) ? $this->Longitude : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLongitude method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLongitude method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLongitudeForChoiceConstraintsFromSetLongitude($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Latitude',
            'UniversalAddress',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Longitude can\'t be set as the property %s is already set. Only one property must be set among these properties: Longitude, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Longitude value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $longitude
     * @return \StructType\Geocode
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        // validation for constraint: choice(Latitude, Longitude, UniversalAddress)
        if ('' !== ($longitudeChoiceErrorMessage = self::validateLongitudeForChoiceConstraintsFromSetLongitude($longitude))) {
            throw new \InvalidArgumentException($longitudeChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($longitude) && !preg_match('/[a-zA-Z0-9]{1,64}/', $longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($longitude, true)), __LINE__);
        }
        if (is_null($longitude) || (is_array($longitude) && empty($longitude))) {
            unset($this->Longitude);
        } else {
            $this->Longitude = $longitude;
        }
        return $this;
    }
    /**
     * Get UniversalAddress value
     * @return \StructType\UniversalAddress|null
     */
    public function getUniversalAddress()
    {
        return isset($this->UniversalAddress) ? $this->UniversalAddress : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUniversalAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniversalAddress method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUniversalAddressForChoiceConstraintsFromSetUniversalAddress($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Latitude',
            'Longitude',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UniversalAddress can\'t be set as the property %s is already set. Only one property must be set among these properties: UniversalAddress, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UniversalAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UniversalAddress $universalAddress
     * @return \StructType\Geocode
     */
    public function setUniversalAddress(\StructType\UniversalAddress $universalAddress = null)
    {
        // validation for constraint: choice(Latitude, Longitude, UniversalAddress)
        if ('' !== ($universalAddressChoiceErrorMessage = self::validateUniversalAddressForChoiceConstraintsFromSetUniversalAddress($universalAddress))) {
            throw new \InvalidArgumentException($universalAddressChoiceErrorMessage, __LINE__);
        }
        if (is_null($universalAddress) || (is_array($universalAddress) && empty($universalAddress))) {
            unset($this->UniversalAddress);
        } else {
            $this->UniversalAddress = $universalAddress;
        }
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\Geocode
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\Geocode
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Geocode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
