<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for General StructType
 * Meta information extracted from the WSDL
 * - documentation: Other environmental program information.
 * @subpackage Structs
 */
class General extends AbstractStructBase
{
    /**
     * The Certification
     * Meta information extracted from the WSDL
     * - documentation: Environmental certification program participation description.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Certification;
    /**
     * The Environmental
     * Meta information extracted from the WSDL
     * - documentation: Active environmental program description.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Environmental;
    /**
     * The CertificationAvailInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property is willing to provide a copy of their certification. | Example: true | Certification credentials available indicator.
     * - use: optional
     * @var bool
     */
    public $CertificationAvailInd;
    /**
     * The ChemicalAllergiesInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property accommodates guests with chemical sensitivities and/or allergies. | Example: true | Guest sensitivity indicator.
     * - use: optional
     * @var bool
     */
    public $ChemicalAllergiesInd;
    /**
     * The EnvironmentalCleanersInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses environmentally responsible cleaning products. | Example: true | Environmentally responsible cleaning products indicator.
     * - use: optional
     * @var bool
     */
    public $EnvironmentalCleanersInd;
    /**
     * The LinenReuseInd
     * @var string
     */
    public $LinenReuseInd;
    /**
     * The ProcurementPolicyInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property has an environmental procurement policy in place for its suppliers. | Example: true | Supplier procurement policy indicator.
     * - use: optional
     * @var bool
     */
    public $ProcurementPolicyInd;
    /**
     * Constructor method for General
     * @uses General::setCertification()
     * @uses General::setEnvironmental()
     * @uses General::setCertificationAvailInd()
     * @uses General::setChemicalAllergiesInd()
     * @uses General::setEnvironmentalCleanersInd()
     * @uses General::setLinenReuseInd()
     * @uses General::setProcurementPolicyInd()
     * @param mixed[] $certification
     * @param mixed[] $environmental
     * @param bool $certificationAvailInd
     * @param bool $chemicalAllergiesInd
     * @param bool $environmentalCleanersInd
     * @param string $linenReuseInd
     * @param bool $procurementPolicyInd
     */
    public function __construct(array $certification = array(), array $environmental = array(), $certificationAvailInd = null, $chemicalAllergiesInd = null, $environmentalCleanersInd = null, $linenReuseInd = null, $procurementPolicyInd = null)
    {
        $this
            ->setCertification($certification)
            ->setEnvironmental($environmental)
            ->setCertificationAvailInd($certificationAvailInd)
            ->setChemicalAllergiesInd($chemicalAllergiesInd)
            ->setEnvironmentalCleanersInd($environmentalCleanersInd)
            ->setLinenReuseInd($linenReuseInd)
            ->setProcurementPolicyInd($procurementPolicyInd);
    }
    /**
     * Get Certification value
     * @return mixed[]|null
     */
    public function getCertification()
    {
        return $this->Certification;
    }
    /**
     * This method is responsible for validating the values passed to the setCertification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertificationForArrayConstraintsFromSetCertification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $generalCertificationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($generalCertificationItem) ? get_class($generalCertificationItem) : sprintf('%s(%s)', gettype($generalCertificationItem), var_export($generalCertificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Certification property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Certification value
     * @throws \InvalidArgumentException
     * @param mixed[] $certification
     * @return \StructType\General
     */
    public function setCertification(array $certification = array())
    {
        // validation for constraint: array
        if ('' !== ($certificationArrayErrorMessage = self::validateCertificationForArrayConstraintsFromSetCertification($certification))) {
            throw new \InvalidArgumentException($certificationArrayErrorMessage, __LINE__);
        }
        $this->Certification = $certification;
        return $this;
    }
    /**
     * Add item to Certification value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\General
     */
    public function addToCertification($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Certification[] = $item;
        return $this;
    }
    /**
     * Get Environmental value
     * @return mixed[]|null
     */
    public function getEnvironmental()
    {
        return $this->Environmental;
    }
    /**
     * This method is responsible for validating the values passed to the setEnvironmental method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnvironmental method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEnvironmentalForArrayConstraintsFromSetEnvironmental(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $generalEnvironmentalItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($generalEnvironmentalItem) ? get_class($generalEnvironmentalItem) : sprintf('%s(%s)', gettype($generalEnvironmentalItem), var_export($generalEnvironmentalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Environmental property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Environmental value
     * @throws \InvalidArgumentException
     * @param mixed[] $environmental
     * @return \StructType\General
     */
    public function setEnvironmental(array $environmental = array())
    {
        // validation for constraint: array
        if ('' !== ($environmentalArrayErrorMessage = self::validateEnvironmentalForArrayConstraintsFromSetEnvironmental($environmental))) {
            throw new \InvalidArgumentException($environmentalArrayErrorMessage, __LINE__);
        }
        $this->Environmental = $environmental;
        return $this;
    }
    /**
     * Add item to Environmental value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\General
     */
    public function addToEnvironmental($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Environmental property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Environmental[] = $item;
        return $this;
    }
    /**
     * Get CertificationAvailInd value
     * @return bool|null
     */
    public function getCertificationAvailInd()
    {
        return $this->CertificationAvailInd;
    }
    /**
     * Set CertificationAvailInd value
     * @param bool $certificationAvailInd
     * @return \StructType\General
     */
    public function setCertificationAvailInd($certificationAvailInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($certificationAvailInd) && !is_bool($certificationAvailInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certificationAvailInd, true), gettype($certificationAvailInd)), __LINE__);
        }
        $this->CertificationAvailInd = $certificationAvailInd;
        return $this;
    }
    /**
     * Get ChemicalAllergiesInd value
     * @return bool|null
     */
    public function getChemicalAllergiesInd()
    {
        return $this->ChemicalAllergiesInd;
    }
    /**
     * Set ChemicalAllergiesInd value
     * @param bool $chemicalAllergiesInd
     * @return \StructType\General
     */
    public function setChemicalAllergiesInd($chemicalAllergiesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($chemicalAllergiesInd) && !is_bool($chemicalAllergiesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chemicalAllergiesInd, true), gettype($chemicalAllergiesInd)), __LINE__);
        }
        $this->ChemicalAllergiesInd = $chemicalAllergiesInd;
        return $this;
    }
    /**
     * Get EnvironmentalCleanersInd value
     * @return bool|null
     */
    public function getEnvironmentalCleanersInd()
    {
        return $this->EnvironmentalCleanersInd;
    }
    /**
     * Set EnvironmentalCleanersInd value
     * @param bool $environmentalCleanersInd
     * @return \StructType\General
     */
    public function setEnvironmentalCleanersInd($environmentalCleanersInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($environmentalCleanersInd) && !is_bool($environmentalCleanersInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($environmentalCleanersInd, true), gettype($environmentalCleanersInd)), __LINE__);
        }
        $this->EnvironmentalCleanersInd = $environmentalCleanersInd;
        return $this;
    }
    /**
     * Get LinenReuseInd value
     * @return string|null
     */
    public function getLinenReuseInd()
    {
        return $this->LinenReuseInd;
    }
    /**
     * Set LinenReuseInd value
     * @param string $linenReuseInd
     * @return \StructType\General
     */
    public function setLinenReuseInd($linenReuseInd = null)
    {
        // validation for constraint: string
        if (!is_null($linenReuseInd) && !is_string($linenReuseInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linenReuseInd, true), gettype($linenReuseInd)), __LINE__);
        }
        $this->LinenReuseInd = $linenReuseInd;
        return $this;
    }
    /**
     * Get ProcurementPolicyInd value
     * @return bool|null
     */
    public function getProcurementPolicyInd()
    {
        return $this->ProcurementPolicyInd;
    }
    /**
     * Set ProcurementPolicyInd value
     * @param bool $procurementPolicyInd
     * @return \StructType\General
     */
    public function setProcurementPolicyInd($procurementPolicyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($procurementPolicyInd) && !is_bool($procurementPolicyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($procurementPolicyInd, true), gettype($procurementPolicyInd)), __LINE__);
        }
        $this->ProcurementPolicyInd = $procurementPolicyInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\General
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
