<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GDS_Status StructType
 * Meta information extracted from the WSDL
 * - documentation: Hotel status per GDS.
 * @subpackage Structs
 */
class GDS_Status extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Example: AA | GDS Code.
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Example: Amadeus | GDS name.
     * @var string
     */
    public $Name;
    /**
     * The HotelStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Example: Open | Property Status. Refer to OpenTravel Code List Hotel Status Code (HST).
     * @var string
     */
    public $HotelStatusCode;
    /**
     * Constructor method for GDS_Status
     * @uses GDS_Status::setCode()
     * @uses GDS_Status::setName()
     * @uses GDS_Status::setHotelStatusCode()
     * @param string $code
     * @param string $name
     * @param string $hotelStatusCode
     */
    public function __construct($code = null, $name = null, $hotelStatusCode = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setHotelStatusCode($hotelStatusCode);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\GDS_Status
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\GDS_Status
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get HotelStatusCode value
     * @return string|null
     */
    public function getHotelStatusCode()
    {
        return $this->HotelStatusCode;
    }
    /**
     * Set HotelStatusCode value
     * @param string $hotelStatusCode
     * @return \StructType\GDS_Status
     */
    public function setHotelStatusCode($hotelStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelStatusCode) && !is_string($hotelStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelStatusCode, true), gettype($hotelStatusCode)), __LINE__);
        }
        $this->HotelStatusCode = $hotelStatusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GDS_Status
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
