<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GDS_InfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: This defines codes used by individual GDS's, which can be used to upload rate information.
 * @subpackage Structs
 */
class GDS_InfoType extends AbstractStructBase
{
    /**
     * The GDS_Codes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GDS_Codes
     */
    public $GDS_Codes;
    /**
     * The GDS_Statuses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GDS_Statuses
     */
    public $GDS_Statuses;
    /**
     * The MasterChainCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 2
     * - use: optional
     * @var string
     */
    public $MasterChainCode;
    /**
     * Constructor method for GDS_InfoType
     * @uses GDS_InfoType::setGDS_Codes()
     * @uses GDS_InfoType::setGDS_Statuses()
     * @uses GDS_InfoType::setMasterChainCode()
     * @param \StructType\GDS_Codes $gDS_Codes
     * @param \StructType\GDS_Statuses $gDS_Statuses
     * @param string $masterChainCode
     */
    public function __construct(\StructType\GDS_Codes $gDS_Codes = null, \StructType\GDS_Statuses $gDS_Statuses = null, $masterChainCode = null)
    {
        $this
            ->setGDS_Codes($gDS_Codes)
            ->setGDS_Statuses($gDS_Statuses)
            ->setMasterChainCode($masterChainCode);
    }
    /**
     * Get GDS_Codes value
     * @return \StructType\GDS_Codes|null
     */
    public function getGDS_Codes()
    {
        return $this->GDS_Codes;
    }
    /**
     * Set GDS_Codes value
     * @param \StructType\GDS_Codes $gDS_Codes
     * @return \StructType\GDS_InfoType
     */
    public function setGDS_Codes(\StructType\GDS_Codes $gDS_Codes = null)
    {
        $this->GDS_Codes = $gDS_Codes;
        return $this;
    }
    /**
     * Get GDS_Statuses value
     * @return \StructType\GDS_Statuses|null
     */
    public function getGDS_Statuses()
    {
        return $this->GDS_Statuses;
    }
    /**
     * Set GDS_Statuses value
     * @param \StructType\GDS_Statuses $gDS_Statuses
     * @return \StructType\GDS_InfoType
     */
    public function setGDS_Statuses(\StructType\GDS_Statuses $gDS_Statuses = null)
    {
        $this->GDS_Statuses = $gDS_Statuses;
        return $this;
    }
    /**
     * Get MasterChainCode value
     * @return string|null
     */
    public function getMasterChainCode()
    {
        return $this->MasterChainCode;
    }
    /**
     * Set MasterChainCode value
     * @param string $masterChainCode
     * @return \StructType\GDS_InfoType
     */
    public function setMasterChainCode($masterChainCode = null)
    {
        // validation for constraint: string
        if (!is_null($masterChainCode) && !is_string($masterChainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterChainCode, true), gettype($masterChainCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($masterChainCode) && mb_strlen($masterChainCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($masterChainCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($masterChainCode) && mb_strlen($masterChainCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($masterChainCode)), __LINE__);
        }
        $this->MasterChainCode = $masterChainCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GDS_InfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
