<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GDS_Code StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides detailed information regarding the specified GDS.
 * @subpackage Structs
 */
class GDS_Code extends AbstractStructBase
{
    /**
     * The GDS_Name
     * Meta information extracted from the WSDL
     * - documentation: Type of GDS for hotel such as Apollo, Amadeus, Sabre, Worldspan etc.
     * - use: required
     * @var string
     */
    public $GDS_Name;
    /**
     * The GDS_CodeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GDS_CodeDetails
     */
    public $GDS_CodeDetails;
    /**
     * The ChainCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 2
     * - use: optional
     * @var string
     */
    public $ChainCode;
    /**
     * The GDS_PropertyCode
     * Meta information extracted from the WSDL
     * - documentation: This is the GDS Property Code used to identify a specific hotel.
     * - use: optional
     * @var string
     */
    public $GDS_PropertyCode;
    /**
     * The LoadGDSIndicator
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used in conjunction with the GDS_Name. When true, this indicates rates will be loaded to the GDS specified by the GDS_Name.
     * - use: optional
     * @var bool
     */
    public $LoadGDSIndicator;
    /**
     * The GDS_PropertyLongName
     * Meta information extracted from the WSDL
     * - documentation: A property long name per channel.
     * - use: optional
     * @var string
     */
    public $GDS_PropertyLongName;
    /**
     * The GDS_PropertyShortName
     * Meta information extracted from the WSDL
     * - documentation: A property short name per channel.
     * - use: optional
     * @var string
     */
    public $GDS_PropertyShortName;
    /**
     * The GDS_RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: A GDS channel room code.
     * - use: optional
     * @var string
     */
    public $GDS_RoomTypeCode;
    /**
     * Constructor method for GDS_Code
     * @uses GDS_Code::setGDS_Name()
     * @uses GDS_Code::setGDS_CodeDetails()
     * @uses GDS_Code::setChainCode()
     * @uses GDS_Code::setGDS_PropertyCode()
     * @uses GDS_Code::setLoadGDSIndicator()
     * @uses GDS_Code::setGDS_PropertyLongName()
     * @uses GDS_Code::setGDS_PropertyShortName()
     * @uses GDS_Code::setGDS_RoomTypeCode()
     * @param string $gDS_Name
     * @param \StructType\GDS_CodeDetails $gDS_CodeDetails
     * @param string $chainCode
     * @param string $gDS_PropertyCode
     * @param bool $loadGDSIndicator
     * @param string $gDS_PropertyLongName
     * @param string $gDS_PropertyShortName
     * @param string $gDS_RoomTypeCode
     */
    public function __construct($gDS_Name = null, \StructType\GDS_CodeDetails $gDS_CodeDetails = null, $chainCode = null, $gDS_PropertyCode = null, $loadGDSIndicator = null, $gDS_PropertyLongName = null, $gDS_PropertyShortName = null, $gDS_RoomTypeCode = null)
    {
        $this
            ->setGDS_Name($gDS_Name)
            ->setGDS_CodeDetails($gDS_CodeDetails)
            ->setChainCode($chainCode)
            ->setGDS_PropertyCode($gDS_PropertyCode)
            ->setLoadGDSIndicator($loadGDSIndicator)
            ->setGDS_PropertyLongName($gDS_PropertyLongName)
            ->setGDS_PropertyShortName($gDS_PropertyShortName)
            ->setGDS_RoomTypeCode($gDS_RoomTypeCode);
    }
    /**
     * Get GDS_Name value
     * @return string
     */
    public function getGDS_Name()
    {
        return $this->GDS_Name;
    }
    /**
     * Set GDS_Name value
     * @param string $gDS_Name
     * @return \StructType\GDS_Code
     */
    public function setGDS_Name($gDS_Name = null)
    {
        // validation for constraint: string
        if (!is_null($gDS_Name) && !is_string($gDS_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDS_Name, true), gettype($gDS_Name)), __LINE__);
        }
        $this->GDS_Name = $gDS_Name;
        return $this;
    }
    /**
     * Get GDS_CodeDetails value
     * @return \StructType\GDS_CodeDetails|null
     */
    public function getGDS_CodeDetails()
    {
        return $this->GDS_CodeDetails;
    }
    /**
     * Set GDS_CodeDetails value
     * @param \StructType\GDS_CodeDetails $gDS_CodeDetails
     * @return \StructType\GDS_Code
     */
    public function setGDS_CodeDetails(\StructType\GDS_CodeDetails $gDS_CodeDetails = null)
    {
        $this->GDS_CodeDetails = $gDS_CodeDetails;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\GDS_Code
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($chainCode) && mb_strlen($chainCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($chainCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($chainCode) && mb_strlen($chainCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get GDS_PropertyCode value
     * @return string|null
     */
    public function getGDS_PropertyCode()
    {
        return $this->GDS_PropertyCode;
    }
    /**
     * Set GDS_PropertyCode value
     * @param string $gDS_PropertyCode
     * @return \StructType\GDS_Code
     */
    public function setGDS_PropertyCode($gDS_PropertyCode = null)
    {
        // validation for constraint: string
        if (!is_null($gDS_PropertyCode) && !is_string($gDS_PropertyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDS_PropertyCode, true), gettype($gDS_PropertyCode)), __LINE__);
        }
        $this->GDS_PropertyCode = $gDS_PropertyCode;
        return $this;
    }
    /**
     * Get LoadGDSIndicator value
     * @return bool|null
     */
    public function getLoadGDSIndicator()
    {
        return $this->LoadGDSIndicator;
    }
    /**
     * Set LoadGDSIndicator value
     * @param bool $loadGDSIndicator
     * @return \StructType\GDS_Code
     */
    public function setLoadGDSIndicator($loadGDSIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($loadGDSIndicator) && !is_bool($loadGDSIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loadGDSIndicator, true), gettype($loadGDSIndicator)), __LINE__);
        }
        $this->LoadGDSIndicator = $loadGDSIndicator;
        return $this;
    }
    /**
     * Get GDS_PropertyLongName value
     * @return string|null
     */
    public function getGDS_PropertyLongName()
    {
        return $this->GDS_PropertyLongName;
    }
    /**
     * Set GDS_PropertyLongName value
     * @param string $gDS_PropertyLongName
     * @return \StructType\GDS_Code
     */
    public function setGDS_PropertyLongName($gDS_PropertyLongName = null)
    {
        // validation for constraint: string
        if (!is_null($gDS_PropertyLongName) && !is_string($gDS_PropertyLongName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDS_PropertyLongName, true), gettype($gDS_PropertyLongName)), __LINE__);
        }
        $this->GDS_PropertyLongName = $gDS_PropertyLongName;
        return $this;
    }
    /**
     * Get GDS_PropertyShortName value
     * @return string|null
     */
    public function getGDS_PropertyShortName()
    {
        return $this->GDS_PropertyShortName;
    }
    /**
     * Set GDS_PropertyShortName value
     * @param string $gDS_PropertyShortName
     * @return \StructType\GDS_Code
     */
    public function setGDS_PropertyShortName($gDS_PropertyShortName = null)
    {
        // validation for constraint: string
        if (!is_null($gDS_PropertyShortName) && !is_string($gDS_PropertyShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDS_PropertyShortName, true), gettype($gDS_PropertyShortName)), __LINE__);
        }
        $this->GDS_PropertyShortName = $gDS_PropertyShortName;
        return $this;
    }
    /**
     * Get GDS_RoomTypeCode value
     * @return string|null
     */
    public function getGDS_RoomTypeCode()
    {
        return $this->GDS_RoomTypeCode;
    }
    /**
     * Set GDS_RoomTypeCode value
     * @param string $gDS_RoomTypeCode
     * @return \StructType\GDS_Code
     */
    public function setGDS_RoomTypeCode($gDS_RoomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($gDS_RoomTypeCode) && !is_string($gDS_RoomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDS_RoomTypeCode, true), gettype($gDS_RoomTypeCode)), __LINE__);
        }
        $this->GDS_RoomTypeCode = $gDS_RoomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GDS_Code
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
