<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: A choice between entering summary origin/ destination or detailed air itinerary information. | Flight information, including flight number, airline, arrival, departure, origin/destination and flight segment(s).
 * @subpackage Structs
 */
class FlightInfo extends AbstractStructBase
{
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the flight for the seat map.
     * - use: required
     * @var string
     */
    public $FlightNumber;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: The airline the seat map is requested for.
     * - minOccurs: 0
     * @var mixed
     */
    public $Airline;
    /**
     * The OriginDestination
     * Meta information extracted from the WSDL
     * - documentation: Origin and destination information.
     * - choice: OriginDestination | AirItineraryDetail
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $OriginDestination;
    /**
     * The AirItineraryDetail
     * Meta information extracted from the WSDL
     * - documentation: Detailed air itinerary information, including origin/destination options by flight segment.
     * - choice: OriginDestination | AirItineraryDetail
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $AirItineraryDetail;
    /**
     * The TravelerRPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for a traveler defined elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $TravelerRPH;
    /**
     * Constructor method for FlightInfo
     * @uses FlightInfo::setFlightNumber()
     * @uses FlightInfo::setAirline()
     * @uses FlightInfo::setOriginDestination()
     * @uses FlightInfo::setAirItineraryDetail()
     * @uses FlightInfo::setTravelerRPH()
     * @param string $flightNumber
     * @param mixed $airline
     * @param mixed $originDestination
     * @param mixed $airItineraryDetail
     * @param string $travelerRPH
     */
    public function __construct($flightNumber = null, $airline = null, $originDestination = null, $airItineraryDetail = null, $travelerRPH = null)
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setAirline($airline)
            ->setOriginDestination($originDestination)
            ->setAirItineraryDetail($airItineraryDetail)
            ->setTravelerRPH($travelerRPH);
    }
    /**
     * Get FlightNumber value
     * @return string
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\FlightInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Airline value
     * @return mixed|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param mixed $airline
     * @return \StructType\FlightInfo
     */
    public function setAirline($airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get OriginDestination value
     * @return mixed|null
     */
    public function getOriginDestination()
    {
        return isset($this->OriginDestination) ? $this->OriginDestination : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOriginDestination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestination method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOriginDestinationForChoiceConstraintsFromSetOriginDestination($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AirItineraryDetail',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OriginDestination can\'t be set as the property %s is already set. Only one property must be set among these properties: OriginDestination, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OriginDestination value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $originDestination
     * @return \StructType\FlightInfo
     */
    public function setOriginDestination($originDestination = null)
    {
        // validation for constraint: choice(OriginDestination, AirItineraryDetail)
        if ('' !== ($originDestinationChoiceErrorMessage = self::validateOriginDestinationForChoiceConstraintsFromSetOriginDestination($originDestination))) {
            throw new \InvalidArgumentException($originDestinationChoiceErrorMessage, __LINE__);
        }
        if (is_null($originDestination) || (is_array($originDestination) && empty($originDestination))) {
            unset($this->OriginDestination);
        } else {
            $this->OriginDestination = $originDestination;
        }
        return $this;
    }
    /**
     * Get AirItineraryDetail value
     * @return mixed|null
     */
    public function getAirItineraryDetail()
    {
        return isset($this->AirItineraryDetail) ? $this->AirItineraryDetail : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAirItineraryDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirItineraryDetail method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAirItineraryDetailForChoiceConstraintsFromSetAirItineraryDetail($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OriginDestination',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AirItineraryDetail can\'t be set as the property %s is already set. Only one property must be set among these properties: AirItineraryDetail, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AirItineraryDetail value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $airItineraryDetail
     * @return \StructType\FlightInfo
     */
    public function setAirItineraryDetail($airItineraryDetail = null)
    {
        // validation for constraint: choice(OriginDestination, AirItineraryDetail)
        if ('' !== ($airItineraryDetailChoiceErrorMessage = self::validateAirItineraryDetailForChoiceConstraintsFromSetAirItineraryDetail($airItineraryDetail))) {
            throw new \InvalidArgumentException($airItineraryDetailChoiceErrorMessage, __LINE__);
        }
        if (is_null($airItineraryDetail) || (is_array($airItineraryDetail) && empty($airItineraryDetail))) {
            unset($this->AirItineraryDetail);
        } else {
            $this->AirItineraryDetail = $airItineraryDetail;
        }
        return $this;
    }
    /**
     * Get TravelerRPH value
     * @return string|null
     */
    public function getTravelerRPH()
    {
        return $this->TravelerRPH;
    }
    /**
     * Set TravelerRPH value
     * @param string $travelerRPH
     * @return \StructType\FlightInfo
     */
    public function setTravelerRPH($travelerRPH = null)
    {
        // validation for constraint: string
        if (!is_null($travelerRPH) && !is_string($travelerRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelerRPH, true), gettype($travelerRPH)), __LINE__);
        }
        $this->TravelerRPH = $travelerRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FlightInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
