<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiledFeeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Filed fee information.
 * @subpackage Structs
 */
class FiledFeeInfo extends AbstractStructBase
{
    /**
     * The BSR_Rate
     * Meta information extracted from the WSDL
     * - documentation: The bankers selling rate used to convert the filed fee into the currency of payment of the EMD.
     * - use: optional
     * @var float
     */
    public $BSR_Rate;
    /**
     * Constructor method for FiledFeeInfo
     * @uses FiledFeeInfo::setBSR_Rate()
     * @param float $bSR_Rate
     */
    public function __construct($bSR_Rate = null)
    {
        $this
            ->setBSR_Rate($bSR_Rate);
    }
    /**
     * Get BSR_Rate value
     * @return float|null
     */
    public function getBSR_Rate()
    {
        return $this->BSR_Rate;
    }
    /**
     * Set BSR_Rate value
     * @param float $bSR_Rate
     * @return \StructType\FiledFeeInfo
     */
    public function setBSR_Rate($bSR_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($bSR_Rate) && !(is_float($bSR_Rate) || is_numeric($bSR_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bSR_Rate, true), gettype($bSR_Rate)), __LINE__);
        }
        $this->BSR_Rate = $bSR_Rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FiledFeeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
