<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies charge information by unit (e.g., room, person, item) and frequency (e.g., daily, weekly, stay). | Provides the effective and expiry dates for the fee. | Provides details of the fee. | Used for non-tax fees and charges
 * (e.g. service charges) .
 * @subpackage Structs
 */
class FeeType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Used for taxes on the associated fee.
     * - minOccurs: 0
     * @var mixed
     */
    public $Taxes;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Text description of the fees in a given language.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The TaxInclusiveInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether taxes are included when figuring the fees.
     * @var bool
     */
    public $TaxInclusiveInd;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the fee is mandatory. When false, the fee is not mandatory.
     * - use: optional
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: An index code to identify an instance in a collection of like items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The TaxableIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the fee is subject to tax.
     * - use: optional
     * @var bool
     */
    public $TaxableIndicator;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: Minimum age of applicability.
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Maximum age of applicability.
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * Constructor method for FeeType
     * @uses FeeType::setTaxes()
     * @uses FeeType::setDescription()
     * @uses FeeType::setTPA_Extensions()
     * @uses FeeType::setTaxInclusiveInd()
     * @uses FeeType::setMandatoryInd()
     * @uses FeeType::setRPH()
     * @uses FeeType::setTaxableIndicator()
     * @uses FeeType::setMinAge()
     * @uses FeeType::setMaxAge()
     * @param mixed $taxes
     * @param mixed[] $description
     * @param mixed $tPA_Extensions
     * @param bool $taxInclusiveInd
     * @param bool $mandatoryInd
     * @param string $rPH
     * @param bool $taxableIndicator
     * @param int $minAge
     * @param int $maxAge
     */
    public function __construct($taxes = null, array $description = array(), $tPA_Extensions = null, $taxInclusiveInd = null, $mandatoryInd = null, $rPH = null, $taxableIndicator = null, $minAge = null, $maxAge = null)
    {
        $this
            ->setTaxes($taxes)
            ->setDescription($description)
            ->setTPA_Extensions($tPA_Extensions)
            ->setTaxInclusiveInd($taxInclusiveInd)
            ->setMandatoryInd($mandatoryInd)
            ->setRPH($rPH)
            ->setTaxableIndicator($taxableIndicator)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge);
    }
    /**
     * Get Taxes value
     * @return mixed|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param mixed $taxes
     * @return \StructType\FeeType
     */
    public function setTaxes($taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $feeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($feeTypeDescriptionItem) ? get_class($feeTypeDescriptionItem) : sprintf('%s(%s)', gettype($feeTypeDescriptionItem), var_export($feeTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\FeeType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FeeType
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\FeeType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get TaxInclusiveInd value
     * @return bool|null
     */
    public function getTaxInclusiveInd()
    {
        return $this->TaxInclusiveInd;
    }
    /**
     * Set TaxInclusiveInd value
     * @param bool $taxInclusiveInd
     * @return \StructType\FeeType
     */
    public function setTaxInclusiveInd($taxInclusiveInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusiveInd) && !is_bool($taxInclusiveInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusiveInd, true), gettype($taxInclusiveInd)), __LINE__);
        }
        $this->TaxInclusiveInd = $taxInclusiveInd;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\FeeType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\FeeType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get TaxableIndicator value
     * @return bool|null
     */
    public function getTaxableIndicator()
    {
        return $this->TaxableIndicator;
    }
    /**
     * Set TaxableIndicator value
     * @param bool $taxableIndicator
     * @return \StructType\FeeType
     */
    public function setTaxableIndicator($taxableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxableIndicator) && !is_bool($taxableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxableIndicator, true), gettype($taxableIndicator)), __LINE__);
        }
        $this->TaxableIndicator = $taxableIndicator;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\FeeType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\FeeType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
