<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeePolicies StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of fees that may apply to a reservation.
 * @subpackage Structs
 */
class FeePolicies extends AbstractStructBase
{
    /**
     * The FeePolicy
     * Meta information extracted from the WSDL
     * - documentation: A fee that may apply to a reservation. Fees are used for non tax amounts like service charges.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $FeePolicy;
    /**
     * Constructor method for FeePolicies
     * @uses FeePolicies::setFeePolicy()
     * @param mixed[] $feePolicy
     */
    public function __construct(array $feePolicy = array())
    {
        $this
            ->setFeePolicy($feePolicy);
    }
    /**
     * Get FeePolicy value
     * @return mixed[]|null
     */
    public function getFeePolicy()
    {
        return $this->FeePolicy;
    }
    /**
     * This method is responsible for validating the values passed to the setFeePolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeePolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeePolicyForArrayConstraintsFromSetFeePolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $feePoliciesFeePolicyItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($feePoliciesFeePolicyItem) ? get_class($feePoliciesFeePolicyItem) : sprintf('%s(%s)', gettype($feePoliciesFeePolicyItem), var_export($feePoliciesFeePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeePolicy property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeePolicy value
     * @throws \InvalidArgumentException
     * @param mixed[] $feePolicy
     * @return \StructType\FeePolicies
     */
    public function setFeePolicy(array $feePolicy = array())
    {
        // validation for constraint: array
        if ('' !== ($feePolicyArrayErrorMessage = self::validateFeePolicyForArrayConstraintsFromSetFeePolicy($feePolicy))) {
            throw new \InvalidArgumentException($feePolicyArrayErrorMessage, __LINE__);
        }
        $this->FeePolicy = $feePolicy;
        return $this;
    }
    /**
     * Add item to FeePolicy value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FeePolicies
     */
    public function addToFeePolicy($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The FeePolicy property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FeePolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeePolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
