<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareSummaryType_DEPRECATE StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines summary information about the rail fare including amount and any discounts applied.
 * @subpackage Structs
 */
class FareSummaryType_DEPRECATE extends AbstractStructBase
{
    /**
     * The TotalFare
     * @var \StructType\TotalFare
     */
    public $TotalFare;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\Discount[]
     */
    public $Discount;
    /**
     * Constructor method for FareSummaryType_DEPRECATE
     * @uses FareSummaryType_DEPRECATE::setTotalFare()
     * @uses FareSummaryType_DEPRECATE::setDiscount()
     * @param \StructType\TotalFare $totalFare
     * @param \StructType\Discount[] $discount
     */
    public function __construct(\StructType\TotalFare $totalFare = null, array $discount = array())
    {
        $this
            ->setTotalFare($totalFare)
            ->setDiscount($discount);
    }
    /**
     * Get TotalFare value
     * @return \StructType\TotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \StructType\TotalFare $totalFare
     * @return \StructType\FareSummaryType_DEPRECATE
     */
    public function setTotalFare(\StructType\TotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\Discount[]|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountForArrayConstraintsFromSetDiscount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareSummaryType_DEPRECATEDiscountItem) {
            // validation for constraint: itemType
            if (!$fareSummaryType_DEPRECATEDiscountItem instanceof \StructType\Discount) {
                $invalidValues[] = is_object($fareSummaryType_DEPRECATEDiscountItem) ? get_class($fareSummaryType_DEPRECATEDiscountItem) : sprintf('%s(%s)', gettype($fareSummaryType_DEPRECATEDiscountItem), var_export($fareSummaryType_DEPRECATEDiscountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Discount property can only contain items of type \StructType\Discount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Discount value
     * @throws \InvalidArgumentException
     * @param \StructType\Discount[] $discount
     * @return \StructType\FareSummaryType_DEPRECATE
     */
    public function setDiscount(array $discount = array())
    {
        // validation for constraint: array
        if ('' !== ($discountArrayErrorMessage = self::validateDiscountForArrayConstraintsFromSetDiscount($discount))) {
            throw new \InvalidArgumentException($discountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($discount) && count($discount) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Add item to Discount value
     * @throws \InvalidArgumentException
     * @param \StructType\Discount $item
     * @return \StructType\FareSummaryType_DEPRECATE
     */
    public function addToDiscount(\StructType\Discount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Discount) {
            throw new \InvalidArgumentException(sprintf('The Discount property can only contain items of type \StructType\Discount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Discount) && count($this->Discount) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Discount)), __LINE__);
        }
        $this->Discount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareSummaryType_DEPRECATE
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
