<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a collection of FareInfo.
 * @subpackage Structs
 */
class FareInfos extends AbstractStructBase
{
    /**
     * The FareInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \StructType\FareInfo[]
     */
    public $FareInfo;
    /**
     * Constructor method for FareInfos
     * @uses FareInfos::setFareInfo()
     * @param \StructType\FareInfo[] $fareInfo
     */
    public function __construct(array $fareInfo = array())
    {
        $this
            ->setFareInfo($fareInfo);
    }
    /**
     * Get FareInfo value
     * @return \StructType\FareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setFareInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareInfoForArrayConstraintsFromSetFareInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfosFareInfoItem) {
            // validation for constraint: itemType
            if (!$fareInfosFareInfoItem instanceof \StructType\FareInfo) {
                $invalidValues[] = is_object($fareInfosFareInfoItem) ? get_class($fareInfosFareInfoItem) : sprintf('%s(%s)', gettype($fareInfosFareInfoItem), var_export($fareInfosFareInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareInfo property can only contain items of type \StructType\FareInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo[] $fareInfo
     * @return \StructType\FareInfos
     */
    public function setFareInfo(array $fareInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($fareInfoArrayErrorMessage = self::validateFareInfoForArrayConstraintsFromSetFareInfo($fareInfo))) {
            throw new \InvalidArgumentException($fareInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($fareInfo) && count($fareInfo) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($fareInfo)), __LINE__);
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\FareInfo $item
     * @return \StructType\FareInfos
     */
    public function addToFareInfo(\StructType\FareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of type \StructType\FareInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->FareInfo) && count($this->FareInfo) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->FareInfo)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
