<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Information used to define a fare and its associated rules information. | Detailed information on individual priced fares. | Fares and related information for this fare rule. | A two/three character, IATA assigned, code identifying
 * the system used to price the itinerary for the ticket being issued. | Nonendorsable and nonrefundable indicators, penalty restriction indicator, pricing system, tour code, ISO country code, around the world fare indicator and
 * non-reissuable/non-exchangeable indicator. | Detailed information on individual priced fares
 * @subpackage Structs
 */
class FareInfo extends FareInfoType
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Provides a reference to a specific FareInfo item between an air modification request and the existing air reservation.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The NonEndorsableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the fare is nonendorsable.
     * - use: optional
     * @var bool
     */
    public $NonEndorsableInd;
    /**
     * The NonRefundableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the fare is non refundable.
     * - use: optional
     * @var bool
     */
    public $NonRefundableInd;
    /**
     * The PenaltyRestrictionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a penalty restriction applies.
     * - use: optional
     * @var bool
     */
    public $PenaltyRestrictionInd;
    /**
     * The AroundTheWorldFareInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this fare is classifed as a published/promotional 'Around the World' fare.
     * - use: optional
     * @var bool
     */
    public $AroundTheWorldFareInd;
    /**
     * The NonInterlineableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the EMD is non-interlineable.
     * - use: optional
     * @var bool
     */
    public $NonInterlineableInd;
    /**
     * The NonCommissionableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the EMD is non-commissionable.
     * - use: optional
     * @var bool
     */
    public $NonCommissionableInd;
    /**
     * The NonReissuableNonExchgInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the EMD is non reissuable and/or non exchangeable.
     * - use: optional
     * @var bool
     */
    public $NonReissuableNonExchgInd;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - documentation: Non-refundable, no value, penalty amounts.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PenaltyAmount;
    /**
     * The PresentCreditCardInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the credit/debit card used for purchase must be presented.
     * - use: optional
     * @var bool
     */
    public $PresentCreditCardInd;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Date[]
     */
    public $Date;
    /**
     * The Fare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Fare
     */
    public $Fare;
    /**
     * The PTC
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PTC[]
     */
    public $PTC;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: The fare basis code for the fare for this rule.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The GlobalIndicatorCode
     * Meta information extracted from the WSDL
     * - documentation: The global direction for this fare rule.
     * - use: optional
     * @var string
     */
    public $GlobalIndicatorCode;
    /**
     * The MaximumPermittedMileage
     * Meta information extracted from the WSDL
     * - documentation: The maximum mileage (in miles) that can be travelled under this fare.
     * - use: optional
     * @var int
     */
    public $MaximumPermittedMileage;
    /**
     * The TripType
     * Meta information extracted from the WSDL
     * - documentation: Tthe type of trip associated with the rule.
     * - use: optional
     * @var string
     */
    public $TripType;
    /**
     * The FareType
     * Meta information extracted from the WSDL
     * - documentation: Specifies the fare type for this fare.
     * - use: optional
     * @var string
     */
    public $FareType;
    /**
     * The FareStatus
     * Meta information extracted from the WSDL
     * - documentation: Identifies whether the fare was constructed, published, created, etc.
     * - use: optional
     * @var string
     */
    public $FareStatus;
    /**
     * The PassengerFare
     * Meta information extracted from the WSDL
     * - documentation: The fare with cost breakdown.
     * @var mixed
     */
    public $PassengerFare;
    /**
     * Constructor method for FareInfo
     * @uses FareInfo::setTPA_Extensions()
     * @uses FareInfo::setOperation()
     * @uses FareInfo::setRPH()
     * @uses FareInfo::setNonEndorsableInd()
     * @uses FareInfo::setNonRefundableInd()
     * @uses FareInfo::setPenaltyRestrictionInd()
     * @uses FareInfo::setAroundTheWorldFareInd()
     * @uses FareInfo::setNonInterlineableInd()
     * @uses FareInfo::setNonCommissionableInd()
     * @uses FareInfo::setNonReissuableNonExchgInd()
     * @uses FareInfo::setPenaltyAmount()
     * @uses FareInfo::setPresentCreditCardInd()
     * @uses FareInfo::setDate()
     * @uses FareInfo::setFare()
     * @uses FareInfo::setPTC()
     * @uses FareInfo::setFareBasisCode()
     * @uses FareInfo::setGlobalIndicatorCode()
     * @uses FareInfo::setMaximumPermittedMileage()
     * @uses FareInfo::setTripType()
     * @uses FareInfo::setFareType()
     * @uses FareInfo::setFareStatus()
     * @uses FareInfo::setPassengerFare()
     * @param mixed $tPA_Extensions
     * @param string $operation
     * @param string $rPH
     * @param bool $nonEndorsableInd
     * @param bool $nonRefundableInd
     * @param bool $penaltyRestrictionInd
     * @param bool $aroundTheWorldFareInd
     * @param bool $nonInterlineableInd
     * @param bool $nonCommissionableInd
     * @param bool $nonReissuableNonExchgInd
     * @param mixed[] $penaltyAmount
     * @param bool $presentCreditCardInd
     * @param \StructType\Date[] $date
     * @param \StructType\Fare $fare
     * @param \StructType\PTC[] $pTC
     * @param string $fareBasisCode
     * @param string $globalIndicatorCode
     * @param int $maximumPermittedMileage
     * @param string $tripType
     * @param string $fareType
     * @param string $fareStatus
     * @param mixed $passengerFare
     */
    public function __construct($tPA_Extensions = null, $operation = null, $rPH = null, $nonEndorsableInd = null, $nonRefundableInd = null, $penaltyRestrictionInd = null, $aroundTheWorldFareInd = null, $nonInterlineableInd = null, $nonCommissionableInd = null, $nonReissuableNonExchgInd = null, array $penaltyAmount = array(), $presentCreditCardInd = null, array $date = array(), \StructType\Fare $fare = null, array $pTC = array(), $fareBasisCode = null, $globalIndicatorCode = null, $maximumPermittedMileage = null, $tripType = null, $fareType = null, $fareStatus = null, $passengerFare = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setOperation($operation)
            ->setRPH($rPH)
            ->setNonEndorsableInd($nonEndorsableInd)
            ->setNonRefundableInd($nonRefundableInd)
            ->setPenaltyRestrictionInd($penaltyRestrictionInd)
            ->setAroundTheWorldFareInd($aroundTheWorldFareInd)
            ->setNonInterlineableInd($nonInterlineableInd)
            ->setNonCommissionableInd($nonCommissionableInd)
            ->setNonReissuableNonExchgInd($nonReissuableNonExchgInd)
            ->setPenaltyAmount($penaltyAmount)
            ->setPresentCreditCardInd($presentCreditCardInd)
            ->setDate($date)
            ->setFare($fare)
            ->setPTC($pTC)
            ->setFareBasisCode($fareBasisCode)
            ->setGlobalIndicatorCode($globalIndicatorCode)
            ->setMaximumPermittedMileage($maximumPermittedMileage)
            ->setTripType($tripType)
            ->setFareType($fareType)
            ->setFareStatus($fareStatus)
            ->setPassengerFare($passengerFare);
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\FareInfo
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\FareInfo
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\FareInfo
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get NonEndorsableInd value
     * @return bool|null
     */
    public function getNonEndorsableInd()
    {
        return $this->NonEndorsableInd;
    }
    /**
     * Set NonEndorsableInd value
     * @param bool $nonEndorsableInd
     * @return \StructType\FareInfo
     */
    public function setNonEndorsableInd($nonEndorsableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonEndorsableInd) && !is_bool($nonEndorsableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonEndorsableInd, true), gettype($nonEndorsableInd)), __LINE__);
        }
        $this->NonEndorsableInd = $nonEndorsableInd;
        return $this;
    }
    /**
     * Get NonRefundableInd value
     * @return bool|null
     */
    public function getNonRefundableInd()
    {
        return $this->NonRefundableInd;
    }
    /**
     * Set NonRefundableInd value
     * @param bool $nonRefundableInd
     * @return \StructType\FareInfo
     */
    public function setNonRefundableInd($nonRefundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundableInd) && !is_bool($nonRefundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonRefundableInd, true), gettype($nonRefundableInd)), __LINE__);
        }
        $this->NonRefundableInd = $nonRefundableInd;
        return $this;
    }
    /**
     * Get PenaltyRestrictionInd value
     * @return bool|null
     */
    public function getPenaltyRestrictionInd()
    {
        return $this->PenaltyRestrictionInd;
    }
    /**
     * Set PenaltyRestrictionInd value
     * @param bool $penaltyRestrictionInd
     * @return \StructType\FareInfo
     */
    public function setPenaltyRestrictionInd($penaltyRestrictionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($penaltyRestrictionInd) && !is_bool($penaltyRestrictionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($penaltyRestrictionInd, true), gettype($penaltyRestrictionInd)), __LINE__);
        }
        $this->PenaltyRestrictionInd = $penaltyRestrictionInd;
        return $this;
    }
    /**
     * Get AroundTheWorldFareInd value
     * @return bool|null
     */
    public function getAroundTheWorldFareInd()
    {
        return $this->AroundTheWorldFareInd;
    }
    /**
     * Set AroundTheWorldFareInd value
     * @param bool $aroundTheWorldFareInd
     * @return \StructType\FareInfo
     */
    public function setAroundTheWorldFareInd($aroundTheWorldFareInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($aroundTheWorldFareInd) && !is_bool($aroundTheWorldFareInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aroundTheWorldFareInd, true), gettype($aroundTheWorldFareInd)), __LINE__);
        }
        $this->AroundTheWorldFareInd = $aroundTheWorldFareInd;
        return $this;
    }
    /**
     * Get NonInterlineableInd value
     * @return bool|null
     */
    public function getNonInterlineableInd()
    {
        return $this->NonInterlineableInd;
    }
    /**
     * Set NonInterlineableInd value
     * @param bool $nonInterlineableInd
     * @return \StructType\FareInfo
     */
    public function setNonInterlineableInd($nonInterlineableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonInterlineableInd) && !is_bool($nonInterlineableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonInterlineableInd, true), gettype($nonInterlineableInd)), __LINE__);
        }
        $this->NonInterlineableInd = $nonInterlineableInd;
        return $this;
    }
    /**
     * Get NonCommissionableInd value
     * @return bool|null
     */
    public function getNonCommissionableInd()
    {
        return $this->NonCommissionableInd;
    }
    /**
     * Set NonCommissionableInd value
     * @param bool $nonCommissionableInd
     * @return \StructType\FareInfo
     */
    public function setNonCommissionableInd($nonCommissionableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonCommissionableInd) && !is_bool($nonCommissionableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonCommissionableInd, true), gettype($nonCommissionableInd)), __LINE__);
        }
        $this->NonCommissionableInd = $nonCommissionableInd;
        return $this;
    }
    /**
     * Get NonReissuableNonExchgInd value
     * @return bool|null
     */
    public function getNonReissuableNonExchgInd()
    {
        return $this->NonReissuableNonExchgInd;
    }
    /**
     * Set NonReissuableNonExchgInd value
     * @param bool $nonReissuableNonExchgInd
     * @return \StructType\FareInfo
     */
    public function setNonReissuableNonExchgInd($nonReissuableNonExchgInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonReissuableNonExchgInd) && !is_bool($nonReissuableNonExchgInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonReissuableNonExchgInd, true), gettype($nonReissuableNonExchgInd)), __LINE__);
        }
        $this->NonReissuableNonExchgInd = $nonReissuableNonExchgInd;
        return $this;
    }
    /**
     * Get PenaltyAmount value
     * @return mixed[]|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyAmountForArrayConstraintsFromSetPenaltyAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoPenaltyAmountItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($fareInfoPenaltyAmountItem) ? get_class($fareInfoPenaltyAmountItem) : sprintf('%s(%s)', gettype($fareInfoPenaltyAmountItem), var_export($fareInfoPenaltyAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyAmount property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyAmount value
     * @throws \InvalidArgumentException
     * @param mixed[] $penaltyAmount
     * @return \StructType\FareInfo
     */
    public function setPenaltyAmount(array $penaltyAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyAmountArrayErrorMessage = self::validatePenaltyAmountForArrayConstraintsFromSetPenaltyAmount($penaltyAmount))) {
            throw new \InvalidArgumentException($penaltyAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($penaltyAmount) && count($penaltyAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($penaltyAmount)), __LINE__);
        }
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }
    /**
     * Add item to PenaltyAmount value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\FareInfo
     */
    public function addToPenaltyAmount($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PenaltyAmount property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->PenaltyAmount) && count($this->PenaltyAmount) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->PenaltyAmount)), __LINE__);
        }
        $this->PenaltyAmount[] = $item;
        return $this;
    }
    /**
     * Get PresentCreditCardInd value
     * @return bool|null
     */
    public function getPresentCreditCardInd()
    {
        return $this->PresentCreditCardInd;
    }
    /**
     * Set PresentCreditCardInd value
     * @param bool $presentCreditCardInd
     * @return \StructType\FareInfo
     */
    public function setPresentCreditCardInd($presentCreditCardInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($presentCreditCardInd) && !is_bool($presentCreditCardInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($presentCreditCardInd, true), gettype($presentCreditCardInd)), __LINE__);
        }
        $this->PresentCreditCardInd = $presentCreditCardInd;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Date[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * This method is responsible for validating the values passed to the setDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateForArrayConstraintsFromSetDate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoDateItem) {
            // validation for constraint: itemType
            if (!$fareInfoDateItem instanceof \StructType\Date) {
                $invalidValues[] = is_object($fareInfoDateItem) ? get_class($fareInfoDateItem) : sprintf('%s(%s)', gettype($fareInfoDateItem), var_export($fareInfoDateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Date property can only contain items of type \StructType\Date, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date[] $date
     * @return \StructType\FareInfo
     */
    public function setDate(array $date = array())
    {
        // validation for constraint: array
        if ('' !== ($dateArrayErrorMessage = self::validateDateForArrayConstraintsFromSetDate($date))) {
            throw new \InvalidArgumentException($dateArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($date) && count($date) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \StructType\Date $item
     * @return \StructType\FareInfo
     */
    public function addToDate(\StructType\Date $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Date) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of type \StructType\Date, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Date) && count($this->Date) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Date)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get Fare value
     * @return \StructType\Fare|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \StructType\Fare $fare
     * @return \StructType\FareInfo
     */
    public function setFare(\StructType\Fare $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get PTC value
     * @return \StructType\PTC[]|null
     */
    public function getPTC()
    {
        return $this->PTC;
    }
    /**
     * This method is responsible for validating the values passed to the setPTC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPTC method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePTCForArrayConstraintsFromSetPTC(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareInfoPTCItem) {
            // validation for constraint: itemType
            if (!$fareInfoPTCItem instanceof \StructType\PTC) {
                $invalidValues[] = is_object($fareInfoPTCItem) ? get_class($fareInfoPTCItem) : sprintf('%s(%s)', gettype($fareInfoPTCItem), var_export($fareInfoPTCItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PTC property can only contain items of type \StructType\PTC, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PTC value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC[] $pTC
     * @return \StructType\FareInfo
     */
    public function setPTC(array $pTC = array())
    {
        // validation for constraint: array
        if ('' !== ($pTCArrayErrorMessage = self::validatePTCForArrayConstraintsFromSetPTC($pTC))) {
            throw new \InvalidArgumentException($pTCArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($pTC) && count($pTC) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($pTC)), __LINE__);
        }
        $this->PTC = $pTC;
        return $this;
    }
    /**
     * Add item to PTC value
     * @throws \InvalidArgumentException
     * @param \StructType\PTC $item
     * @return \StructType\FareInfo
     */
    public function addToPTC(\StructType\PTC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PTC) {
            throw new \InvalidArgumentException(sprintf('The PTC property can only contain items of type \StructType\PTC, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PTC) && count($this->PTC) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PTC)), __LINE__);
        }
        $this->PTC[] = $item;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareInfo
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get GlobalIndicatorCode value
     * @return string|null
     */
    public function getGlobalIndicatorCode()
    {
        return $this->GlobalIndicatorCode;
    }
    /**
     * Set GlobalIndicatorCode value
     * @uses \EnumType\GlobalIndicatorType::valueIsValid()
     * @uses \EnumType\GlobalIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $globalIndicatorCode
     * @return \StructType\FareInfo
     */
    public function setGlobalIndicatorCode($globalIndicatorCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GlobalIndicatorType::valueIsValid($globalIndicatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GlobalIndicatorType', is_array($globalIndicatorCode) ? implode(', ', $globalIndicatorCode) : var_export($globalIndicatorCode, true), implode(', ', \EnumType\GlobalIndicatorType::getValidValues())), __LINE__);
        }
        $this->GlobalIndicatorCode = $globalIndicatorCode;
        return $this;
    }
    /**
     * Get MaximumPermittedMileage value
     * @return int|null
     */
    public function getMaximumPermittedMileage()
    {
        return $this->MaximumPermittedMileage;
    }
    /**
     * Set MaximumPermittedMileage value
     * @param int $maximumPermittedMileage
     * @return \StructType\FareInfo
     */
    public function setMaximumPermittedMileage($maximumPermittedMileage = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPermittedMileage) && !(is_int($maximumPermittedMileage) || ctype_digit($maximumPermittedMileage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumPermittedMileage, true), gettype($maximumPermittedMileage)), __LINE__);
        }
        $this->MaximumPermittedMileage = $maximumPermittedMileage;
        return $this;
    }
    /**
     * Get TripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->TripType;
    }
    /**
     * Set TripType value
     * @uses \EnumType\AirTripType::valueIsValid()
     * @uses \EnumType\AirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tripType
     * @return \StructType\FareInfo
     */
    public function setTripType($tripType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AirTripType::valueIsValid($tripType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AirTripType', is_array($tripType) ? implode(', ', $tripType) : var_export($tripType, true), implode(', ', \EnumType\AirTripType::getValidValues())), __LINE__);
        }
        $this->TripType = $tripType;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \StructType\FareInfo
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareType, true), gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get FareStatus value
     * @return string|null
     */
    public function getFareStatus()
    {
        return $this->FareStatus;
    }
    /**
     * Set FareStatus value
     * @uses \EnumType\FareStatusType::valueIsValid()
     * @uses \EnumType\FareStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareStatus
     * @return \StructType\FareInfo
     */
    public function setFareStatus($fareStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FareStatusType::valueIsValid($fareStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FareStatusType', is_array($fareStatus) ? implode(', ', $fareStatus) : var_export($fareStatus, true), implode(', ', \EnumType\FareStatusType::getValidValues())), __LINE__);
        }
        $this->FareStatus = $fareStatus;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return mixed|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param mixed $passengerFare
     * @return \StructType\FareInfo
     */
    public function setPassengerFare($passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
