<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponentDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: The two/three character designator representing the carrier whose fare within the tariff was used. | Component number, tariff number, rule number, fare owner, waiver code, PTC, rule code, fare basis code, ticket designator. ticket
 * designator qualifier, and agreement code.
 * @subpackage Structs
 */
class FareComponentDetail extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: A sequential number representing the order of the fare comonents within the fare component calculation.
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The CouponSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CouponSequence[]
     */
    public $CouponSequence;
    /**
     * The ConstructionPrinciple
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ConstructionPrinciple[]
     */
    public $ConstructionPrinciple;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * @var \StructType\BaseAmount[]
     */
    public $BaseAmount;
    /**
     * The TicketDesignator
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\TicketDesignator[]
     */
    public $TicketDesignator;
    /**
     * The TariffNumber
     * Meta information extracted from the WSDL
     * - documentation: The tariff number where the fare data is filed.
     * - use: optional
     * @var string
     */
    public $TariffNumber;
    /**
     * The RuleNumber
     * Meta information extracted from the WSDL
     * - documentation: The rule number within the tariff where the fare data is filed.
     * - use: optional
     * @var string
     */
    public $RuleNumber;
    /**
     * The WaiverCode
     * Meta information extracted from the WSDL
     * - documentation: A validating carrier assigned code that allows a fare rule modification or override.
     * - use: optional
     * @var string
     */
    public $WaiverCode;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The passenger type code.
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - documentation: System generated data indicating the ticketed fare is from a specific rule filed fare sent by the issuing system.
     * - use: optional
     * @var string
     */
    public $RuleCode;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable code as provided for in ATA SIPP Reso 110.16 or IATA Reso 728.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The AgreementCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable Tour/Value Coding/Contract/Commercial Agreement Reference Code used to price the fare component.
     * - use: optional
     * @var string
     */
    public $AgreementCode;
    /**
     * Constructor method for FareComponentDetail
     * @uses FareComponentDetail::setNumber()
     * @uses FareComponentDetail::setCouponSequence()
     * @uses FareComponentDetail::setConstructionPrinciple()
     * @uses FareComponentDetail::setBaseAmount()
     * @uses FareComponentDetail::setTicketDesignator()
     * @uses FareComponentDetail::setTariffNumber()
     * @uses FareComponentDetail::setRuleNumber()
     * @uses FareComponentDetail::setWaiverCode()
     * @uses FareComponentDetail::setPassengerTypeCode()
     * @uses FareComponentDetail::setRuleCode()
     * @uses FareComponentDetail::setFareBasisCode()
     * @uses FareComponentDetail::setAgreementCode()
     * @param int $number
     * @param \StructType\CouponSequence[] $couponSequence
     * @param \StructType\ConstructionPrinciple[] $constructionPrinciple
     * @param \StructType\BaseAmount[] $baseAmount
     * @param \StructType\TicketDesignator[] $ticketDesignator
     * @param string $tariffNumber
     * @param string $ruleNumber
     * @param string $waiverCode
     * @param string $passengerTypeCode
     * @param string $ruleCode
     * @param string $fareBasisCode
     * @param string $agreementCode
     */
    public function __construct($number = null, array $couponSequence = array(), array $constructionPrinciple = array(), array $baseAmount = array(), array $ticketDesignator = array(), $tariffNumber = null, $ruleNumber = null, $waiverCode = null, $passengerTypeCode = null, $ruleCode = null, $fareBasisCode = null, $agreementCode = null)
    {
        $this
            ->setNumber($number)
            ->setCouponSequence($couponSequence)
            ->setConstructionPrinciple($constructionPrinciple)
            ->setBaseAmount($baseAmount)
            ->setTicketDesignator($ticketDesignator)
            ->setTariffNumber($tariffNumber)
            ->setRuleNumber($ruleNumber)
            ->setWaiverCode($waiverCode)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setRuleCode($ruleCode)
            ->setFareBasisCode($fareBasisCode)
            ->setAgreementCode($agreementCode);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\FareComponentDetail
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get CouponSequence value
     * @return \StructType\CouponSequence[]|null
     */
    public function getCouponSequence()
    {
        return $this->CouponSequence;
    }
    /**
     * This method is responsible for validating the values passed to the setCouponSequence method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCouponSequence method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponSequenceForArrayConstraintsFromSetCouponSequence(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentDetailCouponSequenceItem) {
            // validation for constraint: itemType
            if (!$fareComponentDetailCouponSequenceItem instanceof \StructType\CouponSequence) {
                $invalidValues[] = is_object($fareComponentDetailCouponSequenceItem) ? get_class($fareComponentDetailCouponSequenceItem) : sprintf('%s(%s)', gettype($fareComponentDetailCouponSequenceItem), var_export($fareComponentDetailCouponSequenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CouponSequence property can only contain items of type \StructType\CouponSequence, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CouponSequence value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponSequence[] $couponSequence
     * @return \StructType\FareComponentDetail
     */
    public function setCouponSequence(array $couponSequence = array())
    {
        // validation for constraint: array
        if ('' !== ($couponSequenceArrayErrorMessage = self::validateCouponSequenceForArrayConstraintsFromSetCouponSequence($couponSequence))) {
            throw new \InvalidArgumentException($couponSequenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($couponSequence) && count($couponSequence) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($couponSequence)), __LINE__);
        }
        $this->CouponSequence = $couponSequence;
        return $this;
    }
    /**
     * Add item to CouponSequence value
     * @throws \InvalidArgumentException
     * @param \StructType\CouponSequence $item
     * @return \StructType\FareComponentDetail
     */
    public function addToCouponSequence(\StructType\CouponSequence $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CouponSequence) {
            throw new \InvalidArgumentException(sprintf('The CouponSequence property can only contain items of type \StructType\CouponSequence, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CouponSequence) && count($this->CouponSequence) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CouponSequence)), __LINE__);
        }
        $this->CouponSequence[] = $item;
        return $this;
    }
    /**
     * Get ConstructionPrinciple value
     * @return \StructType\ConstructionPrinciple[]|null
     */
    public function getConstructionPrinciple()
    {
        return $this->ConstructionPrinciple;
    }
    /**
     * This method is responsible for validating the values passed to the setConstructionPrinciple method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConstructionPrinciple method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConstructionPrincipleForArrayConstraintsFromSetConstructionPrinciple(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentDetailConstructionPrincipleItem) {
            // validation for constraint: itemType
            if (!$fareComponentDetailConstructionPrincipleItem instanceof \StructType\ConstructionPrinciple) {
                $invalidValues[] = is_object($fareComponentDetailConstructionPrincipleItem) ? get_class($fareComponentDetailConstructionPrincipleItem) : sprintf('%s(%s)', gettype($fareComponentDetailConstructionPrincipleItem), var_export($fareComponentDetailConstructionPrincipleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConstructionPrinciple property can only contain items of type \StructType\ConstructionPrinciple, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConstructionPrinciple value
     * @throws \InvalidArgumentException
     * @param \StructType\ConstructionPrinciple[] $constructionPrinciple
     * @return \StructType\FareComponentDetail
     */
    public function setConstructionPrinciple(array $constructionPrinciple = array())
    {
        // validation for constraint: array
        if ('' !== ($constructionPrincipleArrayErrorMessage = self::validateConstructionPrincipleForArrayConstraintsFromSetConstructionPrinciple($constructionPrinciple))) {
            throw new \InvalidArgumentException($constructionPrincipleArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($constructionPrinciple) && count($constructionPrinciple) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($constructionPrinciple)), __LINE__);
        }
        $this->ConstructionPrinciple = $constructionPrinciple;
        return $this;
    }
    /**
     * Add item to ConstructionPrinciple value
     * @throws \InvalidArgumentException
     * @param \StructType\ConstructionPrinciple $item
     * @return \StructType\FareComponentDetail
     */
    public function addToConstructionPrinciple(\StructType\ConstructionPrinciple $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConstructionPrinciple) {
            throw new \InvalidArgumentException(sprintf('The ConstructionPrinciple property can only contain items of type \StructType\ConstructionPrinciple, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ConstructionPrinciple) && count($this->ConstructionPrinciple) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ConstructionPrinciple)), __LINE__);
        }
        $this->ConstructionPrinciple[] = $item;
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return \StructType\BaseAmount[]|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * This method is responsible for validating the values passed to the setBaseAmount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBaseAmount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBaseAmountForArrayConstraintsFromSetBaseAmount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentDetailBaseAmountItem) {
            // validation for constraint: itemType
            if (!$fareComponentDetailBaseAmountItem instanceof \StructType\BaseAmount) {
                $invalidValues[] = is_object($fareComponentDetailBaseAmountItem) ? get_class($fareComponentDetailBaseAmountItem) : sprintf('%s(%s)', gettype($fareComponentDetailBaseAmountItem), var_export($fareComponentDetailBaseAmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BaseAmount property can only contain items of type \StructType\BaseAmount, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BaseAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseAmount[] $baseAmount
     * @return \StructType\FareComponentDetail
     */
    public function setBaseAmount(array $baseAmount = array())
    {
        // validation for constraint: array
        if ('' !== ($baseAmountArrayErrorMessage = self::validateBaseAmountForArrayConstraintsFromSetBaseAmount($baseAmount))) {
            throw new \InvalidArgumentException($baseAmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($baseAmount) && count($baseAmount) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($baseAmount)), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Add item to BaseAmount value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseAmount $item
     * @return \StructType\FareComponentDetail
     */
    public function addToBaseAmount(\StructType\BaseAmount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaseAmount) {
            throw new \InvalidArgumentException(sprintf('The BaseAmount property can only contain items of type \StructType\BaseAmount, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BaseAmount) && count($this->BaseAmount) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BaseAmount)), __LINE__);
        }
        $this->BaseAmount[] = $item;
        return $this;
    }
    /**
     * Get TicketDesignator value
     * @return \StructType\TicketDesignator[]|null
     */
    public function getTicketDesignator()
    {
        return $this->TicketDesignator;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDesignator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDesignator method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDesignatorForArrayConstraintsFromSetTicketDesignator(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentDetailTicketDesignatorItem) {
            // validation for constraint: itemType
            if (!$fareComponentDetailTicketDesignatorItem instanceof \StructType\TicketDesignator) {
                $invalidValues[] = is_object($fareComponentDetailTicketDesignatorItem) ? get_class($fareComponentDetailTicketDesignatorItem) : sprintf('%s(%s)', gettype($fareComponentDetailTicketDesignatorItem), var_export($fareComponentDetailTicketDesignatorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDesignator property can only contain items of type \StructType\TicketDesignator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDesignator value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDesignator[] $ticketDesignator
     * @return \StructType\FareComponentDetail
     */
    public function setTicketDesignator(array $ticketDesignator = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDesignatorArrayErrorMessage = self::validateTicketDesignatorForArrayConstraintsFromSetTicketDesignator($ticketDesignator))) {
            throw new \InvalidArgumentException($ticketDesignatorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($ticketDesignator) && count($ticketDesignator) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($ticketDesignator)), __LINE__);
        }
        $this->TicketDesignator = $ticketDesignator;
        return $this;
    }
    /**
     * Add item to TicketDesignator value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDesignator $item
     * @return \StructType\FareComponentDetail
     */
    public function addToTicketDesignator(\StructType\TicketDesignator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDesignator) {
            throw new \InvalidArgumentException(sprintf('The TicketDesignator property can only contain items of type \StructType\TicketDesignator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->TicketDesignator) && count($this->TicketDesignator) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->TicketDesignator)), __LINE__);
        }
        $this->TicketDesignator[] = $item;
        return $this;
    }
    /**
     * Get TariffNumber value
     * @return string|null
     */
    public function getTariffNumber()
    {
        return $this->TariffNumber;
    }
    /**
     * Set TariffNumber value
     * @param string $tariffNumber
     * @return \StructType\FareComponentDetail
     */
    public function setTariffNumber($tariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tariffNumber) && !is_string($tariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariffNumber, true), gettype($tariffNumber)), __LINE__);
        }
        $this->TariffNumber = $tariffNumber;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \StructType\FareComponentDetail
     */
    public function setRuleNumber($ruleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ruleNumber) && !is_string($ruleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleNumber, true), gettype($ruleNumber)), __LINE__);
        }
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get WaiverCode value
     * @return string|null
     */
    public function getWaiverCode()
    {
        return $this->WaiverCode;
    }
    /**
     * Set WaiverCode value
     * @param string $waiverCode
     * @return \StructType\FareComponentDetail
     */
    public function setWaiverCode($waiverCode = null)
    {
        // validation for constraint: string
        if (!is_null($waiverCode) && !is_string($waiverCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waiverCode, true), gettype($waiverCode)), __LINE__);
        }
        $this->WaiverCode = $waiverCode;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\FareComponentDetail
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get RuleCode value
     * @return string|null
     */
    public function getRuleCode()
    {
        return $this->RuleCode;
    }
    /**
     * Set RuleCode value
     * @param string $ruleCode
     * @return \StructType\FareComponentDetail
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        $this->RuleCode = $ruleCode;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\FareComponentDetail
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get AgreementCode value
     * @return string|null
     */
    public function getAgreementCode()
    {
        return $this->AgreementCode;
    }
    /**
     * Set AgreementCode value
     * @param string $agreementCode
     * @return \StructType\FareComponentDetail
     */
    public function setAgreementCode($agreementCode = null)
    {
        // validation for constraint: string
        if (!is_null($agreementCode) && !is_string($agreementCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementCode, true), gettype($agreementCode)), __LINE__);
        }
        $this->AgreementCode = $agreementCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareComponentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
