<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareComponent StructType
 * Meta information extracted from the WSDL
 * - documentation: The currency code and the amount for the fare component. | Provides the data for a component of the fare.
 * @subpackage Structs
 */
class FareComponent extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: The fare component number.
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The FlightLeg
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\FlightLeg[]
     */
    public $FlightLeg;
    /**
     * Constructor method for FareComponent
     * @uses FareComponent::setNumber()
     * @uses FareComponent::setFlightLeg()
     * @param int $number
     * @param \StructType\FlightLeg[] $flightLeg
     */
    public function __construct($number = null, array $flightLeg = array())
    {
        $this
            ->setNumber($number)
            ->setFlightLeg($flightLeg);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\FareComponent
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get FlightLeg value
     * @return \StructType\FlightLeg[]|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightLeg method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightLegForArrayConstraintsFromSetFlightLeg(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fareComponentFlightLegItem) {
            // validation for constraint: itemType
            if (!$fareComponentFlightLegItem instanceof \StructType\FlightLeg) {
                $invalidValues[] = is_object($fareComponentFlightLegItem) ? get_class($fareComponentFlightLegItem) : sprintf('%s(%s)', gettype($fareComponentFlightLegItem), var_export($fareComponentFlightLegItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightLeg property can only contain items of type \StructType\FlightLeg, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightLeg value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLeg[] $flightLeg
     * @return \StructType\FareComponent
     */
    public function setFlightLeg(array $flightLeg = array())
    {
        // validation for constraint: array
        if ('' !== ($flightLegArrayErrorMessage = self::validateFlightLegForArrayConstraintsFromSetFlightLeg($flightLeg))) {
            throw new \InvalidArgumentException($flightLegArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($flightLeg) && count($flightLeg) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($flightLeg)), __LINE__);
        }
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Add item to FlightLeg value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightLeg $item
     * @return \StructType\FareComponent
     */
    public function addToFlightLeg(\StructType\FlightLeg $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightLeg) {
            throw new \InvalidArgumentException(sprintf('The FlightLeg property can only contain items of type \StructType\FlightLeg, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FlightLeg) && count($this->FlightLeg) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FlightLeg)), __LINE__);
        }
        $this->FlightLeg[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FareComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
