<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The FacilityInfo class that describes the facilities provided at the hotel, including meeting rooms restaurants.
 * @subpackage Structs
 */
class FacilityInfoType extends AbstractStructBase
{
    /**
     * The MeetingRooms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MeetingRooms
     */
    public $MeetingRooms;
    /**
     * The GuestRooms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestRooms
     */
    public $GuestRooms;
    /**
     * The Restaurants
     * Meta information extracted from the WSDL
     * - documentation: Collection of restaurants offered by hotel.
     * - minOccurs: 0
     * @var mixed
     */
    public $Restaurants;
    /**
     * The LastUpdated
     * Meta information extracted from the WSDL
     * - documentation: The date and time when this hotel information was last updated in the system.
     * - use: optional
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for FacilityInfoType
     * @uses FacilityInfoType::setMeetingRooms()
     * @uses FacilityInfoType::setGuestRooms()
     * @uses FacilityInfoType::setRestaurants()
     * @uses FacilityInfoType::setLastUpdated()
     * @param \StructType\MeetingRooms $meetingRooms
     * @param \StructType\GuestRooms $guestRooms
     * @param mixed $restaurants
     * @param string $lastUpdated
     */
    public function __construct(\StructType\MeetingRooms $meetingRooms = null, \StructType\GuestRooms $guestRooms = null, $restaurants = null, $lastUpdated = null)
    {
        $this
            ->setMeetingRooms($meetingRooms)
            ->setGuestRooms($guestRooms)
            ->setRestaurants($restaurants)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get MeetingRooms value
     * @return \StructType\MeetingRooms|null
     */
    public function getMeetingRooms()
    {
        return $this->MeetingRooms;
    }
    /**
     * Set MeetingRooms value
     * @param \StructType\MeetingRooms $meetingRooms
     * @return \StructType\FacilityInfoType
     */
    public function setMeetingRooms(\StructType\MeetingRooms $meetingRooms = null)
    {
        $this->MeetingRooms = $meetingRooms;
        return $this;
    }
    /**
     * Get GuestRooms value
     * @return \StructType\GuestRooms|null
     */
    public function getGuestRooms()
    {
        return $this->GuestRooms;
    }
    /**
     * Set GuestRooms value
     * @param \StructType\GuestRooms $guestRooms
     * @return \StructType\FacilityInfoType
     */
    public function setGuestRooms(\StructType\GuestRooms $guestRooms = null)
    {
        $this->GuestRooms = $guestRooms;
        return $this;
    }
    /**
     * Get Restaurants value
     * @return mixed|null
     */
    public function getRestaurants()
    {
        return $this->Restaurants;
    }
    /**
     * Set Restaurants value
     * @param mixed $restaurants
     * @return \StructType\FacilityInfoType
     */
    public function setRestaurants($restaurants = null)
    {
        $this->Restaurants = $restaurants;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string|null
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\FacilityInfoType
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdated, true), gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
