<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacilityChoicesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the available facilities for the enquiror's chosen property and stay.
 * @subpackage Structs
 */
class FacilityChoicesType extends AbstractStructBase
{
    /**
     * The AvailableRooms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AvailableRooms
     */
    public $AvailableRooms;
    /**
     * The AvailableMealPlans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AvailableMealPlans
     */
    public $AvailableMealPlans;
    /**
     * The RoomPrices
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\RoomPrices[]
     */
    public $RoomPrices;
    /**
     * Constructor method for FacilityChoicesType
     * @uses FacilityChoicesType::setAvailableRooms()
     * @uses FacilityChoicesType::setAvailableMealPlans()
     * @uses FacilityChoicesType::setRoomPrices()
     * @param \StructType\AvailableRooms $availableRooms
     * @param \StructType\AvailableMealPlans $availableMealPlans
     * @param \StructType\RoomPrices[] $roomPrices
     */
    public function __construct(\StructType\AvailableRooms $availableRooms = null, \StructType\AvailableMealPlans $availableMealPlans = null, array $roomPrices = array())
    {
        $this
            ->setAvailableRooms($availableRooms)
            ->setAvailableMealPlans($availableMealPlans)
            ->setRoomPrices($roomPrices);
    }
    /**
     * Get AvailableRooms value
     * @return \StructType\AvailableRooms|null
     */
    public function getAvailableRooms()
    {
        return $this->AvailableRooms;
    }
    /**
     * Set AvailableRooms value
     * @param \StructType\AvailableRooms $availableRooms
     * @return \StructType\FacilityChoicesType
     */
    public function setAvailableRooms(\StructType\AvailableRooms $availableRooms = null)
    {
        $this->AvailableRooms = $availableRooms;
        return $this;
    }
    /**
     * Get AvailableMealPlans value
     * @return \StructType\AvailableMealPlans|null
     */
    public function getAvailableMealPlans()
    {
        return $this->AvailableMealPlans;
    }
    /**
     * Set AvailableMealPlans value
     * @param \StructType\AvailableMealPlans $availableMealPlans
     * @return \StructType\FacilityChoicesType
     */
    public function setAvailableMealPlans(\StructType\AvailableMealPlans $availableMealPlans = null)
    {
        $this->AvailableMealPlans = $availableMealPlans;
        return $this;
    }
    /**
     * Get RoomPrices value
     * @return \StructType\RoomPrices[]|null
     */
    public function getRoomPrices()
    {
        return $this->RoomPrices;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomPrices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomPrices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomPricesForArrayConstraintsFromSetRoomPrices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $facilityChoicesTypeRoomPricesItem) {
            // validation for constraint: itemType
            if (!$facilityChoicesTypeRoomPricesItem instanceof \StructType\RoomPrices) {
                $invalidValues[] = is_object($facilityChoicesTypeRoomPricesItem) ? get_class($facilityChoicesTypeRoomPricesItem) : sprintf('%s(%s)', gettype($facilityChoicesTypeRoomPricesItem), var_export($facilityChoicesTypeRoomPricesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomPrices property can only contain items of type \StructType\RoomPrices, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomPrices[] $roomPrices
     * @return \StructType\FacilityChoicesType
     */
    public function setRoomPrices(array $roomPrices = array())
    {
        // validation for constraint: array
        if ('' !== ($roomPricesArrayErrorMessage = self::validateRoomPricesForArrayConstraintsFromSetRoomPrices($roomPrices))) {
            throw new \InvalidArgumentException($roomPricesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($roomPrices) && count($roomPrices) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($roomPrices)), __LINE__);
        }
        $this->RoomPrices = $roomPrices;
        return $this;
    }
    /**
     * Add item to RoomPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomPrices $item
     * @return \StructType\FacilityChoicesType
     */
    public function addToRoomPrices(\StructType\RoomPrices $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomPrices) {
            throw new \InvalidArgumentException(sprintf('The RoomPrices property can only contain items of type \StructType\RoomPrices, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->RoomPrices) && count($this->RoomPrices) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->RoomPrices)), __LINE__);
        }
        $this->RoomPrices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FacilityChoicesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
