<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtrasInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Selection type and rule code for an extra. | Describes an optional service which is not included in the standard package but may be booked in addition.
 * @subpackage Structs
 */
class ExtrasInfoType extends ExtrasCoreType
{
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Criteria
     */
    public $Criteria;
    /**
     * The Periods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Periods
     */
    public $Periods;
    /**
     * The AdditionalInfoPrompt
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\AdditionalInfoPrompt[]
     */
    public $AdditionalInfoPrompt;
    /**
     * The ParentExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParentExtras
     */
    public $ParentExtras;
    /**
     * The ExtraLocationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\ExtraLocationInfo[]
     */
    public $ExtraLocationInfo;
    /**
     * The ApplyTo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApplyTo;
    /**
     * Constructor method for ExtrasInfoType
     * @uses ExtrasInfoType::setCriteria()
     * @uses ExtrasInfoType::setPeriods()
     * @uses ExtrasInfoType::setAdditionalInfoPrompt()
     * @uses ExtrasInfoType::setParentExtras()
     * @uses ExtrasInfoType::setExtraLocationInfo()
     * @uses ExtrasInfoType::setApplyTo()
     * @param \StructType\Criteria $criteria
     * @param \StructType\Periods $periods
     * @param \StructType\AdditionalInfoPrompt[] $additionalInfoPrompt
     * @param \StructType\ParentExtras $parentExtras
     * @param \StructType\ExtraLocationInfo[] $extraLocationInfo
     * @param string $applyTo
     */
    public function __construct(\StructType\Criteria $criteria = null, \StructType\Periods $periods = null, array $additionalInfoPrompt = array(), \StructType\ParentExtras $parentExtras = null, array $extraLocationInfo = array(), $applyTo = null)
    {
        $this
            ->setCriteria($criteria)
            ->setPeriods($periods)
            ->setAdditionalInfoPrompt($additionalInfoPrompt)
            ->setParentExtras($parentExtras)
            ->setExtraLocationInfo($extraLocationInfo)
            ->setApplyTo($applyTo);
    }
    /**
     * Get Criteria value
     * @return \StructType\Criteria|null
     */
    public function getCriteria()
    {
        return $this->Criteria;
    }
    /**
     * Set Criteria value
     * @param \StructType\Criteria $criteria
     * @return \StructType\ExtrasInfoType
     */
    public function setCriteria(\StructType\Criteria $criteria = null)
    {
        $this->Criteria = $criteria;
        return $this;
    }
    /**
     * Get Periods value
     * @return \StructType\Periods|null
     */
    public function getPeriods()
    {
        return $this->Periods;
    }
    /**
     * Set Periods value
     * @param \StructType\Periods $periods
     * @return \StructType\ExtrasInfoType
     */
    public function setPeriods(\StructType\Periods $periods = null)
    {
        $this->Periods = $periods;
        return $this;
    }
    /**
     * Get AdditionalInfoPrompt value
     * @return \StructType\AdditionalInfoPrompt[]|null
     */
    public function getAdditionalInfoPrompt()
    {
        return $this->AdditionalInfoPrompt;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalInfoPrompt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalInfoPrompt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalInfoPromptForArrayConstraintsFromSetAdditionalInfoPrompt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extrasInfoTypeAdditionalInfoPromptItem) {
            // validation for constraint: itemType
            if (!$extrasInfoTypeAdditionalInfoPromptItem instanceof \StructType\AdditionalInfoPrompt) {
                $invalidValues[] = is_object($extrasInfoTypeAdditionalInfoPromptItem) ? get_class($extrasInfoTypeAdditionalInfoPromptItem) : sprintf('%s(%s)', gettype($extrasInfoTypeAdditionalInfoPromptItem), var_export($extrasInfoTypeAdditionalInfoPromptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalInfoPrompt property can only contain items of type \StructType\AdditionalInfoPrompt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalInfoPrompt value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInfoPrompt[] $additionalInfoPrompt
     * @return \StructType\ExtrasInfoType
     */
    public function setAdditionalInfoPrompt(array $additionalInfoPrompt = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalInfoPromptArrayErrorMessage = self::validateAdditionalInfoPromptForArrayConstraintsFromSetAdditionalInfoPrompt($additionalInfoPrompt))) {
            throw new \InvalidArgumentException($additionalInfoPromptArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($additionalInfoPrompt) && count($additionalInfoPrompt) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($additionalInfoPrompt)), __LINE__);
        }
        $this->AdditionalInfoPrompt = $additionalInfoPrompt;
        return $this;
    }
    /**
     * Add item to AdditionalInfoPrompt value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalInfoPrompt $item
     * @return \StructType\ExtrasInfoType
     */
    public function addToAdditionalInfoPrompt(\StructType\AdditionalInfoPrompt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalInfoPrompt) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInfoPrompt property can only contain items of type \StructType\AdditionalInfoPrompt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->AdditionalInfoPrompt) && count($this->AdditionalInfoPrompt) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->AdditionalInfoPrompt)), __LINE__);
        }
        $this->AdditionalInfoPrompt[] = $item;
        return $this;
    }
    /**
     * Get ParentExtras value
     * @return \StructType\ParentExtras|null
     */
    public function getParentExtras()
    {
        return $this->ParentExtras;
    }
    /**
     * Set ParentExtras value
     * @param \StructType\ParentExtras $parentExtras
     * @return \StructType\ExtrasInfoType
     */
    public function setParentExtras(\StructType\ParentExtras $parentExtras = null)
    {
        $this->ParentExtras = $parentExtras;
        return $this;
    }
    /**
     * Get ExtraLocationInfo value
     * @return \StructType\ExtraLocationInfo[]|null
     */
    public function getExtraLocationInfo()
    {
        return $this->ExtraLocationInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setExtraLocationInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtraLocationInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtraLocationInfoForArrayConstraintsFromSetExtraLocationInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extrasInfoTypeExtraLocationInfoItem) {
            // validation for constraint: itemType
            if (!$extrasInfoTypeExtraLocationInfoItem instanceof \StructType\ExtraLocationInfo) {
                $invalidValues[] = is_object($extrasInfoTypeExtraLocationInfoItem) ? get_class($extrasInfoTypeExtraLocationInfoItem) : sprintf('%s(%s)', gettype($extrasInfoTypeExtraLocationInfoItem), var_export($extrasInfoTypeExtraLocationInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExtraLocationInfo property can only contain items of type \StructType\ExtraLocationInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExtraLocationInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraLocationInfo[] $extraLocationInfo
     * @return \StructType\ExtrasInfoType
     */
    public function setExtraLocationInfo(array $extraLocationInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($extraLocationInfoArrayErrorMessage = self::validateExtraLocationInfoForArrayConstraintsFromSetExtraLocationInfo($extraLocationInfo))) {
            throw new \InvalidArgumentException($extraLocationInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($extraLocationInfo) && count($extraLocationInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($extraLocationInfo)), __LINE__);
        }
        $this->ExtraLocationInfo = $extraLocationInfo;
        return $this;
    }
    /**
     * Add item to ExtraLocationInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ExtraLocationInfo $item
     * @return \StructType\ExtrasInfoType
     */
    public function addToExtraLocationInfo(\StructType\ExtraLocationInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExtraLocationInfo) {
            throw new \InvalidArgumentException(sprintf('The ExtraLocationInfo property can only contain items of type \StructType\ExtraLocationInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ExtraLocationInfo) && count($this->ExtraLocationInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ExtraLocationInfo)), __LINE__);
        }
        $this->ExtraLocationInfo[] = $item;
        return $this;
    }
    /**
     * Get ApplyTo value
     * @return string|null
     */
    public function getApplyTo()
    {
        return $this->ApplyTo;
    }
    /**
     * Set ApplyTo value
     * @param string $applyTo
     * @return \StructType\ExtrasInfoType
     */
    public function setApplyTo($applyTo = null)
    {
        // validation for constraint: string
        if (!is_null($applyTo) && !is_string($applyTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyTo, true), gettype($applyTo)), __LINE__);
        }
        $this->ApplyTo = $applyTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtrasInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
