<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtrasCoreType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes an optional service which is not included in the standard package but may be booked in addition.
 * @subpackage Structs
 */
class ExtrasCoreType extends AbstractStructBase
{
    /**
     * The SubCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\SubCategory[]
     */
    public $SubCategory;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: (Reference Place Holder) - an index code to identify an instance in a collection of like items.. For example, used to assign individual passengers or clients to particular itinerary items.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Code to uniquely identify an extra.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: A one to three character code denoting the type of an Extra, for example 'C' for car hire, 'SKI' for Ski extras. Allocated by the provider.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of an extra being booked. A value of zero may be used to remove an automatic or previously selected extra.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - documentation: A code which links two or more Extras together, enabling a rule to be applied to all group members e.g. only one of the group may be booked, or any combination.
     * - use: optional
     * @var string
     */
    public $GroupCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of an extra.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The ListOfInventoryItemRPH
     * Meta information extracted from the WSDL
     * - documentation: One or more pointers to the Inventory Item(s) with which an extra may be booked.
     * - use: optional
     * @var list
     */
    public $ListOfInventoryItemRPH;
    /**
     * The ListofRoomRPH
     * Meta information extracted from the WSDL
     * - documentation: One or more pointers to the room(s) with which an extra may be booked.
     * - use: optional
     * @var list
     */
    public $ListofRoomRPH;
    /**
     * Constructor method for ExtrasCoreType
     * @uses ExtrasCoreType::setSubCategory()
     * @uses ExtrasCoreType::setRPH()
     * @uses ExtrasCoreType::setCode()
     * @uses ExtrasCoreType::setType()
     * @uses ExtrasCoreType::setQuantity()
     * @uses ExtrasCoreType::setGroupCode()
     * @uses ExtrasCoreType::setName()
     * @uses ExtrasCoreType::setListOfInventoryItemRPH()
     * @uses ExtrasCoreType::setListofRoomRPH()
     * @param \StructType\SubCategory[] $subCategory
     * @param string $rPH
     * @param string $code
     * @param string $type
     * @param int $quantity
     * @param string $groupCode
     * @param string $name
     * @param list $listOfInventoryItemRPH
     * @param list $listofRoomRPH
     */
    public function __construct(array $subCategory = array(), $rPH = null, $code = null, $type = null, $quantity = null, $groupCode = null, $name = null, list $listOfInventoryItemRPH = null, list $listofRoomRPH = null)
    {
        $this
            ->setSubCategory($subCategory)
            ->setRPH($rPH)
            ->setCode($code)
            ->setType($type)
            ->setQuantity($quantity)
            ->setGroupCode($groupCode)
            ->setName($name)
            ->setListOfInventoryItemRPH($listOfInventoryItemRPH)
            ->setListofRoomRPH($listofRoomRPH);
    }
    /**
     * Get SubCategory value
     * @return \StructType\SubCategory[]|null
     */
    public function getSubCategory()
    {
        return $this->SubCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setSubCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubCategoryForArrayConstraintsFromSetSubCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $extrasCoreTypeSubCategoryItem) {
            // validation for constraint: itemType
            if (!$extrasCoreTypeSubCategoryItem instanceof \StructType\SubCategory) {
                $invalidValues[] = is_object($extrasCoreTypeSubCategoryItem) ? get_class($extrasCoreTypeSubCategoryItem) : sprintf('%s(%s)', gettype($extrasCoreTypeSubCategoryItem), var_export($extrasCoreTypeSubCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubCategory property can only contain items of type \StructType\SubCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SubCategory[] $subCategory
     * @return \StructType\ExtrasCoreType
     */
    public function setSubCategory(array $subCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($subCategoryArrayErrorMessage = self::validateSubCategoryForArrayConstraintsFromSetSubCategory($subCategory))) {
            throw new \InvalidArgumentException($subCategoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($subCategory) && count($subCategory) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($subCategory)), __LINE__);
        }
        $this->SubCategory = $subCategory;
        return $this;
    }
    /**
     * Add item to SubCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SubCategory $item
     * @return \StructType\ExtrasCoreType
     */
    public function addToSubCategory(\StructType\SubCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubCategory) {
            throw new \InvalidArgumentException(sprintf('The SubCategory property can only contain items of type \StructType\SubCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SubCategory) && count($this->SubCategory) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SubCategory)), __LINE__);
        }
        $this->SubCategory[] = $item;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\ExtrasCoreType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ExtrasCoreType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ExtrasCoreType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ExtrasCoreType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\ExtrasCoreType
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ExtrasCoreType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ListOfInventoryItemRPH value
     * @return list|null
     */
    public function getListOfInventoryItemRPH()
    {
        return $this->ListOfInventoryItemRPH;
    }
    /**
     * Set ListOfInventoryItemRPH value
     * @param list $listOfInventoryItemRPH
     * @return \StructType\ExtrasCoreType
     */
    public function setListOfInventoryItemRPH(list $listOfInventoryItemRPH = null)
    {
        $this->ListOfInventoryItemRPH = $listOfInventoryItemRPH;
        return $this;
    }
    /**
     * Get ListofRoomRPH value
     * @return list|null
     */
    public function getListofRoomRPH()
    {
        return $this->ListofRoomRPH;
    }
    /**
     * Set ListofRoomRPH value
     * @param list $listofRoomRPH
     * @return \StructType\ExtrasCoreType
     */
    public function setListofRoomRPH(list $listofRoomRPH = null)
    {
        $this->ListofRoomRPH = $listofRoomRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExtrasCoreType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
