<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Energy StructType
 * Meta information extracted from the WSDL
 * - documentation: Property energy and power usage information.
 * @subpackage Structs
 */
class Energy extends AbstractStructBase
{
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Usage[]
     */
    public $Usage;
    /**
     * The ProgramDescription
     * Meta information extracted from the WSDL
     * - documentation: Energy program description.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ProgramDescription;
    /**
     * The EfficientAppliancesInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses energy efficient appliances (e.g. dish washers, washing machines, dryers). | Example: true | Energy efficient appliances indicator.
     * - use: optional
     * @var bool
     */
    public $EfficientAppliancesInd;
    /**
     * The EfficientLightingInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses energy saving lighting facilities, such as energy-efficient LED fixtures. | Example: true | Energy efficient lighting used indicator.
     * - use: optional
     * @var bool
     */
    public $EfficientLightingInd;
    /**
     * The HeatPowerCombInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses combined heat and power units. | Example: true | Combined heat and power units used indicator.
     * - use: optional
     * @var bool
     */
    public $HeatPowerCombInd;
    /**
     * The HeatPumpInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses heat pumps. | Example: true | Heat pumps used indicator.
     * - use: optional
     * @var bool
     */
    public $HeatPumpInd;
    /**
     * The PowerSavingPolicyInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property has a power saving policy. | Example: true | Power saving policy indicator.
     * - use: optional
     * @var bool
     */
    public $PowerSavingPolicyInd;
    /**
     * The SolarInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses solar energy. | Example: true | Solar energy used indicator.
     * - use: optional
     * @var bool
     */
    public $SolarInd;
    /**
     * The TempControlInd
     * @var string
     */
    public $TempControlInd;
    /**
     * The WindTurbineInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses wind turbines. | Example: true | Wind turbines used indicator.
     * - use: optional
     * @var bool
     */
    public $WindTurbineInd;
    /**
     * The EnergyGenerated
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is the amount of power generated by any sources of renewable energy at the hotel in kilowatts. | Example: 677 | Renewable energy kilowatts amount.
     * - use: optional
     * @var int
     */
    public $EnergyGenerated;
    /**
     * The EnergyStarRating
     * Meta information extracted from the WSDL
     * - documentation: Implementer: This is the energy star rating of the property. | Example: 4.2 | Energy star rating.
     * - use: optional
     * @var string
     */
    public $EnergyStarRating;
    /**
     * Constructor method for Energy
     * @uses Energy::setUsage()
     * @uses Energy::setProgramDescription()
     * @uses Energy::setEfficientAppliancesInd()
     * @uses Energy::setEfficientLightingInd()
     * @uses Energy::setHeatPowerCombInd()
     * @uses Energy::setHeatPumpInd()
     * @uses Energy::setPowerSavingPolicyInd()
     * @uses Energy::setSolarInd()
     * @uses Energy::setTempControlInd()
     * @uses Energy::setWindTurbineInd()
     * @uses Energy::setEnergyGenerated()
     * @uses Energy::setEnergyStarRating()
     * @param \StructType\Usage[] $usage
     * @param mixed[] $programDescription
     * @param bool $efficientAppliancesInd
     * @param bool $efficientLightingInd
     * @param bool $heatPowerCombInd
     * @param bool $heatPumpInd
     * @param bool $powerSavingPolicyInd
     * @param bool $solarInd
     * @param string $tempControlInd
     * @param bool $windTurbineInd
     * @param int $energyGenerated
     * @param string $energyStarRating
     */
    public function __construct(array $usage = array(), array $programDescription = array(), $efficientAppliancesInd = null, $efficientLightingInd = null, $heatPowerCombInd = null, $heatPumpInd = null, $powerSavingPolicyInd = null, $solarInd = null, $tempControlInd = null, $windTurbineInd = null, $energyGenerated = null, $energyStarRating = null)
    {
        $this
            ->setUsage($usage)
            ->setProgramDescription($programDescription)
            ->setEfficientAppliancesInd($efficientAppliancesInd)
            ->setEfficientLightingInd($efficientLightingInd)
            ->setHeatPowerCombInd($heatPowerCombInd)
            ->setHeatPumpInd($heatPumpInd)
            ->setPowerSavingPolicyInd($powerSavingPolicyInd)
            ->setSolarInd($solarInd)
            ->setTempControlInd($tempControlInd)
            ->setWindTurbineInd($windTurbineInd)
            ->setEnergyGenerated($energyGenerated)
            ->setEnergyStarRating($energyStarRating);
    }
    /**
     * Get Usage value
     * @return \StructType\Usage[]|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * This method is responsible for validating the values passed to the setUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsageForArrayConstraintsFromSetUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $energyUsageItem) {
            // validation for constraint: itemType
            if (!$energyUsageItem instanceof \StructType\Usage) {
                $invalidValues[] = is_object($energyUsageItem) ? get_class($energyUsageItem) : sprintf('%s(%s)', gettype($energyUsageItem), var_export($energyUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Usage property can only contain items of type \StructType\Usage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Usage value
     * @throws \InvalidArgumentException
     * @param \StructType\Usage[] $usage
     * @return \StructType\Energy
     */
    public function setUsage(array $usage = array())
    {
        // validation for constraint: array
        if ('' !== ($usageArrayErrorMessage = self::validateUsageForArrayConstraintsFromSetUsage($usage))) {
            throw new \InvalidArgumentException($usageArrayErrorMessage, __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Add item to Usage value
     * @throws \InvalidArgumentException
     * @param \StructType\Usage $item
     * @return \StructType\Energy
     */
    public function addToUsage(\StructType\Usage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Usage) {
            throw new \InvalidArgumentException(sprintf('The Usage property can only contain items of type \StructType\Usage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Usage[] = $item;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return mixed[]|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramDescriptionForArrayConstraintsFromSetProgramDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $energyProgramDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($energyProgramDescriptionItem) ? get_class($energyProgramDescriptionItem) : sprintf('%s(%s)', gettype($energyProgramDescriptionItem), var_export($energyProgramDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $programDescription
     * @return \StructType\Energy
     */
    public function setProgramDescription(array $programDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($programDescriptionArrayErrorMessage = self::validateProgramDescriptionForArrayConstraintsFromSetProgramDescription($programDescription))) {
            throw new \InvalidArgumentException($programDescriptionArrayErrorMessage, __LINE__);
        }
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Add item to ProgramDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Energy
     */
    public function addToProgramDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ProgramDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgramDescription[] = $item;
        return $this;
    }
    /**
     * Get EfficientAppliancesInd value
     * @return bool|null
     */
    public function getEfficientAppliancesInd()
    {
        return $this->EfficientAppliancesInd;
    }
    /**
     * Set EfficientAppliancesInd value
     * @param bool $efficientAppliancesInd
     * @return \StructType\Energy
     */
    public function setEfficientAppliancesInd($efficientAppliancesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($efficientAppliancesInd) && !is_bool($efficientAppliancesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($efficientAppliancesInd, true), gettype($efficientAppliancesInd)), __LINE__);
        }
        $this->EfficientAppliancesInd = $efficientAppliancesInd;
        return $this;
    }
    /**
     * Get EfficientLightingInd value
     * @return bool|null
     */
    public function getEfficientLightingInd()
    {
        return $this->EfficientLightingInd;
    }
    /**
     * Set EfficientLightingInd value
     * @param bool $efficientLightingInd
     * @return \StructType\Energy
     */
    public function setEfficientLightingInd($efficientLightingInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($efficientLightingInd) && !is_bool($efficientLightingInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($efficientLightingInd, true), gettype($efficientLightingInd)), __LINE__);
        }
        $this->EfficientLightingInd = $efficientLightingInd;
        return $this;
    }
    /**
     * Get HeatPowerCombInd value
     * @return bool|null
     */
    public function getHeatPowerCombInd()
    {
        return $this->HeatPowerCombInd;
    }
    /**
     * Set HeatPowerCombInd value
     * @param bool $heatPowerCombInd
     * @return \StructType\Energy
     */
    public function setHeatPowerCombInd($heatPowerCombInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($heatPowerCombInd) && !is_bool($heatPowerCombInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($heatPowerCombInd, true), gettype($heatPowerCombInd)), __LINE__);
        }
        $this->HeatPowerCombInd = $heatPowerCombInd;
        return $this;
    }
    /**
     * Get HeatPumpInd value
     * @return bool|null
     */
    public function getHeatPumpInd()
    {
        return $this->HeatPumpInd;
    }
    /**
     * Set HeatPumpInd value
     * @param bool $heatPumpInd
     * @return \StructType\Energy
     */
    public function setHeatPumpInd($heatPumpInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($heatPumpInd) && !is_bool($heatPumpInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($heatPumpInd, true), gettype($heatPumpInd)), __LINE__);
        }
        $this->HeatPumpInd = $heatPumpInd;
        return $this;
    }
    /**
     * Get PowerSavingPolicyInd value
     * @return bool|null
     */
    public function getPowerSavingPolicyInd()
    {
        return $this->PowerSavingPolicyInd;
    }
    /**
     * Set PowerSavingPolicyInd value
     * @param bool $powerSavingPolicyInd
     * @return \StructType\Energy
     */
    public function setPowerSavingPolicyInd($powerSavingPolicyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($powerSavingPolicyInd) && !is_bool($powerSavingPolicyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($powerSavingPolicyInd, true), gettype($powerSavingPolicyInd)), __LINE__);
        }
        $this->PowerSavingPolicyInd = $powerSavingPolicyInd;
        return $this;
    }
    /**
     * Get SolarInd value
     * @return bool|null
     */
    public function getSolarInd()
    {
        return $this->SolarInd;
    }
    /**
     * Set SolarInd value
     * @param bool $solarInd
     * @return \StructType\Energy
     */
    public function setSolarInd($solarInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($solarInd) && !is_bool($solarInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($solarInd, true), gettype($solarInd)), __LINE__);
        }
        $this->SolarInd = $solarInd;
        return $this;
    }
    /**
     * Get TempControlInd value
     * @return string|null
     */
    public function getTempControlInd()
    {
        return $this->TempControlInd;
    }
    /**
     * Set TempControlInd value
     * @param string $tempControlInd
     * @return \StructType\Energy
     */
    public function setTempControlInd($tempControlInd = null)
    {
        // validation for constraint: string
        if (!is_null($tempControlInd) && !is_string($tempControlInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tempControlInd, true), gettype($tempControlInd)), __LINE__);
        }
        $this->TempControlInd = $tempControlInd;
        return $this;
    }
    /**
     * Get WindTurbineInd value
     * @return bool|null
     */
    public function getWindTurbineInd()
    {
        return $this->WindTurbineInd;
    }
    /**
     * Set WindTurbineInd value
     * @param bool $windTurbineInd
     * @return \StructType\Energy
     */
    public function setWindTurbineInd($windTurbineInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($windTurbineInd) && !is_bool($windTurbineInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($windTurbineInd, true), gettype($windTurbineInd)), __LINE__);
        }
        $this->WindTurbineInd = $windTurbineInd;
        return $this;
    }
    /**
     * Get EnergyGenerated value
     * @return int|null
     */
    public function getEnergyGenerated()
    {
        return $this->EnergyGenerated;
    }
    /**
     * Set EnergyGenerated value
     * @param int $energyGenerated
     * @return \StructType\Energy
     */
    public function setEnergyGenerated($energyGenerated = null)
    {
        // validation for constraint: int
        if (!is_null($energyGenerated) && !(is_int($energyGenerated) || ctype_digit($energyGenerated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($energyGenerated, true), gettype($energyGenerated)), __LINE__);
        }
        $this->EnergyGenerated = $energyGenerated;
        return $this;
    }
    /**
     * Get EnergyStarRating value
     * @return string|null
     */
    public function getEnergyStarRating()
    {
        return $this->EnergyStarRating;
    }
    /**
     * Set EnergyStarRating value
     * @param string $energyStarRating
     * @return \StructType\Energy
     */
    public function setEnergyStarRating($energyStarRating = null)
    {
        // validation for constraint: string
        if (!is_null($energyStarRating) && !is_string($energyStarRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($energyStarRating, true), gettype($energyStarRating)), __LINE__);
        }
        $this->EnergyStarRating = $energyStarRating;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Energy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
