<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies whether or not this is the default email address. | Allows for control of the sharing of email information between parties. | Electronic email addresses, in IETF specified format. | Used for Character Strings, length 1 to
 * 128.
 * - base: xs:string
 * - maxLength: 128
 * - minLength: 1
 * @subpackage Structs
 */
class EmailType extends AbstractStructBase
{
    /**
     * The EmailType
     * Meta information extracted from the WSDL
     * - documentation: Defines the purpose of the e-mail address (e.g. personal, business, listserve). Refer to OpenTravel Code List Email Address Type (EAT).
     * - use: optional
     * @var string
     */
    public $EmailType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Used elsewhere in the message to reference this specific email address.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with the e-mail address.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The ValidInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is a valid email address that has been system verified via a successful email transmission. | Example: true | Valid email address indicator.
     * - use: optional
     * @var bool
     */
    public $ValidInd;
    /**
     * The TextFormat
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TextFormat;
    /**
     * Constructor method for EmailType
     * @uses EmailType::setEmailType()
     * @uses EmailType::setRPH()
     * @uses EmailType::setRemark()
     * @uses EmailType::setValidInd()
     * @uses EmailType::setTextFormat()
     * @param string $emailType
     * @param string $rPH
     * @param string $remark
     * @param bool $validInd
     * @param string $textFormat
     */
    public function __construct($emailType = null, $rPH = null, $remark = null, $validInd = null, $textFormat = null)
    {
        $this
            ->setEmailType($emailType)
            ->setRPH($rPH)
            ->setRemark($remark)
            ->setValidInd($validInd)
            ->setTextFormat($textFormat);
    }
    /**
     * Get EmailType value
     * @return string|null
     */
    public function getEmailType()
    {
        return $this->EmailType;
    }
    /**
     * Set EmailType value
     * @param string $emailType
     * @return \StructType\EmailType
     */
    public function setEmailType($emailType = null)
    {
        // validation for constraint: string
        if (!is_null($emailType) && !is_string($emailType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailType, true), gettype($emailType)), __LINE__);
        }
        $this->EmailType = $emailType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\EmailType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\EmailType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get ValidInd value
     * @return bool|null
     */
    public function getValidInd()
    {
        return $this->ValidInd;
    }
    /**
     * Set ValidInd value
     * @param bool $validInd
     * @return \StructType\EmailType
     */
    public function setValidInd($validInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($validInd) && !is_bool($validInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validInd, true), gettype($validInd)), __LINE__);
        }
        $this->ValidInd = $validInd;
        return $this;
    }
    /**
     * Get TextFormat value
     * @return string|null
     */
    public function getTextFormat()
    {
        return $this->TextFormat;
    }
    /**
     * Set TextFormat value
     * @param string $textFormat
     * @return \StructType\EmailType
     */
    public function setTextFormat($textFormat = null)
    {
        // validation for constraint: string
        if (!is_null($textFormat) && !is_string($textFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($textFormat, true), gettype($textFormat)), __LINE__);
        }
        $this->TextFormat = $textFormat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
