<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EffectivePeriods StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of effective periods.
 * @subpackage Structs
 */
class EffectivePeriods extends AbstractStructBase
{
    /**
     * The EffectivePeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\EffectivePeriod[]
     */
    public $EffectivePeriod;
    /**
     * Constructor method for EffectivePeriods
     * @uses EffectivePeriods::setEffectivePeriod()
     * @param \StructType\EffectivePeriod[] $effectivePeriod
     */
    public function __construct(array $effectivePeriod = array())
    {
        $this
            ->setEffectivePeriod($effectivePeriod);
    }
    /**
     * Get EffectivePeriod value
     * @return \StructType\EffectivePeriod[]|null
     */
    public function getEffectivePeriod()
    {
        return $this->EffectivePeriod;
    }
    /**
     * This method is responsible for validating the values passed to the setEffectivePeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEffectivePeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEffectivePeriodForArrayConstraintsFromSetEffectivePeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $effectivePeriodsEffectivePeriodItem) {
            // validation for constraint: itemType
            if (!$effectivePeriodsEffectivePeriodItem instanceof \StructType\EffectivePeriod) {
                $invalidValues[] = is_object($effectivePeriodsEffectivePeriodItem) ? get_class($effectivePeriodsEffectivePeriodItem) : sprintf('%s(%s)', gettype($effectivePeriodsEffectivePeriodItem), var_export($effectivePeriodsEffectivePeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EffectivePeriod property can only contain items of type \StructType\EffectivePeriod, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EffectivePeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\EffectivePeriod[] $effectivePeriod
     * @return \StructType\EffectivePeriods
     */
    public function setEffectivePeriod(array $effectivePeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($effectivePeriodArrayErrorMessage = self::validateEffectivePeriodForArrayConstraintsFromSetEffectivePeriod($effectivePeriod))) {
            throw new \InvalidArgumentException($effectivePeriodArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($effectivePeriod) && count($effectivePeriod) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($effectivePeriod)), __LINE__);
        }
        $this->EffectivePeriod = $effectivePeriod;
        return $this;
    }
    /**
     * Add item to EffectivePeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\EffectivePeriod $item
     * @return \StructType\EffectivePeriods
     */
    public function addToEffectivePeriod(\StructType\EffectivePeriod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EffectivePeriod) {
            throw new \InvalidArgumentException(sprintf('The EffectivePeriod property can only contain items of type \StructType\EffectivePeriod, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->EffectivePeriod) && count($this->EffectivePeriod) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->EffectivePeriod)), __LINE__);
        }
        $this->EffectivePeriod[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EffectivePeriods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
