<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ET_FareInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Account code, net reporting code, nonendorsable and nonrefundable indicators, penalty restriction indicator, pricing system, statistical code and tour code.
 * @subpackage Structs
 */
class ET_FareInfo extends AbstractStructBase
{
    /**
     * The Waiver
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Waiver[]
     */
    public $Waiver;
    /**
     * The RuleIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RuleIndicator[]
     */
    public $RuleIndicator;
    /**
     * The NetReportingCode
     * Meta information extracted from the WSDL
     * - documentation: A code indicating the transaction is subject to a net reporting arrangement.
     * - use: optional
     * @var string
     */
    public $NetReportingCode;
    /**
     * The StatisticalCode
     * Meta information extracted from the WSDL
     * - documentation: Used for domestic or international sales differentiation.
     * - use: optional
     * @var string
     */
    public $StatisticalCode;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable tour code.
     * - use: optional
     * @var string
     */
    public $TourCode;
    /**
     * The CountryCodeOfIssue
     * Meta information extracted from the WSDL
     * - documentation: The country code where the ticket is issued.
     * - use: optional
     * @var string
     */
    public $CountryCodeOfIssue;
    /**
     * Constructor method for ET_FareInfo
     * @uses ET_FareInfo::setWaiver()
     * @uses ET_FareInfo::setRuleIndicator()
     * @uses ET_FareInfo::setNetReportingCode()
     * @uses ET_FareInfo::setStatisticalCode()
     * @uses ET_FareInfo::setTourCode()
     * @uses ET_FareInfo::setCountryCodeOfIssue()
     * @param \StructType\Waiver[] $waiver
     * @param \StructType\RuleIndicator[] $ruleIndicator
     * @param string $netReportingCode
     * @param string $statisticalCode
     * @param string $tourCode
     * @param string $countryCodeOfIssue
     */
    public function __construct(array $waiver = array(), array $ruleIndicator = array(), $netReportingCode = null, $statisticalCode = null, $tourCode = null, $countryCodeOfIssue = null)
    {
        $this
            ->setWaiver($waiver)
            ->setRuleIndicator($ruleIndicator)
            ->setNetReportingCode($netReportingCode)
            ->setStatisticalCode($statisticalCode)
            ->setTourCode($tourCode)
            ->setCountryCodeOfIssue($countryCodeOfIssue);
    }
    /**
     * Get Waiver value
     * @return \StructType\Waiver[]|null
     */
    public function getWaiver()
    {
        return $this->Waiver;
    }
    /**
     * This method is responsible for validating the values passed to the setWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWaiverForArrayConstraintsFromSetWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eT_FareInfoWaiverItem) {
            // validation for constraint: itemType
            if (!$eT_FareInfoWaiverItem instanceof \StructType\Waiver) {
                $invalidValues[] = is_object($eT_FareInfoWaiverItem) ? get_class($eT_FareInfoWaiverItem) : sprintf('%s(%s)', gettype($eT_FareInfoWaiverItem), var_export($eT_FareInfoWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Waiver property can only contain items of type \StructType\Waiver, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Waiver value
     * @throws \InvalidArgumentException
     * @param \StructType\Waiver[] $waiver
     * @return \StructType\ET_FareInfo
     */
    public function setWaiver(array $waiver = array())
    {
        // validation for constraint: array
        if ('' !== ($waiverArrayErrorMessage = self::validateWaiverForArrayConstraintsFromSetWaiver($waiver))) {
            throw new \InvalidArgumentException($waiverArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($waiver) && count($waiver) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($waiver)), __LINE__);
        }
        $this->Waiver = $waiver;
        return $this;
    }
    /**
     * Add item to Waiver value
     * @throws \InvalidArgumentException
     * @param \StructType\Waiver $item
     * @return \StructType\ET_FareInfo
     */
    public function addToWaiver(\StructType\Waiver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Waiver) {
            throw new \InvalidArgumentException(sprintf('The Waiver property can only contain items of type \StructType\Waiver, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Waiver) && count($this->Waiver) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Waiver)), __LINE__);
        }
        $this->Waiver[] = $item;
        return $this;
    }
    /**
     * Get RuleIndicator value
     * @return \StructType\RuleIndicator[]|null
     */
    public function getRuleIndicator()
    {
        return $this->RuleIndicator;
    }
    /**
     * This method is responsible for validating the values passed to the setRuleIndicator method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRuleIndicator method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRuleIndicatorForArrayConstraintsFromSetRuleIndicator(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eT_FareInfoRuleIndicatorItem) {
            // validation for constraint: itemType
            if (!$eT_FareInfoRuleIndicatorItem instanceof \StructType\RuleIndicator) {
                $invalidValues[] = is_object($eT_FareInfoRuleIndicatorItem) ? get_class($eT_FareInfoRuleIndicatorItem) : sprintf('%s(%s)', gettype($eT_FareInfoRuleIndicatorItem), var_export($eT_FareInfoRuleIndicatorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RuleIndicator property can only contain items of type \StructType\RuleIndicator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RuleIndicator value
     * @throws \InvalidArgumentException
     * @param \StructType\RuleIndicator[] $ruleIndicator
     * @return \StructType\ET_FareInfo
     */
    public function setRuleIndicator(array $ruleIndicator = array())
    {
        // validation for constraint: array
        if ('' !== ($ruleIndicatorArrayErrorMessage = self::validateRuleIndicatorForArrayConstraintsFromSetRuleIndicator($ruleIndicator))) {
            throw new \InvalidArgumentException($ruleIndicatorArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($ruleIndicator) && count($ruleIndicator) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($ruleIndicator)), __LINE__);
        }
        $this->RuleIndicator = $ruleIndicator;
        return $this;
    }
    /**
     * Add item to RuleIndicator value
     * @throws \InvalidArgumentException
     * @param \StructType\RuleIndicator $item
     * @return \StructType\ET_FareInfo
     */
    public function addToRuleIndicator(\StructType\RuleIndicator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RuleIndicator) {
            throw new \InvalidArgumentException(sprintf('The RuleIndicator property can only contain items of type \StructType\RuleIndicator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RuleIndicator) && count($this->RuleIndicator) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RuleIndicator)), __LINE__);
        }
        $this->RuleIndicator[] = $item;
        return $this;
    }
    /**
     * Get NetReportingCode value
     * @return string|null
     */
    public function getNetReportingCode()
    {
        return $this->NetReportingCode;
    }
    /**
     * Set NetReportingCode value
     * @param string $netReportingCode
     * @return \StructType\ET_FareInfo
     */
    public function setNetReportingCode($netReportingCode = null)
    {
        // validation for constraint: string
        if (!is_null($netReportingCode) && !is_string($netReportingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netReportingCode, true), gettype($netReportingCode)), __LINE__);
        }
        $this->NetReportingCode = $netReportingCode;
        return $this;
    }
    /**
     * Get StatisticalCode value
     * @return string|null
     */
    public function getStatisticalCode()
    {
        return $this->StatisticalCode;
    }
    /**
     * Set StatisticalCode value
     * @param string $statisticalCode
     * @return \StructType\ET_FareInfo
     */
    public function setStatisticalCode($statisticalCode = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalCode) && !is_string($statisticalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticalCode, true), gettype($statisticalCode)), __LINE__);
        }
        $this->StatisticalCode = $statisticalCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \StructType\ET_FareInfo
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get CountryCodeOfIssue value
     * @return string|null
     */
    public function getCountryCodeOfIssue()
    {
        return $this->CountryCodeOfIssue;
    }
    /**
     * Set CountryCodeOfIssue value
     * @param string $countryCodeOfIssue
     * @return \StructType\ET_FareInfo
     */
    public function setCountryCodeOfIssue($countryCodeOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($countryCodeOfIssue) && !is_string($countryCodeOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCodeOfIssue, true), gettype($countryCodeOfIssue)), __LINE__);
        }
        $this->CountryCodeOfIssue = $countryCodeOfIssue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ET_FareInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
