<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective and expiry date of the document. | The birth date of the document holder. | The gender of the document holder. | Allows for control of the sharing of document data between parties. | Provides information on a specific
 * document.
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocHolderName
     * Meta information extracted from the WSDL
     * - documentation: The name of the document holder in unformatted text (Mr. Sam Jones).
     * - choice: DocHolderName | DocHolderFormattedName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var mixed
     */
    public $DocHolderName;
    /**
     * The DocHolderFormattedName
     * Meta information extracted from the WSDL
     * - documentation: The name of document holder in formatted text.
     * - choice: DocHolderName | DocHolderFormattedName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - minOccurs: 0
     * @var mixed
     */
    public $DocHolderFormattedName;
    /**
     * The DocLimitations
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate any limitations on the document (e.g. as a person may only be allowed to spend a max of 30 days in country on a visitor's visa).
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $DocLimitations;
    /**
     * The AdditionalPersonNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionalPersonNames
     */
    public $AdditionalPersonNames;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The DocIssueAuthority
     * Meta information extracted from the WSDL
     * - documentation: Indicates the group or association that granted the document.
     * - use: optional
     * @var string
     */
    public $DocIssueAuthority;
    /**
     * The DocIssueLocation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the location where the document was issued.
     * - use: optional
     * @var string
     */
    public $DocIssueLocation;
    /**
     * The DocID
     * Meta information extracted from the WSDL
     * - documentation: Unique number assigned by authorities to document.
     * - use: optional
     * @var string
     */
    public $DocID;
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - documentation: Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OpenTravel Code List Document Type (DOC).
     * - use: optional
     * @var string
     */
    public $DocType;
    /**
     * The DocIssueStateProv
     * Meta information extracted from the WSDL
     * - documentation: State or Province where the document was issued.
     * - use: optional
     * @var mixed
     */
    public $DocIssueStateProv;
    /**
     * The DocIssueCountry
     * Meta information extracted from the WSDL
     * - documentation: Country where the document was issued.
     * - use: optional
     * @var string
     */
    public $DocIssueCountry;
    /**
     * The BirthCountry
     * Meta information extracted from the WSDL
     * - documentation: Specifies the birth country of the document holder.
     * - use: optional
     * @var string
     */
    public $BirthCountry;
    /**
     * The BirthPlace
     * Meta information extracted from the WSDL
     * - documentation: Specifies the birth place of the document holder (e.g., city, state, county, province), when designating a country of birth, use BirthCountry.
     * - use: optional
     * @var string
     */
    public $BirthPlace;
    /**
     * The DocHolderNationality
     * Meta information extracted from the WSDL
     * - documentation: The country code of the nationality of the document holder.
     * - use: optional
     * @var string
     */
    public $DocHolderNationality;
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - documentation: Provides contact name associated with the document.
     * - use: optional
     * @var string
     */
    public $ContactName;
    /**
     * The HolderType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $HolderType;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: A remark associated with the document.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the postal code (e.g., ZIP code) on the document.
     * - use: optional
     * @var string
     */
    public $PostalCode;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocHolderName()
     * @uses DocumentType::setDocHolderFormattedName()
     * @uses DocumentType::setDocLimitations()
     * @uses DocumentType::setAdditionalPersonNames()
     * @uses DocumentType::setTPA_Extensions()
     * @uses DocumentType::setDocIssueAuthority()
     * @uses DocumentType::setDocIssueLocation()
     * @uses DocumentType::setDocID()
     * @uses DocumentType::setDocType()
     * @uses DocumentType::setDocIssueStateProv()
     * @uses DocumentType::setDocIssueCountry()
     * @uses DocumentType::setBirthCountry()
     * @uses DocumentType::setBirthPlace()
     * @uses DocumentType::setDocHolderNationality()
     * @uses DocumentType::setContactName()
     * @uses DocumentType::setHolderType()
     * @uses DocumentType::setRemark()
     * @uses DocumentType::setPostalCode()
     * @param mixed $docHolderName
     * @param mixed $docHolderFormattedName
     * @param mixed[] $docLimitations
     * @param \StructType\AdditionalPersonNames $additionalPersonNames
     * @param mixed $tPA_Extensions
     * @param string $docIssueAuthority
     * @param string $docIssueLocation
     * @param string $docID
     * @param string $docType
     * @param mixed $docIssueStateProv
     * @param string $docIssueCountry
     * @param string $birthCountry
     * @param string $birthPlace
     * @param string $docHolderNationality
     * @param string $contactName
     * @param string $holderType
     * @param string $remark
     * @param string $postalCode
     */
    public function __construct($docHolderName = null, $docHolderFormattedName = null, array $docLimitations = array(), \StructType\AdditionalPersonNames $additionalPersonNames = null, $tPA_Extensions = null, $docIssueAuthority = null, $docIssueLocation = null, $docID = null, $docType = null, $docIssueStateProv = null, $docIssueCountry = null, $birthCountry = null, $birthPlace = null, $docHolderNationality = null, $contactName = null, $holderType = null, $remark = null, $postalCode = null)
    {
        $this
            ->setDocHolderName($docHolderName)
            ->setDocHolderFormattedName($docHolderFormattedName)
            ->setDocLimitations($docLimitations)
            ->setAdditionalPersonNames($additionalPersonNames)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDocIssueAuthority($docIssueAuthority)
            ->setDocIssueLocation($docIssueLocation)
            ->setDocID($docID)
            ->setDocType($docType)
            ->setDocIssueStateProv($docIssueStateProv)
            ->setDocIssueCountry($docIssueCountry)
            ->setBirthCountry($birthCountry)
            ->setBirthPlace($birthPlace)
            ->setDocHolderNationality($docHolderNationality)
            ->setContactName($contactName)
            ->setHolderType($holderType)
            ->setRemark($remark)
            ->setPostalCode($postalCode);
    }
    /**
     * Get DocHolderName value
     * @return mixed|null
     */
    public function getDocHolderName()
    {
        return isset($this->DocHolderName) ? $this->DocHolderName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDocHolderName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocHolderName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDocHolderNameForChoiceConstraintsFromSetDocHolderName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DocHolderFormattedName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DocHolderName can\'t be set as the property %s is already set. Only one property must be set among these properties: DocHolderName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DocHolderName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $docHolderName
     * @return \StructType\DocumentType
     */
    public function setDocHolderName($docHolderName = null)
    {
        // validation for constraint: choice(DocHolderName, DocHolderFormattedName)
        if ('' !== ($docHolderNameChoiceErrorMessage = self::validateDocHolderNameForChoiceConstraintsFromSetDocHolderName($docHolderName))) {
            throw new \InvalidArgumentException($docHolderNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($docHolderName) || (is_array($docHolderName) && empty($docHolderName))) {
            unset($this->DocHolderName);
        } else {
            $this->DocHolderName = $docHolderName;
        }
        return $this;
    }
    /**
     * Get DocHolderFormattedName value
     * @return mixed|null
     */
    public function getDocHolderFormattedName()
    {
        return isset($this->DocHolderFormattedName) ? $this->DocHolderFormattedName : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDocHolderFormattedName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocHolderFormattedName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDocHolderFormattedNameForChoiceConstraintsFromSetDocHolderFormattedName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DocHolderName',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DocHolderFormattedName can\'t be set as the property %s is already set. Only one property must be set among these properties: DocHolderFormattedName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DocHolderFormattedName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $docHolderFormattedName
     * @return \StructType\DocumentType
     */
    public function setDocHolderFormattedName($docHolderFormattedName = null)
    {
        // validation for constraint: choice(DocHolderName, DocHolderFormattedName)
        if ('' !== ($docHolderFormattedNameChoiceErrorMessage = self::validateDocHolderFormattedNameForChoiceConstraintsFromSetDocHolderFormattedName($docHolderFormattedName))) {
            throw new \InvalidArgumentException($docHolderFormattedNameChoiceErrorMessage, __LINE__);
        }
        if (is_null($docHolderFormattedName) || (is_array($docHolderFormattedName) && empty($docHolderFormattedName))) {
            unset($this->DocHolderFormattedName);
        } else {
            $this->DocHolderFormattedName = $docHolderFormattedName;
        }
        return $this;
    }
    /**
     * Get DocLimitations value
     * @return mixed[]|null
     */
    public function getDocLimitations()
    {
        return $this->DocLimitations;
    }
    /**
     * This method is responsible for validating the values passed to the setDocLimitations method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocLimitations method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocLimitationsForArrayConstraintsFromSetDocLimitations(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeDocLimitationsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($documentTypeDocLimitationsItem) ? get_class($documentTypeDocLimitationsItem) : sprintf('%s(%s)', gettype($documentTypeDocLimitationsItem), var_export($documentTypeDocLimitationsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocLimitations property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocLimitations value
     * @throws \InvalidArgumentException
     * @param mixed[] $docLimitations
     * @return \StructType\DocumentType
     */
    public function setDocLimitations(array $docLimitations = array())
    {
        // validation for constraint: array
        if ('' !== ($docLimitationsArrayErrorMessage = self::validateDocLimitationsForArrayConstraintsFromSetDocLimitations($docLimitations))) {
            throw new \InvalidArgumentException($docLimitationsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($docLimitations) && count($docLimitations) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($docLimitations)), __LINE__);
        }
        $this->DocLimitations = $docLimitations;
        return $this;
    }
    /**
     * Add item to DocLimitations value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\DocumentType
     */
    public function addToDocLimitations($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The DocLimitations property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->DocLimitations) && count($this->DocLimitations) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->DocLimitations)), __LINE__);
        }
        $this->DocLimitations[] = $item;
        return $this;
    }
    /**
     * Get AdditionalPersonNames value
     * @return \StructType\AdditionalPersonNames|null
     */
    public function getAdditionalPersonNames()
    {
        return $this->AdditionalPersonNames;
    }
    /**
     * Set AdditionalPersonNames value
     * @param \StructType\AdditionalPersonNames $additionalPersonNames
     * @return \StructType\DocumentType
     */
    public function setAdditionalPersonNames(\StructType\AdditionalPersonNames $additionalPersonNames = null)
    {
        $this->AdditionalPersonNames = $additionalPersonNames;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\DocumentType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get DocIssueAuthority value
     * @return string|null
     */
    public function getDocIssueAuthority()
    {
        return $this->DocIssueAuthority;
    }
    /**
     * Set DocIssueAuthority value
     * @param string $docIssueAuthority
     * @return \StructType\DocumentType
     */
    public function setDocIssueAuthority($docIssueAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueAuthority) && !is_string($docIssueAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueAuthority, true), gettype($docIssueAuthority)), __LINE__);
        }
        $this->DocIssueAuthority = $docIssueAuthority;
        return $this;
    }
    /**
     * Get DocIssueLocation value
     * @return string|null
     */
    public function getDocIssueLocation()
    {
        return $this->DocIssueLocation;
    }
    /**
     * Set DocIssueLocation value
     * @param string $docIssueLocation
     * @return \StructType\DocumentType
     */
    public function setDocIssueLocation($docIssueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueLocation) && !is_string($docIssueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueLocation, true), gettype($docIssueLocation)), __LINE__);
        }
        $this->DocIssueLocation = $docIssueLocation;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \StructType\DocumentType
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \StructType\DocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docType, true), gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocIssueStateProv value
     * @return mixed|null
     */
    public function getDocIssueStateProv()
    {
        return $this->DocIssueStateProv;
    }
    /**
     * Set DocIssueStateProv value
     * @param mixed $docIssueStateProv
     * @return \StructType\DocumentType
     */
    public function setDocIssueStateProv($docIssueStateProv = null)
    {
        $this->DocIssueStateProv = $docIssueStateProv;
        return $this;
    }
    /**
     * Get DocIssueCountry value
     * @return string|null
     */
    public function getDocIssueCountry()
    {
        return $this->DocIssueCountry;
    }
    /**
     * Set DocIssueCountry value
     * @param string $docIssueCountry
     * @return \StructType\DocumentType
     */
    public function setDocIssueCountry($docIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($docIssueCountry) && !is_string($docIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docIssueCountry, true), gettype($docIssueCountry)), __LINE__);
        }
        $this->DocIssueCountry = $docIssueCountry;
        return $this;
    }
    /**
     * Get BirthCountry value
     * @return string|null
     */
    public function getBirthCountry()
    {
        return $this->BirthCountry;
    }
    /**
     * Set BirthCountry value
     * @param string $birthCountry
     * @return \StructType\DocumentType
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthCountry, true), gettype($birthCountry)), __LINE__);
        }
        $this->BirthCountry = $birthCountry;
        return $this;
    }
    /**
     * Get BirthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->BirthPlace;
    }
    /**
     * Set BirthPlace value
     * @param string $birthPlace
     * @return \StructType\DocumentType
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthPlace, true), gettype($birthPlace)), __LINE__);
        }
        $this->BirthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get DocHolderNationality value
     * @return string|null
     */
    public function getDocHolderNationality()
    {
        return $this->DocHolderNationality;
    }
    /**
     * Set DocHolderNationality value
     * @param string $docHolderNationality
     * @return \StructType\DocumentType
     */
    public function setDocHolderNationality($docHolderNationality = null)
    {
        // validation for constraint: string
        if (!is_null($docHolderNationality) && !is_string($docHolderNationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docHolderNationality, true), gettype($docHolderNationality)), __LINE__);
        }
        $this->DocHolderNationality = $docHolderNationality;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\DocumentType
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get HolderType value
     * @return string|null
     */
    public function getHolderType()
    {
        return $this->HolderType;
    }
    /**
     * Set HolderType value
     * @param string $holderType
     * @return \StructType\DocumentType
     */
    public function setHolderType($holderType = null)
    {
        // validation for constraint: string
        if (!is_null($holderType) && !is_string($holderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holderType, true), gettype($holderType)), __LINE__);
        }
        $this->HolderType = $holderType;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\DocumentType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\DocumentType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
