<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributorTypes StructType
 * Meta information extracted from the WSDL
 * - documentation: A Collection of strings that identify the distibutors (ex Tour Operators, Agency Chains, etc) which are allowed viewership.
 * @subpackage Structs
 */
class DistributorTypes extends AbstractStructBase
{
    /**
     * The DistributorType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DistributorType[]
     */
    public $DistributorType;
    /**
     * Constructor method for DistributorTypes
     * @uses DistributorTypes::setDistributorType()
     * @param \StructType\DistributorType[] $distributorType
     */
    public function __construct(array $distributorType = array())
    {
        $this
            ->setDistributorType($distributorType);
    }
    /**
     * Get DistributorType value
     * @return \StructType\DistributorType[]|null
     */
    public function getDistributorType()
    {
        return $this->DistributorType;
    }
    /**
     * This method is responsible for validating the values passed to the setDistributorType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistributorType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistributorTypeForArrayConstraintsFromSetDistributorType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $distributorTypesDistributorTypeItem) {
            // validation for constraint: itemType
            if (!$distributorTypesDistributorTypeItem instanceof \StructType\DistributorType) {
                $invalidValues[] = is_object($distributorTypesDistributorTypeItem) ? get_class($distributorTypesDistributorTypeItem) : sprintf('%s(%s)', gettype($distributorTypesDistributorTypeItem), var_export($distributorTypesDistributorTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DistributorType property can only contain items of type \StructType\DistributorType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DistributorType value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributorType[] $distributorType
     * @return \StructType\DistributorTypes
     */
    public function setDistributorType(array $distributorType = array())
    {
        // validation for constraint: array
        if ('' !== ($distributorTypeArrayErrorMessage = self::validateDistributorTypeForArrayConstraintsFromSetDistributorType($distributorType))) {
            throw new \InvalidArgumentException($distributorTypeArrayErrorMessage, __LINE__);
        }
        $this->DistributorType = $distributorType;
        return $this;
    }
    /**
     * Add item to DistributorType value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributorType $item
     * @return \StructType\DistributorTypes
     */
    public function addToDistributorType(\StructType\DistributorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistributorType) {
            throw new \InvalidArgumentException(sprintf('The DistributorType property can only contain items of type \StructType\DistributorType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DistributorType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DistributorTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
