<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountPricing StructType
 * Meta information extracted from the WSDL
 * - documentation: The information needed when a passenger presents a discount/promotional coupon for a dollar/percentage of the fare or when a passenger qualifies for a percentage discount such as a senior discount. | The information needed when a
 * passenger presents a discount/promotional coupon for a dollar/percentage off the fare or when a passenger qualifies for a percentage discount such as a senior discount.
 * @subpackage Structs
 */
class DiscountPricing extends AbstractStructBase
{
    /**
     * The FlightReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \StructType\FlightReference[]
     */
    public $FlightReference;
    /**
     * Constructor method for DiscountPricing
     * @uses DiscountPricing::setFlightReference()
     * @param \StructType\FlightReference[] $flightReference
     */
    public function __construct(array $flightReference = array())
    {
        $this
            ->setFlightReference($flightReference);
    }
    /**
     * Get FlightReference value
     * @return \StructType\FlightReference[]|null
     */
    public function getFlightReference()
    {
        return $this->FlightReference;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightReferenceForArrayConstraintsFromSetFlightReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountPricingFlightReferenceItem) {
            // validation for constraint: itemType
            if (!$discountPricingFlightReferenceItem instanceof \StructType\FlightReference) {
                $invalidValues[] = is_object($discountPricingFlightReferenceItem) ? get_class($discountPricingFlightReferenceItem) : sprintf('%s(%s)', gettype($discountPricingFlightReferenceItem), var_export($discountPricingFlightReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightReference property can only contain items of type \StructType\FlightReference, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightReference[] $flightReference
     * @return \StructType\DiscountPricing
     */
    public function setFlightReference(array $flightReference = array())
    {
        // validation for constraint: array
        if ('' !== ($flightReferenceArrayErrorMessage = self::validateFlightReferenceForArrayConstraintsFromSetFlightReference($flightReference))) {
            throw new \InvalidArgumentException($flightReferenceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($flightReference) && count($flightReference) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 16', count($flightReference)), __LINE__);
        }
        $this->FlightReference = $flightReference;
        return $this;
    }
    /**
     * Add item to FlightReference value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightReference $item
     * @return \StructType\DiscountPricing
     */
    public function addToFlightReference(\StructType\FlightReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightReference) {
            throw new \InvalidArgumentException(sprintf('The FlightReference property can only contain items of type \StructType\FlightReference, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(16)
        if (is_array($this->FlightReference) && count($this->FlightReference) >= 16) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 16', count($this->FlightReference)), __LINE__);
        }
        $this->FlightReference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DiscountPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
