<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discount StructType
 * Meta information extracted from the WSDL
 * - documentation: Details regarding the discount. | Provides discount information associated with the fare. | Discount percentage and/or Amount, code and textual reason for discount | A collection of discounts applied to the total rail fare. |
 * Provides the discount as an amount as well as the currency code and decimal places for the currency in which the discount applies. Typically when an amount is applied the Percent would not be passed. | Defines the characteristics of the offer.
 * - type: MoneyOrPercentageType
 * - use: optional
 * @subpackage Structs
 */
class Discount extends DiscountType
{
    /**
     * The AppliesTo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AppliesTo;
    /**
     * The ItemRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the specific item referred to by the AppliesTo attribute.
     * - use: optional
     * @var string
     */
    public $ItemRPH;
    /**
     * The NightsRequired
     * Meta information extracted from the WSDL
     * - documentation: The number of nights required to be booked in order to apply the discount (this may be the extact number of nights required or the minimum number of nights required).
     * - use: optional
     * @var int
     */
    public $NightsRequired;
    /**
     * The NightsDiscounted
     * Meta information extracted from the WSDL
     * - documentation: The number of nights discounted for each multiple of NightsRequired.
     * - use: optional
     * @var int
     */
    public $NightsDiscounted;
    /**
     * The DiscountPattern
     * Meta information extracted from the WSDL
     * - documentation: This defines the pattern for the night(s) the discount applies (e.g., if NightsRequired="7" and the NightsDiscounted="1" then DiscountPattern="NNNNNNY" or DiscountPattern="0000001" when the discount is applied to the last night).
     * - use: optional
     * @var string
     */
    public $DiscountPattern;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Defines the percentage which is deducted from the rate amounts if this offer is applicable.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The ChargeUnitCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the unit per which the unit the discount applies (e.g., per person per stay). Refer to OpenTravel Code List Charge Type (CHG).
     * - use: optional
     * @var string
     */
    public $ChargeUnitCode;
    /**
     * Constructor method for Discount
     * @uses Discount::setAppliesTo()
     * @uses Discount::setItemRPH()
     * @uses Discount::setNightsRequired()
     * @uses Discount::setNightsDiscounted()
     * @uses Discount::setDiscountPattern()
     * @uses Discount::setPercent()
     * @uses Discount::setChargeUnitCode()
     * @param string $appliesTo
     * @param string $itemRPH
     * @param int $nightsRequired
     * @param int $nightsDiscounted
     * @param string $discountPattern
     * @param float $percent
     * @param string $chargeUnitCode
     */
    public function __construct($appliesTo = null, $itemRPH = null, $nightsRequired = null, $nightsDiscounted = null, $discountPattern = null, $percent = null, $chargeUnitCode = null)
    {
        $this
            ->setAppliesTo($appliesTo)
            ->setItemRPH($itemRPH)
            ->setNightsRequired($nightsRequired)
            ->setNightsDiscounted($nightsDiscounted)
            ->setDiscountPattern($discountPattern)
            ->setPercent($percent)
            ->setChargeUnitCode($chargeUnitCode);
    }
    /**
     * Get AppliesTo value
     * @return string|null
     */
    public function getAppliesTo()
    {
        return $this->AppliesTo;
    }
    /**
     * Set AppliesTo value
     * @param string $appliesTo
     * @return \StructType\Discount
     */
    public function setAppliesTo($appliesTo = null)
    {
        // validation for constraint: string
        if (!is_null($appliesTo) && !is_string($appliesTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appliesTo, true), gettype($appliesTo)), __LINE__);
        }
        $this->AppliesTo = $appliesTo;
        return $this;
    }
    /**
     * Get ItemRPH value
     * @return string|null
     */
    public function getItemRPH()
    {
        return $this->ItemRPH;
    }
    /**
     * Set ItemRPH value
     * @param string $itemRPH
     * @return \StructType\Discount
     */
    public function setItemRPH($itemRPH = null)
    {
        // validation for constraint: string
        if (!is_null($itemRPH) && !is_string($itemRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemRPH, true), gettype($itemRPH)), __LINE__);
        }
        $this->ItemRPH = $itemRPH;
        return $this;
    }
    /**
     * Get NightsRequired value
     * @return int|null
     */
    public function getNightsRequired()
    {
        return $this->NightsRequired;
    }
    /**
     * Set NightsRequired value
     * @param int $nightsRequired
     * @return \StructType\Discount
     */
    public function setNightsRequired($nightsRequired = null)
    {
        // validation for constraint: int
        if (!is_null($nightsRequired) && !(is_int($nightsRequired) || ctype_digit($nightsRequired))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nightsRequired, true), gettype($nightsRequired)), __LINE__);
        }
        $this->NightsRequired = $nightsRequired;
        return $this;
    }
    /**
     * Get NightsDiscounted value
     * @return int|null
     */
    public function getNightsDiscounted()
    {
        return $this->NightsDiscounted;
    }
    /**
     * Set NightsDiscounted value
     * @param int $nightsDiscounted
     * @return \StructType\Discount
     */
    public function setNightsDiscounted($nightsDiscounted = null)
    {
        // validation for constraint: int
        if (!is_null($nightsDiscounted) && !(is_int($nightsDiscounted) || ctype_digit($nightsDiscounted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nightsDiscounted, true), gettype($nightsDiscounted)), __LINE__);
        }
        $this->NightsDiscounted = $nightsDiscounted;
        return $this;
    }
    /**
     * Get DiscountPattern value
     * @return string|null
     */
    public function getDiscountPattern()
    {
        return $this->DiscountPattern;
    }
    /**
     * Set DiscountPattern value
     * @param string $discountPattern
     * @return \StructType\Discount
     */
    public function setDiscountPattern($discountPattern = null)
    {
        // validation for constraint: string
        if (!is_null($discountPattern) && !is_string($discountPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountPattern, true), gettype($discountPattern)), __LINE__);
        }
        $this->DiscountPattern = $discountPattern;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\Discount
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get ChargeUnitCode value
     * @return string|null
     */
    public function getChargeUnitCode()
    {
        return $this->ChargeUnitCode;
    }
    /**
     * Set ChargeUnitCode value
     * @param string $chargeUnitCode
     * @return \StructType\Discount
     */
    public function setChargeUnitCode($chargeUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnitCode) && !is_string($chargeUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeUnitCode, true), gettype($chargeUnitCode)), __LINE__);
        }
        $this->ChargeUnitCode = $chargeUnitCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Discount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
