<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionUnit StructType
 * Meta information extracted from the WSDL
 * - documentation: Example: US_Customary | Dimension unit of measure.
 * @subpackage Structs
 */
class DimensionUnit extends \EnumType\List_OfferDimensionUOM
{
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: Implementer: Size encoding specified in RequestedOffer/ @SizeWeightEncoding. | Example: 13 | Height value.
     * - use: optional
     * @var float
     */
    public $Height;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Implementer: Size encoding specified in RequestedOffer/ @SizeWeightEncoding. | Example: 23 | Length value.
     * - use: optional
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: Implementer: Size encoding specified in RequestedOffer/ @SizeWeightEncoding. | Example: 8 | Width value.
     * - use: optional
     * @var float
     */
    public $Width;
    /**
     * The OtherType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $OtherType;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for DimensionUnit
     * @uses DimensionUnit::setHeight()
     * @uses DimensionUnit::setLength()
     * @uses DimensionUnit::setWidth()
     * @uses DimensionUnit::setOtherType()
     * @uses DimensionUnit::setOntologyRefID()
     * @param float $height
     * @param float $length
     * @param float $width
     * @param string $otherType
     * @param string $ontologyRefID
     */
    public function __construct($height = null, $length = null, $width = null, $otherType = null, $ontologyRefID = null)
    {
        $this
            ->setHeight($height)
            ->setLength($length)
            ->setWidth($width)
            ->setOtherType($otherType)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get Height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\DimensionUnit
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\DimensionUnit
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\DimensionUnit
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get OtherType value
     * @return string|null
     */
    public function getOtherType()
    {
        return $this->OtherType;
    }
    /**
     * Set OtherType value
     * @param string $otherType
     * @return \StructType\DimensionUnit
     */
    public function setOtherType($otherType = null)
    {
        // validation for constraint: string
        if (!is_null($otherType) && !is_string($otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherType, true), gettype($otherType)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($otherType) && !preg_match('/[a-zA-Z0-9]{1,64}/', $otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($otherType, true)), __LINE__);
        }
        $this->OtherType = $otherType;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\DimensionUnit
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DimensionUnit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
