<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Detail StructType
 * Meta information extracted from the WSDL
 * - documentation: Baggage item details. | Animal details.
 * @subpackage Structs
 */
class Detail extends AbstractStructBase
{
    /**
     * The Type
     * @var \StructType\Type
     */
    public $Type;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - documentation: Baggage weight.
     * - minOccurs: 0
     * @var \StructType\Weight
     */
    public $Weight;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The Item
     * @var \StructType\Item
     */
    public $Item;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - documentation: Baggage size.
     * - minOccurs: 0
     * @var mixed
     */
    public $Size;
    /**
     * Constructor method for Detail
     * @uses Detail::setType()
     * @uses Detail::setWeight()
     * @uses Detail::setOntologyExtension()
     * @uses Detail::setItem()
     * @uses Detail::setSize()
     * @param \StructType\Type $type
     * @param \StructType\Weight $weight
     * @param mixed $ontologyExtension
     * @param \StructType\Item $item
     * @param mixed $size
     */
    public function __construct(\StructType\Type $type = null, \StructType\Weight $weight = null, $ontologyExtension = null, \StructType\Item $item = null, $size = null)
    {
        $this
            ->setType($type)
            ->setWeight($weight)
            ->setOntologyExtension($ontologyExtension)
            ->setItem($item)
            ->setSize($size);
    }
    /**
     * Get Type value
     * @return \StructType\Type|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\Type $type
     * @return \StructType\Detail
     */
    public function setType(\StructType\Type $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Weight value
     * @return \StructType\Weight|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param \StructType\Weight $weight
     * @return \StructType\Detail
     */
    public function setWeight(\StructType\Weight $weight = null)
    {
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\Detail
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get Item value
     * @return \StructType\Item|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \StructType\Item $item
     * @return \StructType\Detail
     */
    public function setItem(\StructType\Item $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get Size value
     * @return mixed|null
     */
    public function getSize()
    {
        return $this->Size;
    }
    /**
     * Set Size value
     * @param mixed $size
     * @return \StructType\Detail
     */
    public function setSize($size = null)
    {
        $this->Size = $size;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Detail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
