<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationSystemCodes StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of destination system codes. These are systems for which this Sellable product is targeted.
 * @subpackage Structs
 */
class DestinationSystemCodes extends AbstractStructBase
{
    /**
     * The DestinationSystemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\DestinationSystemCode[]
     */
    public $DestinationSystemCode;
    /**
     * Constructor method for DestinationSystemCodes
     * @uses DestinationSystemCodes::setDestinationSystemCode()
     * @param \StructType\DestinationSystemCode[] $destinationSystemCode
     */
    public function __construct(array $destinationSystemCode = array())
    {
        $this
            ->setDestinationSystemCode($destinationSystemCode);
    }
    /**
     * Get DestinationSystemCode value
     * @return \StructType\DestinationSystemCode[]|null
     */
    public function getDestinationSystemCode()
    {
        return $this->DestinationSystemCode;
    }
    /**
     * This method is responsible for validating the values passed to the setDestinationSystemCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestinationSystemCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDestinationSystemCodeForArrayConstraintsFromSetDestinationSystemCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationSystemCodesDestinationSystemCodeItem) {
            // validation for constraint: itemType
            if (!$destinationSystemCodesDestinationSystemCodeItem instanceof \StructType\DestinationSystemCode) {
                $invalidValues[] = is_object($destinationSystemCodesDestinationSystemCodeItem) ? get_class($destinationSystemCodesDestinationSystemCodeItem) : sprintf('%s(%s)', gettype($destinationSystemCodesDestinationSystemCodeItem), var_export($destinationSystemCodesDestinationSystemCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DestinationSystemCode property can only contain items of type \StructType\DestinationSystemCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DestinationSystemCode value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationSystemCode[] $destinationSystemCode
     * @return \StructType\DestinationSystemCodes
     */
    public function setDestinationSystemCode(array $destinationSystemCode = array())
    {
        // validation for constraint: array
        if ('' !== ($destinationSystemCodeArrayErrorMessage = self::validateDestinationSystemCodeForArrayConstraintsFromSetDestinationSystemCode($destinationSystemCode))) {
            throw new \InvalidArgumentException($destinationSystemCodeArrayErrorMessage, __LINE__);
        }
        $this->DestinationSystemCode = $destinationSystemCode;
        return $this;
    }
    /**
     * Add item to DestinationSystemCode value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationSystemCode $item
     * @return \StructType\DestinationSystemCodes
     */
    public function addToDestinationSystemCode(\StructType\DestinationSystemCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DestinationSystemCode) {
            throw new \InvalidArgumentException(sprintf('The DestinationSystemCode property can only contain items of type \StructType\DestinationSystemCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DestinationSystemCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationSystemCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
