<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationSystemCode StructType
 * Meta information extracted from the WSDL
 * - documentation: The destination system code defines a system to which information is to be provided. | Used for Character Strings, length 1 to 32.
 * - base: xs:string
 * - maxLength: 32
 * - minLength: 1
 * @subpackage Structs
 */
class DestinationSystemCode extends AbstractStructBase
{
    /**
     * The ChainRateLevelCrossRef
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system code for a corresponding RateLevelCode.
     * - use: optional
     * @var string
     */
    public $ChainRateLevelCrossRef;
    /**
     * The ChainRateCodeCrossRef
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system code for a corresponding ChainRateCode.
     * - use: optional
     * @var string
     */
    public $ChainRateCodeCrossRef;
    /**
     * The LengthOfStayRuleID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system value which represents a rule for Length of Stay settings.
     * - use: optional
     * @var string
     */
    public $LengthOfStayRuleID;
    /**
     * The POS_RuleID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system value which represents a rule for defined viewership settings.
     * - use: optional
     * @var string
     */
    public $POS_RuleID;
    /**
     * The RateAccessID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system value which represents a special ID used for defined viewership settings.
     * - use: optional
     * @var string
     */
    public $RateAccessID;
    /**
     * The GuaranteeDepositRuleID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system value which represents a rule for deposits.
     * - use: optional
     * @var string
     */
    public $GuaranteeDepositRuleID;
    /**
     * The CancelRuleID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to define a specific destination system value which represents a rule for cancellations.
     * - use: optional
     * @var string
     */
    public $CancelRuleID;
    /**
     * Constructor method for DestinationSystemCode
     * @uses DestinationSystemCode::setChainRateLevelCrossRef()
     * @uses DestinationSystemCode::setChainRateCodeCrossRef()
     * @uses DestinationSystemCode::setLengthOfStayRuleID()
     * @uses DestinationSystemCode::setPOS_RuleID()
     * @uses DestinationSystemCode::setRateAccessID()
     * @uses DestinationSystemCode::setGuaranteeDepositRuleID()
     * @uses DestinationSystemCode::setCancelRuleID()
     * @param string $chainRateLevelCrossRef
     * @param string $chainRateCodeCrossRef
     * @param string $lengthOfStayRuleID
     * @param string $pOS_RuleID
     * @param string $rateAccessID
     * @param string $guaranteeDepositRuleID
     * @param string $cancelRuleID
     */
    public function __construct($chainRateLevelCrossRef = null, $chainRateCodeCrossRef = null, $lengthOfStayRuleID = null, $pOS_RuleID = null, $rateAccessID = null, $guaranteeDepositRuleID = null, $cancelRuleID = null)
    {
        $this
            ->setChainRateLevelCrossRef($chainRateLevelCrossRef)
            ->setChainRateCodeCrossRef($chainRateCodeCrossRef)
            ->setLengthOfStayRuleID($lengthOfStayRuleID)
            ->setPOS_RuleID($pOS_RuleID)
            ->setRateAccessID($rateAccessID)
            ->setGuaranteeDepositRuleID($guaranteeDepositRuleID)
            ->setCancelRuleID($cancelRuleID);
    }
    /**
     * Get ChainRateLevelCrossRef value
     * @return string|null
     */
    public function getChainRateLevelCrossRef()
    {
        return $this->ChainRateLevelCrossRef;
    }
    /**
     * Set ChainRateLevelCrossRef value
     * @param string $chainRateLevelCrossRef
     * @return \StructType\DestinationSystemCode
     */
    public function setChainRateLevelCrossRef($chainRateLevelCrossRef = null)
    {
        // validation for constraint: string
        if (!is_null($chainRateLevelCrossRef) && !is_string($chainRateLevelCrossRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainRateLevelCrossRef, true), gettype($chainRateLevelCrossRef)), __LINE__);
        }
        $this->ChainRateLevelCrossRef = $chainRateLevelCrossRef;
        return $this;
    }
    /**
     * Get ChainRateCodeCrossRef value
     * @return string|null
     */
    public function getChainRateCodeCrossRef()
    {
        return $this->ChainRateCodeCrossRef;
    }
    /**
     * Set ChainRateCodeCrossRef value
     * @param string $chainRateCodeCrossRef
     * @return \StructType\DestinationSystemCode
     */
    public function setChainRateCodeCrossRef($chainRateCodeCrossRef = null)
    {
        // validation for constraint: string
        if (!is_null($chainRateCodeCrossRef) && !is_string($chainRateCodeCrossRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainRateCodeCrossRef, true), gettype($chainRateCodeCrossRef)), __LINE__);
        }
        $this->ChainRateCodeCrossRef = $chainRateCodeCrossRef;
        return $this;
    }
    /**
     * Get LengthOfStayRuleID value
     * @return string|null
     */
    public function getLengthOfStayRuleID()
    {
        return $this->LengthOfStayRuleID;
    }
    /**
     * Set LengthOfStayRuleID value
     * @param string $lengthOfStayRuleID
     * @return \StructType\DestinationSystemCode
     */
    public function setLengthOfStayRuleID($lengthOfStayRuleID = null)
    {
        // validation for constraint: string
        if (!is_null($lengthOfStayRuleID) && !is_string($lengthOfStayRuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lengthOfStayRuleID, true), gettype($lengthOfStayRuleID)), __LINE__);
        }
        $this->LengthOfStayRuleID = $lengthOfStayRuleID;
        return $this;
    }
    /**
     * Get POS_RuleID value
     * @return string|null
     */
    public function getPOS_RuleID()
    {
        return $this->POS_RuleID;
    }
    /**
     * Set POS_RuleID value
     * @param string $pOS_RuleID
     * @return \StructType\DestinationSystemCode
     */
    public function setPOS_RuleID($pOS_RuleID = null)
    {
        // validation for constraint: string
        if (!is_null($pOS_RuleID) && !is_string($pOS_RuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOS_RuleID, true), gettype($pOS_RuleID)), __LINE__);
        }
        $this->POS_RuleID = $pOS_RuleID;
        return $this;
    }
    /**
     * Get RateAccessID value
     * @return string|null
     */
    public function getRateAccessID()
    {
        return $this->RateAccessID;
    }
    /**
     * Set RateAccessID value
     * @param string $rateAccessID
     * @return \StructType\DestinationSystemCode
     */
    public function setRateAccessID($rateAccessID = null)
    {
        // validation for constraint: string
        if (!is_null($rateAccessID) && !is_string($rateAccessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateAccessID, true), gettype($rateAccessID)), __LINE__);
        }
        $this->RateAccessID = $rateAccessID;
        return $this;
    }
    /**
     * Get GuaranteeDepositRuleID value
     * @return string|null
     */
    public function getGuaranteeDepositRuleID()
    {
        return $this->GuaranteeDepositRuleID;
    }
    /**
     * Set GuaranteeDepositRuleID value
     * @param string $guaranteeDepositRuleID
     * @return \StructType\DestinationSystemCode
     */
    public function setGuaranteeDepositRuleID($guaranteeDepositRuleID = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeDepositRuleID) && !is_string($guaranteeDepositRuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeDepositRuleID, true), gettype($guaranteeDepositRuleID)), __LINE__);
        }
        $this->GuaranteeDepositRuleID = $guaranteeDepositRuleID;
        return $this;
    }
    /**
     * Get CancelRuleID value
     * @return string|null
     */
    public function getCancelRuleID()
    {
        return $this->CancelRuleID;
    }
    /**
     * Set CancelRuleID value
     * @param string $cancelRuleID
     * @return \StructType\DestinationSystemCode
     */
    public function setCancelRuleID($cancelRuleID = null)
    {
        // validation for constraint: string
        if (!is_null($cancelRuleID) && !is_string($cancelRuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelRuleID, true), gettype($cancelRuleID)), __LINE__);
        }
        $this->CancelRuleID = $cancelRuleID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationSystemCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
