<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DesignatorCode StructType
 * Meta information extracted from the WSDL
 * - documentation: The airport location code associated with the @Designator. | The exempt tax code.Select a pre-defined value from the list, or use the "Other_" value in combination with the @ExtDesignatorCode.
 * @subpackage Structs
 */
class DesignatorCode extends \EnumType\AirTaxExemptionEnum
{
    /**
     * The ExtDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: NOTE: Any extended enumeration values should be agreed upon between trading partners prior to use. | A string value that represents an extended enumerated value for the @DesignatorCode. To use this feature, select the "Other_" item
     * from the DesignatorCode list.
     * - use: optional
     * @var string
     */
    public $ExtDesignatorCode;
    /**
     * Constructor method for DesignatorCode
     * @uses DesignatorCode::setExtDesignatorCode()
     * @param string $extDesignatorCode
     */
    public function __construct($extDesignatorCode = null)
    {
        $this
            ->setExtDesignatorCode($extDesignatorCode);
    }
    /**
     * Get ExtDesignatorCode value
     * @return string|null
     */
    public function getExtDesignatorCode()
    {
        return $this->ExtDesignatorCode;
    }
    /**
     * Set ExtDesignatorCode value
     * @param string $extDesignatorCode
     * @return \StructType\DesignatorCode
     */
    public function setExtDesignatorCode($extDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($extDesignatorCode) && !is_string($extDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extDesignatorCode, true), gettype($extDesignatorCode)), __LINE__);
        }
        $this->ExtDesignatorCode = $extDesignatorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DesignatorCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
