<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Descriptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of hotel and/or renovation information. | Collection of affiliation descriptions.
 * @subpackage Structs
 */
class Descriptions extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Describes affiliation information (e.g., accolades, recognition).
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Description;
    /**
     * The Renovation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Renovation[]
     */
    public $Renovation;
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MultimediaDescriptions
     */
    public $MultimediaDescriptions;
    /**
     * The DescriptiveText
     * Meta information extracted from the WSDL
     * - documentation: Descriptive text that describes the hotel.
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * Constructor method for Descriptions
     * @uses Descriptions::setDescription()
     * @uses Descriptions::setRenovation()
     * @uses Descriptions::setMultimediaDescriptions()
     * @uses Descriptions::setDescriptiveText()
     * @param mixed[] $description
     * @param \StructType\Renovation[] $renovation
     * @param \StructType\MultimediaDescriptions $multimediaDescriptions
     * @param string $descriptiveText
     */
    public function __construct(array $description = array(), array $renovation = array(), \StructType\MultimediaDescriptions $multimediaDescriptions = null, $descriptiveText = null)
    {
        $this
            ->setDescription($description)
            ->setRenovation($renovation)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setDescriptiveText($descriptiveText);
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $descriptionsDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($descriptionsDescriptionItem) ? get_class($descriptionsDescriptionItem) : sprintf('%s(%s)', gettype($descriptionsDescriptionItem), var_export($descriptionsDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\Descriptions
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($description) && count($description) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Descriptions
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Description) && count($this->Description) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Renovation value
     * @return \StructType\Renovation[]|null
     */
    public function getRenovation()
    {
        return $this->Renovation;
    }
    /**
     * This method is responsible for validating the values passed to the setRenovation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRenovation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRenovationForArrayConstraintsFromSetRenovation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $descriptionsRenovationItem) {
            // validation for constraint: itemType
            if (!$descriptionsRenovationItem instanceof \StructType\Renovation) {
                $invalidValues[] = is_object($descriptionsRenovationItem) ? get_class($descriptionsRenovationItem) : sprintf('%s(%s)', gettype($descriptionsRenovationItem), var_export($descriptionsRenovationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Renovation property can only contain items of type \StructType\Renovation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Renovation value
     * @throws \InvalidArgumentException
     * @param \StructType\Renovation[] $renovation
     * @return \StructType\Descriptions
     */
    public function setRenovation(array $renovation = array())
    {
        // validation for constraint: array
        if ('' !== ($renovationArrayErrorMessage = self::validateRenovationForArrayConstraintsFromSetRenovation($renovation))) {
            throw new \InvalidArgumentException($renovationArrayErrorMessage, __LINE__);
        }
        $this->Renovation = $renovation;
        return $this;
    }
    /**
     * Add item to Renovation value
     * @throws \InvalidArgumentException
     * @param \StructType\Renovation $item
     * @return \StructType\Descriptions
     */
    public function addToRenovation(\StructType\Renovation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Renovation) {
            throw new \InvalidArgumentException(sprintf('The Renovation property can only contain items of type \StructType\Renovation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Renovation[] = $item;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \StructType\MultimediaDescriptions|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \StructType\MultimediaDescriptions $multimediaDescriptions
     * @return \StructType\Descriptions
     */
    public function setMultimediaDescriptions(\StructType\MultimediaDescriptions $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \StructType\Descriptions
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Descriptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
