<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeductibleType StructType
 * Meta information extracted from the WSDL
 * - documentation: The deductible amount for this coverage.
 * @subpackage Structs
 */
class DeductibleType extends AbstractStructBase
{
    /**
     * The LiabilityAmount
     * Meta information extracted from the WSDL
     * - documentation: The total liability amount for this coverage.
     * - use: optional
     * @var float
     */
    public $LiabilityAmount;
    /**
     * The ExcessAmount
     * Meta information extracted from the WSDL
     * - documentation: The excess amount for this coverage.
     * - use: optional
     * @var float
     */
    public $ExcessAmount;
    /**
     * Constructor method for DeductibleType
     * @uses DeductibleType::setLiabilityAmount()
     * @uses DeductibleType::setExcessAmount()
     * @param float $liabilityAmount
     * @param float $excessAmount
     */
    public function __construct($liabilityAmount = null, $excessAmount = null)
    {
        $this
            ->setLiabilityAmount($liabilityAmount)
            ->setExcessAmount($excessAmount);
    }
    /**
     * Get LiabilityAmount value
     * @return float|null
     */
    public function getLiabilityAmount()
    {
        return $this->LiabilityAmount;
    }
    /**
     * Set LiabilityAmount value
     * @param float $liabilityAmount
     * @return \StructType\DeductibleType
     */
    public function setLiabilityAmount($liabilityAmount = null)
    {
        // validation for constraint: float
        if (!is_null($liabilityAmount) && !(is_float($liabilityAmount) || is_numeric($liabilityAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($liabilityAmount, true), gettype($liabilityAmount)), __LINE__);
        }
        $this->LiabilityAmount = $liabilityAmount;
        return $this;
    }
    /**
     * Get ExcessAmount value
     * @return float|null
     */
    public function getExcessAmount()
    {
        return $this->ExcessAmount;
    }
    /**
     * Set ExcessAmount value
     * @param float $excessAmount
     * @return \StructType\DeductibleType
     */
    public function setExcessAmount($excessAmount = null)
    {
        // validation for constraint: float
        if (!is_null($excessAmount) && !(is_float($excessAmount) || is_numeric($excessAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($excessAmount, true), gettype($excessAmount)), __LINE__);
        }
        $this->ExcessAmount = $excessAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeductibleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
