<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateRestriction StructType
 * Meta information extracted from the WSDL
 * - documentation: The date or date range to which the date restriction applies. | Defines date restrictions for booking and/or stays with this offer.
 * @subpackage Structs
 */
class DateRestriction extends AbstractStructBase
{
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RestrictionType;
    /**
     * Constructor method for DateRestriction
     * @uses DateRestriction::setRestrictionType()
     * @param string $restrictionType
     */
    public function __construct($restrictionType = null)
    {
        $this
            ->setRestrictionType($restrictionType);
    }
    /**
     * Get RestrictionType value
     * @return string|null
     */
    public function getRestrictionType()
    {
        return $this->RestrictionType;
    }
    /**
     * Set RestrictionType value
     * @param string $restrictionType
     * @return \StructType\DateRestriction
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionType) && !is_string($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionType, true), gettype($restrictionType)), __LINE__);
        }
        $this->RestrictionType = $restrictionType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DateRestriction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
