<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType StructType
 * Meta information extracted from the WSDL
 * - documentation: The primary language of the customer. | Type of funds preferred for reviewing monetary values, in ISO 4217 codes. | Identifies the birth date of the customer. | Identifies the gender of the customer. | Contains basic data on the
 * customer's identity, location, relationships, finances, memberships, etc.
 * - type: StringLength1to8
 * - use: optional
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - documentation: Detailed name information for the customer.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Email[]
     */
    public $Email;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\Address[]
     */
    public $Address;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\URL[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\PhysChallName[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta information extracted from the WSDL
     * - documentation: Describes the customer's pet.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \StructType\PaymentForm[]
     */
    public $PaymentForm;
    /**
     * The RelatedTraveler
     * Meta information extracted from the WSDL
     * - documentation: Identifies a traveler associated with the customer.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RelatedTraveler;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Information on a contact person for the customer.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ContactPerson;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - documentation: Detailed document information for the customer (e.g., driver license, passport, visa).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Document;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - maxOccurs: 25
     * - minOccurs: 0
     * @var \StructType\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta information extracted from the WSDL
     * - documentation: Employment information for the customer.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta information extracted from the WSDL
     * - documentation: Identifies the customer's employer.
     * - minOccurs: 0
     * @var mixed
     */
    public $EmployerInfo;
    /**
     * The AdditionalLanguage
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\AdditionalLanguage[]
     */
    public $AdditionalLanguage;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Deceased
     * Meta information extracted from the WSDL
     * - documentation: When true the customer is deceased.
     * - use: optional
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * Meta information extracted from the WSDL
     * - documentation: Indicates reason for locking out record, such as Emergency, Incident, etc.
     * - use: optional
     * @var string
     */
    public $LockoutType;
    /**
     * The VIP_Indicator
     * Meta information extracted from the WSDL
     * - documentation: If true, indicates a very important person.
     * - use: optional
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Used to specify textual information about the customer.
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The CustomerValue
     * Meta information extracted from the WSDL
     * - documentation: The supplier's ranking of the customer (e.g., VIP, numerical ranking).
     * - use: optional
     * @var string
     */
    public $CustomerValue;
    /**
     * The MaritalStatus
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MaritalStatus;
    /**
     * The PreviouslyMarriedIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the customer was previously married. When false, indicates the customer was not previously married.
     * - use: optional
     * @var bool
     */
    public $PreviouslyMarriedIndicator;
    /**
     * The ChildQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of children of the customer.
     * - use: optional
     * @var int
     */
    public $ChildQuantity;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setURL()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setPhysChallName()
     * @uses CustomerType::setPetInfo()
     * @uses CustomerType::setPaymentForm()
     * @uses CustomerType::setRelatedTraveler()
     * @uses CustomerType::setContactPerson()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setEmployeeInfo()
     * @uses CustomerType::setEmployerInfo()
     * @uses CustomerType::setAdditionalLanguage()
     * @uses CustomerType::setTPA_Extensions()
     * @uses CustomerType::setDeceased()
     * @uses CustomerType::setLockoutType()
     * @uses CustomerType::setVIP_Indicator()
     * @uses CustomerType::setText()
     * @uses CustomerType::setCustomerValue()
     * @uses CustomerType::setMaritalStatus()
     * @uses CustomerType::setPreviouslyMarriedIndicator()
     * @uses CustomerType::setChildQuantity()
     * @param mixed[] $personName
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\Email[] $email
     * @param \StructType\Address[] $address
     * @param \StructType\URL[] $uRL
     * @param \StructType\CitizenCountryName[] $citizenCountryName
     * @param \StructType\PhysChallName[] $physChallName
     * @param mixed[] $petInfo
     * @param \StructType\PaymentForm[] $paymentForm
     * @param mixed[] $relatedTraveler
     * @param mixed[] $contactPerson
     * @param mixed[] $document
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @param mixed[] $employeeInfo
     * @param mixed $employerInfo
     * @param \StructType\AdditionalLanguage[] $additionalLanguage
     * @param mixed $tPA_Extensions
     * @param bool $deceased
     * @param string $lockoutType
     * @param bool $vIP_Indicator
     * @param string $text
     * @param string $customerValue
     * @param string $maritalStatus
     * @param bool $previouslyMarriedIndicator
     * @param int $childQuantity
     */
    public function __construct(array $personName = array(), array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $relatedTraveler = array(), array $contactPerson = array(), array $document = array(), array $custLoyalty = array(), array $employeeInfo = array(), $employerInfo = null, array $additionalLanguage = array(), $tPA_Extensions = null, $deceased = null, $lockoutType = null, $vIP_Indicator = null, $text = null, $customerValue = null, $maritalStatus = null, $previouslyMarriedIndicator = null, $childQuantity = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setRelatedTraveler($relatedTraveler)
            ->setContactPerson($contactPerson)
            ->setDocument($document)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setAdditionalLanguage($additionalLanguage)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setVIP_Indicator($vIP_Indicator)
            ->setText($text)
            ->setCustomerValue($customerValue)
            ->setMaritalStatus($maritalStatus)
            ->setPreviouslyMarriedIndicator($previouslyMarriedIndicator)
            ->setChildQuantity($childQuantity);
    }
    /**
     * Get PersonName value
     * @return mixed[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonNameForArrayConstraintsFromSetPersonName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePersonNameItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($customerTypePersonNameItem) ? get_class($customerTypePersonNameItem) : sprintf('%s(%s)', gettype($customerTypePersonNameItem), var_export($customerTypePersonNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonName property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param mixed[] $personName
     * @return \StructType\CustomerType
     */
    public function setPersonName(array $personName = array())
    {
        // validation for constraint: array
        if ('' !== ($personNameArrayErrorMessage = self::validatePersonNameForArrayConstraintsFromSetPersonName($personName))) {
            throw new \InvalidArgumentException($personNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($personName) && count($personName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($personName)), __LINE__);
        }
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CustomerType
     */
    public function addToPersonName($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PersonName property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PersonName) && count($this->PersonName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PersonName)), __LINE__);
        }
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($customerTypeTelephoneItem) ? get_class($customerTypeTelephoneItem) : sprintf('%s(%s)', gettype($customerTypeTelephoneItem), var_export($customerTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($telephone) && count($telephone) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\CustomerType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Telephone) && count($this->Telephone) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmailItem) {
            // validation for constraint: itemType
            if (!$customerTypeEmailItem instanceof \StructType\Email) {
                $invalidValues[] = is_object($customerTypeEmailItem) ? get_class($customerTypeEmailItem) : sprintf('%s(%s)', gettype($customerTypeEmailItem), var_export($customerTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email[] $email
     * @return \StructType\CustomerType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($email) && count($email) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email $item
     * @return \StructType\CustomerType
     */
    public function addToEmail(\StructType\Email $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Email) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Email) && count($this->Email) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Email)), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeAddressItem) {
            // validation for constraint: itemType
            if (!$customerTypeAddressItem instanceof \StructType\Address) {
                $invalidValues[] = is_object($customerTypeAddressItem) ? get_class($customerTypeAddressItem) : sprintf('%s(%s)', gettype($customerTypeAddressItem), var_export($customerTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address[] $address
     * @return \StructType\CustomerType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($address) && count($address) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\Address $item
     * @return \StructType\CustomerType
     */
    public function addToAddress(\StructType\Address $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Address) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\Address, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Address) && count($this->Address) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \StructType\URL[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeURLItem) {
            // validation for constraint: itemType
            if (!$customerTypeURLItem instanceof \StructType\URL) {
                $invalidValues[] = is_object($customerTypeURLItem) ? get_class($customerTypeURLItem) : sprintf('%s(%s)', gettype($customerTypeURLItem), var_export($customerTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type \StructType\URL, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL[] $uRL
     * @return \StructType\CustomerType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($uRL) && count($uRL) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \StructType\URL $item
     * @return \StructType\CustomerType
     */
    public function addToURL(\StructType\URL $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\URL) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type \StructType\URL, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->URL) && count($this->URL) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->URL)), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \StructType\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * This method is responsible for validating the values passed to the setCitizenCountryName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCitizenCountryName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCitizenCountryNameItem) {
            // validation for constraint: itemType
            if (!$customerTypeCitizenCountryNameItem instanceof \StructType\CitizenCountryName) {
                $invalidValues[] = is_object($customerTypeCitizenCountryNameItem) ? get_class($customerTypeCitizenCountryNameItem) : sprintf('%s(%s)', gettype($customerTypeCitizenCountryNameItem), var_export($customerTypeCitizenCountryNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CitizenCountryName property can only contain items of type \StructType\CitizenCountryName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenCountryName[] $citizenCountryName
     * @return \StructType\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        // validation for constraint: array
        if ('' !== ($citizenCountryNameArrayErrorMessage = self::validateCitizenCountryNameForArrayConstraintsFromSetCitizenCountryName($citizenCountryName))) {
            throw new \InvalidArgumentException($citizenCountryNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($citizenCountryName) && count($citizenCountryName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($citizenCountryName)), __LINE__);
        }
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \StructType\CitizenCountryName $item
     * @return \StructType\CustomerType
     */
    public function addToCitizenCountryName(\StructType\CitizenCountryName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CitizenCountryName) {
            throw new \InvalidArgumentException(sprintf('The CitizenCountryName property can only contain items of type \StructType\CitizenCountryName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->CitizenCountryName) && count($this->CitizenCountryName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->CitizenCountryName)), __LINE__);
        }
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return \StructType\PhysChallName[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * This method is responsible for validating the values passed to the setPhysChallName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhysChallName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhysChallNameForArrayConstraintsFromSetPhysChallName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePhysChallNameItem) {
            // validation for constraint: itemType
            if (!$customerTypePhysChallNameItem instanceof \StructType\PhysChallName) {
                $invalidValues[] = is_object($customerTypePhysChallNameItem) ? get_class($customerTypePhysChallNameItem) : sprintf('%s(%s)', gettype($customerTypePhysChallNameItem), var_export($customerTypePhysChallNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhysChallName property can only contain items of type \StructType\PhysChallName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysChallName[] $physChallName
     * @return \StructType\CustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        // validation for constraint: array
        if ('' !== ($physChallNameArrayErrorMessage = self::validatePhysChallNameForArrayConstraintsFromSetPhysChallName($physChallName))) {
            throw new \InvalidArgumentException($physChallNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($physChallName) && count($physChallName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($physChallName)), __LINE__);
        }
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param \StructType\PhysChallName $item
     * @return \StructType\CustomerType
     */
    public function addToPhysChallName(\StructType\PhysChallName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhysChallName) {
            throw new \InvalidArgumentException(sprintf('The PhysChallName property can only contain items of type \StructType\PhysChallName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PhysChallName) && count($this->PhysChallName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PhysChallName)), __LINE__);
        }
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return mixed[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoForArrayConstraintsFromSetPetInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePetInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($customerTypePetInfoItem) ? get_class($customerTypePetInfoItem) : sprintf('%s(%s)', gettype($customerTypePetInfoItem), var_export($customerTypePetInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $petInfo
     * @return \StructType\CustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoArrayErrorMessage = self::validatePetInfoForArrayConstraintsFromSetPetInfo($petInfo))) {
            throw new \InvalidArgumentException($petInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($petInfo) && count($petInfo) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($petInfo)), __LINE__);
        }
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CustomerType
     */
    public function addToPetInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PetInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->PetInfo) && count($this->PetInfo) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->PetInfo)), __LINE__);
        }
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \StructType\PaymentForm[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$customerTypePaymentFormItem instanceof \StructType\PaymentForm) {
                $invalidValues[] = is_object($customerTypePaymentFormItem) ? get_class($customerTypePaymentFormItem) : sprintf('%s(%s)', gettype($customerTypePaymentFormItem), var_export($customerTypePaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \StructType\PaymentForm, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentForm[] $paymentForm
     * @return \StructType\CustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($paymentForm) && count($paymentForm) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 100', count($paymentForm)), __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentForm $item
     * @return \StructType\CustomerType
     */
    public function addToPaymentForm(\StructType\PaymentForm $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentForm) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \StructType\PaymentForm, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(100)
        if (is_array($this->PaymentForm) && count($this->PaymentForm) >= 100) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 100', count($this->PaymentForm)), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get RelatedTraveler value
     * @return mixed[]|null
     */
    public function getRelatedTraveler()
    {
        return $this->RelatedTraveler;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedTravelerForArrayConstraintsFromSetRelatedTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeRelatedTravelerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($customerTypeRelatedTravelerItem) ? get_class($customerTypeRelatedTravelerItem) : sprintf('%s(%s)', gettype($customerTypeRelatedTravelerItem), var_export($customerTypeRelatedTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedTraveler property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param mixed[] $relatedTraveler
     * @return \StructType\CustomerType
     */
    public function setRelatedTraveler(array $relatedTraveler = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedTravelerArrayErrorMessage = self::validateRelatedTravelerForArrayConstraintsFromSetRelatedTraveler($relatedTraveler))) {
            throw new \InvalidArgumentException($relatedTravelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($relatedTraveler) && count($relatedTraveler) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($relatedTraveler)), __LINE__);
        }
        $this->RelatedTraveler = $relatedTraveler;
        return $this;
    }
    /**
     * Add item to RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CustomerType
     */
    public function addToRelatedTraveler($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RelatedTraveler property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RelatedTraveler) && count($this->RelatedTraveler) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RelatedTraveler)), __LINE__);
        }
        $this->RelatedTraveler[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return mixed[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeContactPersonItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($customerTypeContactPersonItem) ? get_class($customerTypeContactPersonItem) : sprintf('%s(%s)', gettype($customerTypeContactPersonItem), var_export($customerTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param mixed[] $contactPerson
     * @return \StructType\CustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($contactPerson) && count($contactPerson) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($contactPerson)), __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CustomerType
     */
    public function addToContactPerson($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ContactPerson) && count($this->ContactPerson) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ContactPerson)), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return mixed[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeDocumentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($customerTypeDocumentItem) ? get_class($customerTypeDocumentItem) : sprintf('%s(%s)', gettype($customerTypeDocumentItem), var_export($customerTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param mixed[] $document
     * @return \StructType\CustomerType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($document) && count($document) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CustomerType
     */
    public function addToDocument($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Document) && count($this->Document) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Document)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$customerTypeCustLoyaltyItem instanceof \StructType\CustLoyalty) {
                $invalidValues[] = is_object($customerTypeCustLoyaltyItem) ? get_class($customerTypeCustLoyaltyItem) : sprintf('%s(%s)', gettype($customerTypeCustLoyaltyItem), var_export($customerTypeCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty[] $custLoyalty
     * @return \StructType\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(25)
        if (is_array($custLoyalty) && count($custLoyalty) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 25', count($custLoyalty)), __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustLoyalty $item
     * @return \StructType\CustomerType
     */
    public function addToCustLoyalty(\StructType\CustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustLoyalty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(25)
        if (is_array($this->CustLoyalty) && count($this->CustLoyalty) >= 25) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 25', count($this->CustLoyalty)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return mixed[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployeeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployeeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($customerTypeEmployeeInfoItem) ? get_class($customerTypeEmployeeInfoItem) : sprintf('%s(%s)', gettype($customerTypeEmployeeInfoItem), var_export($customerTypeEmployeeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmployeeInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $employeeInfo
     * @return \StructType\CustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($employeeInfoArrayErrorMessage = self::validateEmployeeInfoForArrayConstraintsFromSetEmployeeInfo($employeeInfo))) {
            throw new \InvalidArgumentException($employeeInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($employeeInfo) && count($employeeInfo) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($employeeInfo)), __LINE__);
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CustomerType
     */
    public function addToEmployeeInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->EmployeeInfo) && count($this->EmployeeInfo) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->EmployeeInfo)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return mixed|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param mixed $employerInfo
     * @return \StructType\CustomerType
     */
    public function setEmployerInfo($employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get AdditionalLanguage value
     * @return \StructType\AdditionalLanguage[]|null
     */
    public function getAdditionalLanguage()
    {
        return $this->AdditionalLanguage;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalLanguage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalLanguage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalLanguageForArrayConstraintsFromSetAdditionalLanguage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerTypeAdditionalLanguageItem) {
            // validation for constraint: itemType
            if (!$customerTypeAdditionalLanguageItem instanceof \StructType\AdditionalLanguage) {
                $invalidValues[] = is_object($customerTypeAdditionalLanguageItem) ? get_class($customerTypeAdditionalLanguageItem) : sprintf('%s(%s)', gettype($customerTypeAdditionalLanguageItem), var_export($customerTypeAdditionalLanguageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalLanguage property can only contain items of type \StructType\AdditionalLanguage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalLanguage value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalLanguage[] $additionalLanguage
     * @return \StructType\CustomerType
     */
    public function setAdditionalLanguage(array $additionalLanguage = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalLanguageArrayErrorMessage = self::validateAdditionalLanguageForArrayConstraintsFromSetAdditionalLanguage($additionalLanguage))) {
            throw new \InvalidArgumentException($additionalLanguageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($additionalLanguage) && count($additionalLanguage) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($additionalLanguage)), __LINE__);
        }
        $this->AdditionalLanguage = $additionalLanguage;
        return $this;
    }
    /**
     * Add item to AdditionalLanguage value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalLanguage $item
     * @return \StructType\CustomerType
     */
    public function addToAdditionalLanguage(\StructType\AdditionalLanguage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalLanguage) {
            throw new \InvalidArgumentException(sprintf('The AdditionalLanguage property can only contain items of type \StructType\AdditionalLanguage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->AdditionalLanguage) && count($this->AdditionalLanguage) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->AdditionalLanguage)), __LINE__);
        }
        $this->AdditionalLanguage[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\CustomerType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \StructType\CustomerType
     */
    public function setDeceased($deceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($deceased) && !is_bool($deceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deceased, true), gettype($deceased)), __LINE__);
        }
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \StructType\CustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        // validation for constraint: string
        if (!is_null($lockoutType) && !is_string($lockoutType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockoutType, true), gettype($lockoutType)), __LINE__);
        }
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \StructType\CustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($vIP_Indicator) && !is_bool($vIP_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vIP_Indicator, true), gettype($vIP_Indicator)), __LINE__);
        }
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\CustomerType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \StructType\CustomerType
     */
    public function setCustomerValue($customerValue = null)
    {
        // validation for constraint: string
        if (!is_null($customerValue) && !is_string($customerValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerValue, true), gettype($customerValue)), __LINE__);
        }
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return string|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @param string $maritalStatus
     * @return \StructType\CustomerType
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        // validation for constraint: string
        if (!is_null($maritalStatus) && !is_string($maritalStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maritalStatus, true), gettype($maritalStatus)), __LINE__);
        }
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get PreviouslyMarriedIndicator value
     * @return bool|null
     */
    public function getPreviouslyMarriedIndicator()
    {
        return $this->PreviouslyMarriedIndicator;
    }
    /**
     * Set PreviouslyMarriedIndicator value
     * @param bool $previouslyMarriedIndicator
     * @return \StructType\CustomerType
     */
    public function setPreviouslyMarriedIndicator($previouslyMarriedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($previouslyMarriedIndicator) && !is_bool($previouslyMarriedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($previouslyMarriedIndicator, true), gettype($previouslyMarriedIndicator)), __LINE__);
        }
        $this->PreviouslyMarriedIndicator = $previouslyMarriedIndicator;
        return $this;
    }
    /**
     * Get ChildQuantity value
     * @return int|null
     */
    public function getChildQuantity()
    {
        return $this->ChildQuantity;
    }
    /**
     * Set ChildQuantity value
     * @param int $childQuantity
     * @return \StructType\CustomerType
     */
    public function setChildQuantity($childQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($childQuantity) && !(is_int($childQuantity) || ctype_digit($childQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childQuantity, true), gettype($childQuantity)), __LINE__);
        }
        $this->ChildQuantity = $childQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
