<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseGuestInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains guest information for the specified sailing.
 * @subpackage Structs
 */
class CruiseGuestInfoType extends AbstractStructBase
{
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - documentation: Specifies the reservation control information or the guest's booking ID in modification mode (e.g. PNR Record Locator and/or Vendor Confirmation Number).
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ReservationID;
    /**
     * The GuestDetails
     * @var \StructType\GuestDetails
     */
    public $GuestDetails;
    /**
     * The LinkedBookings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LinkedBookings
     */
    public $LinkedBookings;
    /**
     * The PaymentOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentOptions
     */
    public $PaymentOptions;
    /**
     * The CancellationPenalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CancellationPenalty
     */
    public $CancellationPenalty;
    /**
     * Constructor method for CruiseGuestInfoType
     * @uses CruiseGuestInfoType::setReservationID()
     * @uses CruiseGuestInfoType::setGuestDetails()
     * @uses CruiseGuestInfoType::setLinkedBookings()
     * @uses CruiseGuestInfoType::setPaymentOptions()
     * @uses CruiseGuestInfoType::setCancellationPenalty()
     * @param mixed[] $reservationID
     * @param \StructType\GuestDetails $guestDetails
     * @param \StructType\LinkedBookings $linkedBookings
     * @param \StructType\PaymentOptions $paymentOptions
     * @param \StructType\CancellationPenalty $cancellationPenalty
     */
    public function __construct(array $reservationID = array(), \StructType\GuestDetails $guestDetails = null, \StructType\LinkedBookings $linkedBookings = null, \StructType\PaymentOptions $paymentOptions = null, \StructType\CancellationPenalty $cancellationPenalty = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setGuestDetails($guestDetails)
            ->setLinkedBookings($linkedBookings)
            ->setPaymentOptions($paymentOptions)
            ->setCancellationPenalty($cancellationPenalty);
    }
    /**
     * Get ReservationID value
     * @return mixed[]|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * This method is responsible for validating the values passed to the setReservationID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservationID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservationIDForArrayConstraintsFromSetReservationID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestInfoTypeReservationIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseGuestInfoTypeReservationIDItem) ? get_class($cruiseGuestInfoTypeReservationIDItem) : sprintf('%s(%s)', gettype($cruiseGuestInfoTypeReservationIDItem), var_export($cruiseGuestInfoTypeReservationIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReservationID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReservationID value
     * @throws \InvalidArgumentException
     * @param mixed[] $reservationID
     * @return \StructType\CruiseGuestInfoType
     */
    public function setReservationID(array $reservationID = array())
    {
        // validation for constraint: array
        if ('' !== ($reservationIDArrayErrorMessage = self::validateReservationIDForArrayConstraintsFromSetReservationID($reservationID))) {
            throw new \InvalidArgumentException($reservationIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($reservationID) && count($reservationID) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Add item to ReservationID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseGuestInfoType
     */
    public function addToReservationID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ReservationID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ReservationID) && count($this->ReservationID) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ReservationID)), __LINE__);
        }
        $this->ReservationID[] = $item;
        return $this;
    }
    /**
     * Get GuestDetails value
     * @return \StructType\GuestDetails|null
     */
    public function getGuestDetails()
    {
        return $this->GuestDetails;
    }
    /**
     * Set GuestDetails value
     * @param \StructType\GuestDetails $guestDetails
     * @return \StructType\CruiseGuestInfoType
     */
    public function setGuestDetails(\StructType\GuestDetails $guestDetails = null)
    {
        $this->GuestDetails = $guestDetails;
        return $this;
    }
    /**
     * Get LinkedBookings value
     * @return \StructType\LinkedBookings|null
     */
    public function getLinkedBookings()
    {
        return $this->LinkedBookings;
    }
    /**
     * Set LinkedBookings value
     * @param \StructType\LinkedBookings $linkedBookings
     * @return \StructType\CruiseGuestInfoType
     */
    public function setLinkedBookings(\StructType\LinkedBookings $linkedBookings = null)
    {
        $this->LinkedBookings = $linkedBookings;
        return $this;
    }
    /**
     * Get PaymentOptions value
     * @return \StructType\PaymentOptions|null
     */
    public function getPaymentOptions()
    {
        return $this->PaymentOptions;
    }
    /**
     * Set PaymentOptions value
     * @param \StructType\PaymentOptions $paymentOptions
     * @return \StructType\CruiseGuestInfoType
     */
    public function setPaymentOptions(\StructType\PaymentOptions $paymentOptions = null)
    {
        $this->PaymentOptions = $paymentOptions;
        return $this;
    }
    /**
     * Get CancellationPenalty value
     * @return \StructType\CancellationPenalty|null
     */
    public function getCancellationPenalty()
    {
        return $this->CancellationPenalty;
    }
    /**
     * Set CancellationPenalty value
     * @param \StructType\CancellationPenalty $cancellationPenalty
     * @return \StructType\CruiseGuestInfoType
     */
    public function setCancellationPenalty(\StructType\CancellationPenalty $cancellationPenalty = null)
    {
        $this->CancellationPenalty = $cancellationPenalty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruiseGuestInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
