<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseGuestDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the detail data associated with the guest for a particular sailing.
 * @subpackage Structs
 */
class CruiseGuestDetailType extends AbstractStructBase
{
    /**
     * The SelectedFareCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\SelectedFareCode[]
     */
    public $SelectedFareCode;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\ContactInfo[]
     */
    public $ContactInfo;
    /**
     * The GuestTransportation
     * Meta information extracted from the WSDL
     * - documentation: Guest's mode of transportation.
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var mixed[]
     */
    public $GuestTransportation;
    /**
     * The LoyaltyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\LoyaltyInfo[]
     */
    public $LoyaltyInfo;
    /**
     * The LinkedTraveler
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\LinkedTraveler[]
     */
    public $LinkedTraveler;
    /**
     * The TravelDocument
     * Meta information extracted from the WSDL
     * - documentation: Used for passport, visa, other travel type documents.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TravelDocument;
    /**
     * The SelectedDining
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\SelectedDining[]
     */
    public $SelectedDining;
    /**
     * The SelectedInsurance
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\SelectedInsurance[]
     */
    public $SelectedInsurance;
    /**
     * The SelectedOptions
     * Meta information extracted from the WSDL
     * - documentation: Specifies a gift, amenity, or other options (e.g., include gratuity).
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SelectedOptions;
    /**
     * The SelectedPackages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SelectedPackages
     */
    public $SelectedPackages;
    /**
     * The SelectedSpecialServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SelectedSpecialServices
     */
    public $SelectedSpecialServices;
    /**
     * The AirAccommodations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AirAccommodations
     */
    public $AirAccommodations;
    /**
     * The CruiseDocument
     * Meta information extracted from the WSDL
     * - documentation: Provides information on requested documents, the type of document, method of distribution, and associated costs.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $CruiseDocument;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Profile informations at the guest level.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Profiles;
    /**
     * The GuestExistsIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, guest already exists for this booking. When false, the guest is being added for this booking.
     * - use: optional
     * @var bool
     */
    public $GuestExistsIndicator;
    /**
     * The RepeatGuestIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the customer is a repeat guest. When false, the customer is not a repeat guest.
     * - use: optional
     * @var bool
     */
    public $RepeatGuestIndicator;
    /**
     * Constructor method for CruiseGuestDetailType
     * @uses CruiseGuestDetailType::setSelectedFareCode()
     * @uses CruiseGuestDetailType::setContactInfo()
     * @uses CruiseGuestDetailType::setGuestTransportation()
     * @uses CruiseGuestDetailType::setLoyaltyInfo()
     * @uses CruiseGuestDetailType::setLinkedTraveler()
     * @uses CruiseGuestDetailType::setTravelDocument()
     * @uses CruiseGuestDetailType::setSelectedDining()
     * @uses CruiseGuestDetailType::setSelectedInsurance()
     * @uses CruiseGuestDetailType::setSelectedOptions()
     * @uses CruiseGuestDetailType::setSelectedPackages()
     * @uses CruiseGuestDetailType::setSelectedSpecialServices()
     * @uses CruiseGuestDetailType::setAirAccommodations()
     * @uses CruiseGuestDetailType::setCruiseDocument()
     * @uses CruiseGuestDetailType::setProfiles()
     * @uses CruiseGuestDetailType::setGuestExistsIndicator()
     * @uses CruiseGuestDetailType::setRepeatGuestIndicator()
     * @param \StructType\SelectedFareCode[] $selectedFareCode
     * @param \StructType\ContactInfo[] $contactInfo
     * @param mixed[] $guestTransportation
     * @param \StructType\LoyaltyInfo[] $loyaltyInfo
     * @param \StructType\LinkedTraveler[] $linkedTraveler
     * @param mixed[] $travelDocument
     * @param \StructType\SelectedDining[] $selectedDining
     * @param \StructType\SelectedInsurance[] $selectedInsurance
     * @param mixed[] $selectedOptions
     * @param \StructType\SelectedPackages $selectedPackages
     * @param \StructType\SelectedSpecialServices $selectedSpecialServices
     * @param \StructType\AirAccommodations $airAccommodations
     * @param mixed[] $cruiseDocument
     * @param mixed[] $profiles
     * @param bool $guestExistsIndicator
     * @param bool $repeatGuestIndicator
     */
    public function __construct(array $selectedFareCode = array(), array $contactInfo = array(), array $guestTransportation = array(), array $loyaltyInfo = array(), array $linkedTraveler = array(), array $travelDocument = array(), array $selectedDining = array(), array $selectedInsurance = array(), array $selectedOptions = array(), \StructType\SelectedPackages $selectedPackages = null, \StructType\SelectedSpecialServices $selectedSpecialServices = null, \StructType\AirAccommodations $airAccommodations = null, array $cruiseDocument = array(), array $profiles = array(), $guestExistsIndicator = null, $repeatGuestIndicator = null)
    {
        $this
            ->setSelectedFareCode($selectedFareCode)
            ->setContactInfo($contactInfo)
            ->setGuestTransportation($guestTransportation)
            ->setLoyaltyInfo($loyaltyInfo)
            ->setLinkedTraveler($linkedTraveler)
            ->setTravelDocument($travelDocument)
            ->setSelectedDining($selectedDining)
            ->setSelectedInsurance($selectedInsurance)
            ->setSelectedOptions($selectedOptions)
            ->setSelectedPackages($selectedPackages)
            ->setSelectedSpecialServices($selectedSpecialServices)
            ->setAirAccommodations($airAccommodations)
            ->setCruiseDocument($cruiseDocument)
            ->setProfiles($profiles)
            ->setGuestExistsIndicator($guestExistsIndicator)
            ->setRepeatGuestIndicator($repeatGuestIndicator);
    }
    /**
     * Get SelectedFareCode value
     * @return \StructType\SelectedFareCode[]|null
     */
    public function getSelectedFareCode()
    {
        return $this->SelectedFareCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedFareCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedFareCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedFareCodeForArrayConstraintsFromSetSelectedFareCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeSelectedFareCodeItem) {
            // validation for constraint: itemType
            if (!$cruiseGuestDetailTypeSelectedFareCodeItem instanceof \StructType\SelectedFareCode) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeSelectedFareCodeItem) ? get_class($cruiseGuestDetailTypeSelectedFareCodeItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeSelectedFareCodeItem), var_export($cruiseGuestDetailTypeSelectedFareCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedFareCode property can only contain items of type \StructType\SelectedFareCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedFareCode[] $selectedFareCode
     * @return \StructType\CruiseGuestDetailType
     */
    public function setSelectedFareCode(array $selectedFareCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedFareCodeArrayErrorMessage = self::validateSelectedFareCodeForArrayConstraintsFromSetSelectedFareCode($selectedFareCode))) {
            throw new \InvalidArgumentException($selectedFareCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($selectedFareCode) && count($selectedFareCode) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($selectedFareCode)), __LINE__);
        }
        $this->SelectedFareCode = $selectedFareCode;
        return $this;
    }
    /**
     * Add item to SelectedFareCode value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedFareCode $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToSelectedFareCode(\StructType\SelectedFareCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedFareCode) {
            throw new \InvalidArgumentException(sprintf('The SelectedFareCode property can only contain items of type \StructType\SelectedFareCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->SelectedFareCode) && count($this->SelectedFareCode) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->SelectedFareCode)), __LINE__);
        }
        $this->SelectedFareCode[] = $item;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \StructType\ContactInfo[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeContactInfoItem) {
            // validation for constraint: itemType
            if (!$cruiseGuestDetailTypeContactInfoItem instanceof \StructType\ContactInfo) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeContactInfoItem) ? get_class($cruiseGuestDetailTypeContactInfoItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeContactInfoItem), var_export($cruiseGuestDetailTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfo[] $contactInfo
     * @return \StructType\CruiseGuestDetailType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($contactInfo) && count($contactInfo) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($contactInfo)), __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfo $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToContactInfo(\StructType\ContactInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfo) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type \StructType\ContactInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->ContactInfo) && count($this->ContactInfo) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->ContactInfo)), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Get GuestTransportation value
     * @return mixed[]|null
     */
    public function getGuestTransportation()
    {
        return $this->GuestTransportation;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestTransportation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestTransportation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestTransportationForArrayConstraintsFromSetGuestTransportation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeGuestTransportationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeGuestTransportationItem) ? get_class($cruiseGuestDetailTypeGuestTransportationItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeGuestTransportationItem), var_export($cruiseGuestDetailTypeGuestTransportationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestTransportation property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestTransportation value
     * @throws \InvalidArgumentException
     * @param mixed[] $guestTransportation
     * @return \StructType\CruiseGuestDetailType
     */
    public function setGuestTransportation(array $guestTransportation = array())
    {
        // validation for constraint: array
        if ('' !== ($guestTransportationArrayErrorMessage = self::validateGuestTransportationForArrayConstraintsFromSetGuestTransportation($guestTransportation))) {
            throw new \InvalidArgumentException($guestTransportationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($guestTransportation) && count($guestTransportation) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($guestTransportation)), __LINE__);
        }
        $this->GuestTransportation = $guestTransportation;
        return $this;
    }
    /**
     * Add item to GuestTransportation value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToGuestTransportation($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The GuestTransportation property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->GuestTransportation) && count($this->GuestTransportation) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->GuestTransportation)), __LINE__);
        }
        $this->GuestTransportation[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyInfo value
     * @return \StructType\LoyaltyInfo[]|null
     */
    public function getLoyaltyInfo()
    {
        return $this->LoyaltyInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyInfoForArrayConstraintsFromSetLoyaltyInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeLoyaltyInfoItem) {
            // validation for constraint: itemType
            if (!$cruiseGuestDetailTypeLoyaltyInfoItem instanceof \StructType\LoyaltyInfo) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeLoyaltyInfoItem) ? get_class($cruiseGuestDetailTypeLoyaltyInfoItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeLoyaltyInfoItem), var_export($cruiseGuestDetailTypeLoyaltyInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyInfo property can only contain items of type \StructType\LoyaltyInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyInfo[] $loyaltyInfo
     * @return \StructType\CruiseGuestDetailType
     */
    public function setLoyaltyInfo(array $loyaltyInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyInfoArrayErrorMessage = self::validateLoyaltyInfoForArrayConstraintsFromSetLoyaltyInfo($loyaltyInfo))) {
            throw new \InvalidArgumentException($loyaltyInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($loyaltyInfo) && count($loyaltyInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($loyaltyInfo)), __LINE__);
        }
        $this->LoyaltyInfo = $loyaltyInfo;
        return $this;
    }
    /**
     * Add item to LoyaltyInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\LoyaltyInfo $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToLoyaltyInfo(\StructType\LoyaltyInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LoyaltyInfo) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyInfo property can only contain items of type \StructType\LoyaltyInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->LoyaltyInfo) && count($this->LoyaltyInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->LoyaltyInfo)), __LINE__);
        }
        $this->LoyaltyInfo[] = $item;
        return $this;
    }
    /**
     * Get LinkedTraveler value
     * @return \StructType\LinkedTraveler[]|null
     */
    public function getLinkedTraveler()
    {
        return $this->LinkedTraveler;
    }
    /**
     * This method is responsible for validating the values passed to the setLinkedTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinkedTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkedTravelerForArrayConstraintsFromSetLinkedTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeLinkedTravelerItem) {
            // validation for constraint: itemType
            if (!$cruiseGuestDetailTypeLinkedTravelerItem instanceof \StructType\LinkedTraveler) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeLinkedTravelerItem) ? get_class($cruiseGuestDetailTypeLinkedTravelerItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeLinkedTravelerItem), var_export($cruiseGuestDetailTypeLinkedTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LinkedTraveler property can only contain items of type \StructType\LinkedTraveler, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LinkedTraveler value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkedTraveler[] $linkedTraveler
     * @return \StructType\CruiseGuestDetailType
     */
    public function setLinkedTraveler(array $linkedTraveler = array())
    {
        // validation for constraint: array
        if ('' !== ($linkedTravelerArrayErrorMessage = self::validateLinkedTravelerForArrayConstraintsFromSetLinkedTraveler($linkedTraveler))) {
            throw new \InvalidArgumentException($linkedTravelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($linkedTraveler) && count($linkedTraveler) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($linkedTraveler)), __LINE__);
        }
        $this->LinkedTraveler = $linkedTraveler;
        return $this;
    }
    /**
     * Add item to LinkedTraveler value
     * @throws \InvalidArgumentException
     * @param \StructType\LinkedTraveler $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToLinkedTraveler(\StructType\LinkedTraveler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinkedTraveler) {
            throw new \InvalidArgumentException(sprintf('The LinkedTraveler property can only contain items of type \StructType\LinkedTraveler, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->LinkedTraveler) && count($this->LinkedTraveler) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->LinkedTraveler)), __LINE__);
        }
        $this->LinkedTraveler[] = $item;
        return $this;
    }
    /**
     * Get TravelDocument value
     * @return mixed[]|null
     */
    public function getTravelDocument()
    {
        return $this->TravelDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelDocumentForArrayConstraintsFromSetTravelDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeTravelDocumentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeTravelDocumentItem) ? get_class($cruiseGuestDetailTypeTravelDocumentItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeTravelDocumentItem), var_export($cruiseGuestDetailTypeTravelDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelDocument property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelDocument value
     * @throws \InvalidArgumentException
     * @param mixed[] $travelDocument
     * @return \StructType\CruiseGuestDetailType
     */
    public function setTravelDocument(array $travelDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($travelDocumentArrayErrorMessage = self::validateTravelDocumentForArrayConstraintsFromSetTravelDocument($travelDocument))) {
            throw new \InvalidArgumentException($travelDocumentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($travelDocument) && count($travelDocument) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($travelDocument)), __LINE__);
        }
        $this->TravelDocument = $travelDocument;
        return $this;
    }
    /**
     * Add item to TravelDocument value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToTravelDocument($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TravelDocument property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->TravelDocument) && count($this->TravelDocument) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->TravelDocument)), __LINE__);
        }
        $this->TravelDocument[] = $item;
        return $this;
    }
    /**
     * Get SelectedDining value
     * @return \StructType\SelectedDining[]|null
     */
    public function getSelectedDining()
    {
        return $this->SelectedDining;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedDining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedDining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedDiningForArrayConstraintsFromSetSelectedDining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeSelectedDiningItem) {
            // validation for constraint: itemType
            if (!$cruiseGuestDetailTypeSelectedDiningItem instanceof \StructType\SelectedDining) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeSelectedDiningItem) ? get_class($cruiseGuestDetailTypeSelectedDiningItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeSelectedDiningItem), var_export($cruiseGuestDetailTypeSelectedDiningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedDining property can only contain items of type \StructType\SelectedDining, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedDining value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedDining[] $selectedDining
     * @return \StructType\CruiseGuestDetailType
     */
    public function setSelectedDining(array $selectedDining = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedDiningArrayErrorMessage = self::validateSelectedDiningForArrayConstraintsFromSetSelectedDining($selectedDining))) {
            throw new \InvalidArgumentException($selectedDiningArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($selectedDining) && count($selectedDining) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($selectedDining)), __LINE__);
        }
        $this->SelectedDining = $selectedDining;
        return $this;
    }
    /**
     * Add item to SelectedDining value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedDining $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToSelectedDining(\StructType\SelectedDining $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedDining) {
            throw new \InvalidArgumentException(sprintf('The SelectedDining property can only contain items of type \StructType\SelectedDining, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->SelectedDining) && count($this->SelectedDining) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->SelectedDining)), __LINE__);
        }
        $this->SelectedDining[] = $item;
        return $this;
    }
    /**
     * Get SelectedInsurance value
     * @return \StructType\SelectedInsurance[]|null
     */
    public function getSelectedInsurance()
    {
        return $this->SelectedInsurance;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedInsuranceForArrayConstraintsFromSetSelectedInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeSelectedInsuranceItem) {
            // validation for constraint: itemType
            if (!$cruiseGuestDetailTypeSelectedInsuranceItem instanceof \StructType\SelectedInsurance) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeSelectedInsuranceItem) ? get_class($cruiseGuestDetailTypeSelectedInsuranceItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeSelectedInsuranceItem), var_export($cruiseGuestDetailTypeSelectedInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedInsurance property can only contain items of type \StructType\SelectedInsurance, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedInsurance value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedInsurance[] $selectedInsurance
     * @return \StructType\CruiseGuestDetailType
     */
    public function setSelectedInsurance(array $selectedInsurance = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedInsuranceArrayErrorMessage = self::validateSelectedInsuranceForArrayConstraintsFromSetSelectedInsurance($selectedInsurance))) {
            throw new \InvalidArgumentException($selectedInsuranceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($selectedInsurance) && count($selectedInsurance) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($selectedInsurance)), __LINE__);
        }
        $this->SelectedInsurance = $selectedInsurance;
        return $this;
    }
    /**
     * Add item to SelectedInsurance value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedInsurance $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToSelectedInsurance(\StructType\SelectedInsurance $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedInsurance) {
            throw new \InvalidArgumentException(sprintf('The SelectedInsurance property can only contain items of type \StructType\SelectedInsurance, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->SelectedInsurance) && count($this->SelectedInsurance) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->SelectedInsurance)), __LINE__);
        }
        $this->SelectedInsurance[] = $item;
        return $this;
    }
    /**
     * Get SelectedOptions value
     * @return mixed[]|null
     */
    public function getSelectedOptions()
    {
        return $this->SelectedOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOptionsForArrayConstraintsFromSetSelectedOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeSelectedOptionsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeSelectedOptionsItem) ? get_class($cruiseGuestDetailTypeSelectedOptionsItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeSelectedOptionsItem), var_export($cruiseGuestDetailTypeSelectedOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOptions property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOptions value
     * @throws \InvalidArgumentException
     * @param mixed[] $selectedOptions
     * @return \StructType\CruiseGuestDetailType
     */
    public function setSelectedOptions(array $selectedOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOptionsArrayErrorMessage = self::validateSelectedOptionsForArrayConstraintsFromSetSelectedOptions($selectedOptions))) {
            throw new \InvalidArgumentException($selectedOptionsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($selectedOptions) && count($selectedOptions) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($selectedOptions)), __LINE__);
        }
        $this->SelectedOptions = $selectedOptions;
        return $this;
    }
    /**
     * Add item to SelectedOptions value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToSelectedOptions($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SelectedOptions property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->SelectedOptions) && count($this->SelectedOptions) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->SelectedOptions)), __LINE__);
        }
        $this->SelectedOptions[] = $item;
        return $this;
    }
    /**
     * Get SelectedPackages value
     * @return \StructType\SelectedPackages|null
     */
    public function getSelectedPackages()
    {
        return $this->SelectedPackages;
    }
    /**
     * Set SelectedPackages value
     * @param \StructType\SelectedPackages $selectedPackages
     * @return \StructType\CruiseGuestDetailType
     */
    public function setSelectedPackages(\StructType\SelectedPackages $selectedPackages = null)
    {
        $this->SelectedPackages = $selectedPackages;
        return $this;
    }
    /**
     * Get SelectedSpecialServices value
     * @return \StructType\SelectedSpecialServices|null
     */
    public function getSelectedSpecialServices()
    {
        return $this->SelectedSpecialServices;
    }
    /**
     * Set SelectedSpecialServices value
     * @param \StructType\SelectedSpecialServices $selectedSpecialServices
     * @return \StructType\CruiseGuestDetailType
     */
    public function setSelectedSpecialServices(\StructType\SelectedSpecialServices $selectedSpecialServices = null)
    {
        $this->SelectedSpecialServices = $selectedSpecialServices;
        return $this;
    }
    /**
     * Get AirAccommodations value
     * @return \StructType\AirAccommodations|null
     */
    public function getAirAccommodations()
    {
        return $this->AirAccommodations;
    }
    /**
     * Set AirAccommodations value
     * @param \StructType\AirAccommodations $airAccommodations
     * @return \StructType\CruiseGuestDetailType
     */
    public function setAirAccommodations(\StructType\AirAccommodations $airAccommodations = null)
    {
        $this->AirAccommodations = $airAccommodations;
        return $this;
    }
    /**
     * Get CruiseDocument value
     * @return mixed[]|null
     */
    public function getCruiseDocument()
    {
        return $this->CruiseDocument;
    }
    /**
     * This method is responsible for validating the values passed to the setCruiseDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCruiseDocumentForArrayConstraintsFromSetCruiseDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeCruiseDocumentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeCruiseDocumentItem) ? get_class($cruiseGuestDetailTypeCruiseDocumentItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeCruiseDocumentItem), var_export($cruiseGuestDetailTypeCruiseDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CruiseDocument property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CruiseDocument value
     * @throws \InvalidArgumentException
     * @param mixed[] $cruiseDocument
     * @return \StructType\CruiseGuestDetailType
     */
    public function setCruiseDocument(array $cruiseDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($cruiseDocumentArrayErrorMessage = self::validateCruiseDocumentForArrayConstraintsFromSetCruiseDocument($cruiseDocument))) {
            throw new \InvalidArgumentException($cruiseDocumentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($cruiseDocument) && count($cruiseDocument) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($cruiseDocument)), __LINE__);
        }
        $this->CruiseDocument = $cruiseDocument;
        return $this;
    }
    /**
     * Add item to CruiseDocument value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToCruiseDocument($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CruiseDocument property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->CruiseDocument) && count($this->CruiseDocument) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->CruiseDocument)), __LINE__);
        }
        $this->CruiseDocument[] = $item;
        return $this;
    }
    /**
     * Get Profiles value
     * @return mixed[]|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * This method is responsible for validating the values passed to the setProfiles method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfiles method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfilesForArrayConstraintsFromSetProfiles(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseGuestDetailTypeProfilesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseGuestDetailTypeProfilesItem) ? get_class($cruiseGuestDetailTypeProfilesItem) : sprintf('%s(%s)', gettype($cruiseGuestDetailTypeProfilesItem), var_export($cruiseGuestDetailTypeProfilesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Profiles property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Profiles value
     * @throws \InvalidArgumentException
     * @param mixed[] $profiles
     * @return \StructType\CruiseGuestDetailType
     */
    public function setProfiles(array $profiles = array())
    {
        // validation for constraint: array
        if ('' !== ($profilesArrayErrorMessage = self::validateProfilesForArrayConstraintsFromSetProfiles($profiles))) {
            throw new \InvalidArgumentException($profilesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($profiles) && count($profiles) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($profiles)), __LINE__);
        }
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Add item to Profiles value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseGuestDetailType
     */
    public function addToProfiles($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Profiles property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Profiles) && count($this->Profiles) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Profiles)), __LINE__);
        }
        $this->Profiles[] = $item;
        return $this;
    }
    /**
     * Get GuestExistsIndicator value
     * @return bool|null
     */
    public function getGuestExistsIndicator()
    {
        return $this->GuestExistsIndicator;
    }
    /**
     * Set GuestExistsIndicator value
     * @param bool $guestExistsIndicator
     * @return \StructType\CruiseGuestDetailType
     */
    public function setGuestExistsIndicator($guestExistsIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($guestExistsIndicator) && !is_bool($guestExistsIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guestExistsIndicator, true), gettype($guestExistsIndicator)), __LINE__);
        }
        $this->GuestExistsIndicator = $guestExistsIndicator;
        return $this;
    }
    /**
     * Get RepeatGuestIndicator value
     * @return bool|null
     */
    public function getRepeatGuestIndicator()
    {
        return $this->RepeatGuestIndicator;
    }
    /**
     * Set RepeatGuestIndicator value
     * @param bool $repeatGuestIndicator
     * @return \StructType\CruiseGuestDetailType
     */
    public function setRepeatGuestIndicator($repeatGuestIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($repeatGuestIndicator) && !is_bool($repeatGuestIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($repeatGuestIndicator, true), gettype($repeatGuestIndicator)), __LINE__);
        }
        $this->RepeatGuestIndicator = $repeatGuestIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruiseGuestDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
