<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseBookingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains pricing and payment information for the booking.
 * @subpackage Structs
 */
class CruiseBookingInfoType extends AbstractStructBase
{
    /**
     * The BookingPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingPrices
     */
    public $BookingPrices;
    /**
     * The PaymentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentSchedule
     */
    public $PaymentSchedule;
    /**
     * The GuestPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuestPrices
     */
    public $GuestPrices;
    /**
     * The PolicyInfo
     * Meta information extracted from the WSDL
     * - documentation: May be used to provide price policy information.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PolicyInfo;
    /**
     * Constructor method for CruiseBookingInfoType
     * @uses CruiseBookingInfoType::setBookingPrices()
     * @uses CruiseBookingInfoType::setPaymentSchedule()
     * @uses CruiseBookingInfoType::setGuestPrices()
     * @uses CruiseBookingInfoType::setPolicyInfo()
     * @param \StructType\BookingPrices $bookingPrices
     * @param \StructType\PaymentSchedule $paymentSchedule
     * @param \StructType\GuestPrices $guestPrices
     * @param mixed[] $policyInfo
     */
    public function __construct(\StructType\BookingPrices $bookingPrices = null, \StructType\PaymentSchedule $paymentSchedule = null, \StructType\GuestPrices $guestPrices = null, array $policyInfo = array())
    {
        $this
            ->setBookingPrices($bookingPrices)
            ->setPaymentSchedule($paymentSchedule)
            ->setGuestPrices($guestPrices)
            ->setPolicyInfo($policyInfo);
    }
    /**
     * Get BookingPrices value
     * @return \StructType\BookingPrices|null
     */
    public function getBookingPrices()
    {
        return $this->BookingPrices;
    }
    /**
     * Set BookingPrices value
     * @param \StructType\BookingPrices $bookingPrices
     * @return \StructType\CruiseBookingInfoType
     */
    public function setBookingPrices(\StructType\BookingPrices $bookingPrices = null)
    {
        $this->BookingPrices = $bookingPrices;
        return $this;
    }
    /**
     * Get PaymentSchedule value
     * @return \StructType\PaymentSchedule|null
     */
    public function getPaymentSchedule()
    {
        return $this->PaymentSchedule;
    }
    /**
     * Set PaymentSchedule value
     * @param \StructType\PaymentSchedule $paymentSchedule
     * @return \StructType\CruiseBookingInfoType
     */
    public function setPaymentSchedule(\StructType\PaymentSchedule $paymentSchedule = null)
    {
        $this->PaymentSchedule = $paymentSchedule;
        return $this;
    }
    /**
     * Get GuestPrices value
     * @return \StructType\GuestPrices|null
     */
    public function getGuestPrices()
    {
        return $this->GuestPrices;
    }
    /**
     * Set GuestPrices value
     * @param \StructType\GuestPrices $guestPrices
     * @return \StructType\CruiseBookingInfoType
     */
    public function setGuestPrices(\StructType\GuestPrices $guestPrices = null)
    {
        $this->GuestPrices = $guestPrices;
        return $this;
    }
    /**
     * Get PolicyInfo value
     * @return mixed[]|null
     */
    public function getPolicyInfo()
    {
        return $this->PolicyInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicyInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicyInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyInfoForArrayConstraintsFromSetPolicyInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cruiseBookingInfoTypePolicyInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($cruiseBookingInfoTypePolicyInfoItem) ? get_class($cruiseBookingInfoTypePolicyInfoItem) : sprintf('%s(%s)', gettype($cruiseBookingInfoTypePolicyInfoItem), var_export($cruiseBookingInfoTypePolicyInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PolicyInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PolicyInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $policyInfo
     * @return \StructType\CruiseBookingInfoType
     */
    public function setPolicyInfo(array $policyInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($policyInfoArrayErrorMessage = self::validatePolicyInfoForArrayConstraintsFromSetPolicyInfo($policyInfo))) {
            throw new \InvalidArgumentException($policyInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($policyInfo) && count($policyInfo) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($policyInfo)), __LINE__);
        }
        $this->PolicyInfo = $policyInfo;
        return $this;
    }
    /**
     * Add item to PolicyInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CruiseBookingInfoType
     */
    public function addToPolicyInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PolicyInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->PolicyInfo) && count($this->PolicyInfo) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->PolicyInfo)), __LINE__);
        }
        $this->PolicyInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CruiseBookingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
