<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardAuthorization StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the amount of money for which the the requester is seeking authorization. | Specifies credit card information about the customer seeking authorization.
 * @subpackage Structs
 */
class CreditCardAuthorization extends AbstractStructBase
{
    /**
     * The CreditCard
     * Meta information extracted from the WSDL
     * - documentation: Specifies the credit card information for which authorization is required.
     * @var mixed
     */
    public $CreditCard;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Identification of an authorization party (e.g., merchant, acquirer).
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ID;
    /**
     * The SourceType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SourceType;
    /**
     * The ExtendedPaymentInd
     * Meta information extracted from the WSDL
     * - documentation: If true, the requester would like to apply extended payment conditions to this authorization.
     * - use: optional
     * @var bool
     */
    public $ExtendedPaymentInd;
    /**
     * The ExtendedPaymentQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of equal amount, partial payments for the extended payment.
     * - use: optional
     * @var int
     */
    public $ExtendedPaymentQuantity;
    /**
     * The ExtendedPaymentFrequency
     * Meta information extracted from the WSDL
     * - documentation: The frequency of extended payment installments.
     * - use: optional
     * @var string
     */
    public $ExtendedPaymentFrequency;
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [A-Za-z0-9]{1,12}
     * - use: optional
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The ReversalIndicator
     * Meta information extracted from the WSDL
     * - documentation: If true, indicates a request to reverse a credit authorization.
     * - use: optional
     * @var bool
     */
    public $ReversalIndicator;
    /**
     * The CardPresentInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the customer has actually presented the credit card.
     * - use: optional
     * @var bool
     */
    public $CardPresentInd;
    /**
     * The E_CommerceCode
     * Meta information extracted from the WSDL
     * - documentation: The electronic commerce indicator required for some credit card authorizations, such as the Verified by Visa Process.
     * - use: optional
     * @var string
     */
    public $E_CommerceCode;
    /**
     * The AuthTransactionID
     * Meta information extracted from the WSDL
     * - documentation: The authentication transaction identifier required for some credit card authorizations, such as the Verified by Visa Process.
     * - use: optional
     * @var string
     */
    public $AuthTransactionID;
    /**
     * The AuthVerificationValue
     * Meta information extracted from the WSDL
     * - documentation: The cardholder authentication verfication value required for some credit card authorization, such as the Verified by Visa Process.
     * - use: optional
     * @var string
     */
    public $AuthVerificationValue;
    /**
     * Constructor method for CreditCardAuthorization
     * @uses CreditCardAuthorization::setCreditCard()
     * @uses CreditCardAuthorization::setID()
     * @uses CreditCardAuthorization::setSourceType()
     * @uses CreditCardAuthorization::setExtendedPaymentInd()
     * @uses CreditCardAuthorization::setExtendedPaymentQuantity()
     * @uses CreditCardAuthorization::setExtendedPaymentFrequency()
     * @uses CreditCardAuthorization::setAuthorizationCode()
     * @uses CreditCardAuthorization::setReversalIndicator()
     * @uses CreditCardAuthorization::setCardPresentInd()
     * @uses CreditCardAuthorization::setE_CommerceCode()
     * @uses CreditCardAuthorization::setAuthTransactionID()
     * @uses CreditCardAuthorization::setAuthVerificationValue()
     * @param mixed $creditCard
     * @param mixed[] $iD
     * @param string $sourceType
     * @param bool $extendedPaymentInd
     * @param int $extendedPaymentQuantity
     * @param string $extendedPaymentFrequency
     * @param string $authorizationCode
     * @param bool $reversalIndicator
     * @param bool $cardPresentInd
     * @param string $e_CommerceCode
     * @param string $authTransactionID
     * @param string $authVerificationValue
     */
    public function __construct($creditCard = null, array $iD = array(), $sourceType = null, $extendedPaymentInd = null, $extendedPaymentQuantity = null, $extendedPaymentFrequency = null, $authorizationCode = null, $reversalIndicator = null, $cardPresentInd = null, $e_CommerceCode = null, $authTransactionID = null, $authVerificationValue = null)
    {
        $this
            ->setCreditCard($creditCard)
            ->setID($iD)
            ->setSourceType($sourceType)
            ->setExtendedPaymentInd($extendedPaymentInd)
            ->setExtendedPaymentQuantity($extendedPaymentQuantity)
            ->setExtendedPaymentFrequency($extendedPaymentFrequency)
            ->setAuthorizationCode($authorizationCode)
            ->setReversalIndicator($reversalIndicator)
            ->setCardPresentInd($cardPresentInd)
            ->setE_CommerceCode($e_CommerceCode)
            ->setAuthTransactionID($authTransactionID)
            ->setAuthVerificationValue($authVerificationValue);
    }
    /**
     * Get CreditCard value
     * @return mixed|null
     */
    public function getCreditCard()
    {
        return $this->CreditCard;
    }
    /**
     * Set CreditCard value
     * @param mixed $creditCard
     * @return \StructType\CreditCardAuthorization
     */
    public function setCreditCard($creditCard = null)
    {
        $this->CreditCard = $creditCard;
        return $this;
    }
    /**
     * Get ID value
     * @return mixed[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $creditCardAuthorizationIDItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($creditCardAuthorizationIDItem) ? get_class($creditCardAuthorizationIDItem) : sprintf('%s(%s)', gettype($creditCardAuthorizationIDItem), var_export($creditCardAuthorizationIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param mixed[] $iD
     * @return \StructType\CreditCardAuthorization
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($iD) && count($iD) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CreditCardAuthorization
     */
    public function addToID($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->ID) && count($this->ID) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->ID)), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get SourceType value
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->SourceType;
    }
    /**
     * Set SourceType value
     * @param string $sourceType
     * @return \StructType\CreditCardAuthorization
     */
    public function setSourceType($sourceType = null)
    {
        // validation for constraint: string
        if (!is_null($sourceType) && !is_string($sourceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceType, true), gettype($sourceType)), __LINE__);
        }
        $this->SourceType = $sourceType;
        return $this;
    }
    /**
     * Get ExtendedPaymentInd value
     * @return bool|null
     */
    public function getExtendedPaymentInd()
    {
        return $this->ExtendedPaymentInd;
    }
    /**
     * Set ExtendedPaymentInd value
     * @param bool $extendedPaymentInd
     * @return \StructType\CreditCardAuthorization
     */
    public function setExtendedPaymentInd($extendedPaymentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedPaymentInd) && !is_bool($extendedPaymentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($extendedPaymentInd, true), gettype($extendedPaymentInd)), __LINE__);
        }
        $this->ExtendedPaymentInd = $extendedPaymentInd;
        return $this;
    }
    /**
     * Get ExtendedPaymentQuantity value
     * @return int|null
     */
    public function getExtendedPaymentQuantity()
    {
        return $this->ExtendedPaymentQuantity;
    }
    /**
     * Set ExtendedPaymentQuantity value
     * @param int $extendedPaymentQuantity
     * @return \StructType\CreditCardAuthorization
     */
    public function setExtendedPaymentQuantity($extendedPaymentQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($extendedPaymentQuantity) && !(is_int($extendedPaymentQuantity) || ctype_digit($extendedPaymentQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extendedPaymentQuantity, true), gettype($extendedPaymentQuantity)), __LINE__);
        }
        $this->ExtendedPaymentQuantity = $extendedPaymentQuantity;
        return $this;
    }
    /**
     * Get ExtendedPaymentFrequency value
     * @return string|null
     */
    public function getExtendedPaymentFrequency()
    {
        return $this->ExtendedPaymentFrequency;
    }
    /**
     * Set ExtendedPaymentFrequency value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $extendedPaymentFrequency
     * @return \StructType\CreditCardAuthorization
     */
    public function setExtendedPaymentFrequency($extendedPaymentFrequency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($extendedPaymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($extendedPaymentFrequency) ? implode(', ', $extendedPaymentFrequency) : var_export($extendedPaymentFrequency, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->ExtendedPaymentFrequency = $extendedPaymentFrequency;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\CreditCardAuthorization
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Za-z0-9]{1,12})
        if (!is_null($authorizationCode) && !preg_match('/[A-Za-z0-9]{1,12}/', $authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Za-z0-9]{1,12}', var_export($authorizationCode, true)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get ReversalIndicator value
     * @return bool|null
     */
    public function getReversalIndicator()
    {
        return $this->ReversalIndicator;
    }
    /**
     * Set ReversalIndicator value
     * @param bool $reversalIndicator
     * @return \StructType\CreditCardAuthorization
     */
    public function setReversalIndicator($reversalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($reversalIndicator) && !is_bool($reversalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reversalIndicator, true), gettype($reversalIndicator)), __LINE__);
        }
        $this->ReversalIndicator = $reversalIndicator;
        return $this;
    }
    /**
     * Get CardPresentInd value
     * @return bool|null
     */
    public function getCardPresentInd()
    {
        return $this->CardPresentInd;
    }
    /**
     * Set CardPresentInd value
     * @param bool $cardPresentInd
     * @return \StructType\CreditCardAuthorization
     */
    public function setCardPresentInd($cardPresentInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($cardPresentInd) && !is_bool($cardPresentInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cardPresentInd, true), gettype($cardPresentInd)), __LINE__);
        }
        $this->CardPresentInd = $cardPresentInd;
        return $this;
    }
    /**
     * Get E_CommerceCode value
     * @return string|null
     */
    public function getE_CommerceCode()
    {
        return $this->E_CommerceCode;
    }
    /**
     * Set E_CommerceCode value
     * @param string $e_CommerceCode
     * @return \StructType\CreditCardAuthorization
     */
    public function setE_CommerceCode($e_CommerceCode = null)
    {
        // validation for constraint: string
        if (!is_null($e_CommerceCode) && !is_string($e_CommerceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e_CommerceCode, true), gettype($e_CommerceCode)), __LINE__);
        }
        $this->E_CommerceCode = $e_CommerceCode;
        return $this;
    }
    /**
     * Get AuthTransactionID value
     * @return string|null
     */
    public function getAuthTransactionID()
    {
        return $this->AuthTransactionID;
    }
    /**
     * Set AuthTransactionID value
     * @param string $authTransactionID
     * @return \StructType\CreditCardAuthorization
     */
    public function setAuthTransactionID($authTransactionID = null)
    {
        // validation for constraint: string
        if (!is_null($authTransactionID) && !is_string($authTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authTransactionID, true), gettype($authTransactionID)), __LINE__);
        }
        $this->AuthTransactionID = $authTransactionID;
        return $this;
    }
    /**
     * Get AuthVerificationValue value
     * @return string|null
     */
    public function getAuthVerificationValue()
    {
        return $this->AuthVerificationValue;
    }
    /**
     * Set AuthVerificationValue value
     * @param string $authVerificationValue
     * @return \StructType\CreditCardAuthorization
     */
    public function setAuthVerificationValue($authVerificationValue = null)
    {
        // validation for constraint: string
        if (!is_null($authVerificationValue) && !is_string($authVerificationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authVerificationValue, true), gettype($authVerificationValue)), __LINE__);
        }
        $this->AuthVerificationValue = $authVerificationValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCardAuthorization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
