<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageType StructType
 * Meta information extracted from the WSDL
 * - documentation: The CoverageType complex type describes the data that is needed to fully describe a vehicle coverage, including the core details along with optional descriptions.
 * - type: OTA_CodeType
 * - use: required
 * @subpackage Structs
 */
class CoverageType extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Textual information about coverage, such as coverage limit or descriptions.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Details;
    /**
     * Constructor method for CoverageType
     * @uses CoverageType::setDetails()
     * @param mixed[] $details
     */
    public function __construct(array $details = array())
    {
        $this
            ->setDetails($details);
    }
    /**
     * Get Details value
     * @return mixed[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * This method is responsible for validating the values passed to the setDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailsForArrayConstraintsFromSetDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coverageTypeDetailsItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($coverageTypeDetailsItem) ? get_class($coverageTypeDetailsItem) : sprintf('%s(%s)', gettype($coverageTypeDetailsItem), var_export($coverageTypeDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Details property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param mixed[] $details
     * @return \StructType\CoverageType
     */
    public function setDetails(array $details = array())
    {
        // validation for constraint: array
        if ('' !== ($detailsArrayErrorMessage = self::validateDetailsForArrayConstraintsFromSetDetails($details))) {
            throw new \InvalidArgumentException($detailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($details) && count($details) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($details)), __LINE__);
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CoverageType
     */
    public function addToDetails($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Details property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Details) && count($this->Details) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Details)), __LINE__);
        }
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoverageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
