<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoveragePrefs StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates the preferences for one or more types of coverage (insurance).
 * @subpackage Structs
 */
class CoveragePrefs extends AbstractStructBase
{
    /**
     * The CoveragePref
     * Meta information extracted from the WSDL
     * - maxOccurs: 30
     * @var \StructType\CoveragePref[]
     */
    public $CoveragePref;
    /**
     * Constructor method for CoveragePrefs
     * @uses CoveragePrefs::setCoveragePref()
     * @param \StructType\CoveragePref[] $coveragePref
     */
    public function __construct(array $coveragePref = array())
    {
        $this
            ->setCoveragePref($coveragePref);
    }
    /**
     * Get CoveragePref value
     * @return \StructType\CoveragePref[]|null
     */
    public function getCoveragePref()
    {
        return $this->CoveragePref;
    }
    /**
     * This method is responsible for validating the values passed to the setCoveragePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoveragePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoveragePrefForArrayConstraintsFromSetCoveragePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $coveragePrefsCoveragePrefItem) {
            // validation for constraint: itemType
            if (!$coveragePrefsCoveragePrefItem instanceof \StructType\CoveragePref) {
                $invalidValues[] = is_object($coveragePrefsCoveragePrefItem) ? get_class($coveragePrefsCoveragePrefItem) : sprintf('%s(%s)', gettype($coveragePrefsCoveragePrefItem), var_export($coveragePrefsCoveragePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CoveragePref property can only contain items of type \StructType\CoveragePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CoveragePref value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveragePref[] $coveragePref
     * @return \StructType\CoveragePrefs
     */
    public function setCoveragePref(array $coveragePref = array())
    {
        // validation for constraint: array
        if ('' !== ($coveragePrefArrayErrorMessage = self::validateCoveragePrefForArrayConstraintsFromSetCoveragePref($coveragePref))) {
            throw new \InvalidArgumentException($coveragePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($coveragePref) && count($coveragePref) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($coveragePref)), __LINE__);
        }
        $this->CoveragePref = $coveragePref;
        return $this;
    }
    /**
     * Add item to CoveragePref value
     * @throws \InvalidArgumentException
     * @param \StructType\CoveragePref $item
     * @return \StructType\CoveragePrefs
     */
    public function addToCoveragePref(\StructType\CoveragePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CoveragePref) {
            throw new \InvalidArgumentException(sprintf('The CoveragePref property can only contain items of type \StructType\CoveragePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->CoveragePref) && count($this->CoveragePref) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->CoveragePref)), __LINE__);
        }
        $this->CoveragePref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CoveragePrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
